/*
 * Js-Map 1.0.2 - JavaScript Vector Map
 * Copyright (c) 2013 comersis (http://comersis.com)
 */

/*
 *	CONFIGURATION GENERALE
 */ 
		var mapfill = '#EEFF00'; // couleur de fond de carte
		var mapoff = '#dddddd';
		var mapstroke = '#FFFFFF';
		var hover_fill = '#FFFFFF';
		var mapstroke_width = 2.5;
		
		var txtfill = '#FFFFFF'; // couleur de remplissage de la bulle texte
		var txtstroke = '#6699CC'; // couleur de contours de la bulle texte
		var txtfont = '#000000'; // couleur des caracteres de la bulle texte

		var mapWidth = 300; // Largeur de la carte.
		var mapHeight = (mapWidth/0.92); // calcule la hauteur de carte.

var paths = {

		D1: {
				title: "Ain 01",
				coul: "#FF0000",
				target: "_self",
				url: "http://comersis.fr",
				path: "M 354,217.8 C 345.4,230.1 337.3,229.6 329.6,216.5 L 319.1,216.5 C 316.9,221 314.4,224.6 311.4,227.3 C 310.9,235.7 315.2,242.9 324.3,248.9 C 329,251.9 334.9,254.6 342.1,257 C 345,252.8 347.4,248.9 349.5,245.3 C 357.3,231.4 358.8,222.3 354,217.8 z"
				},
				D2: {
				title: "Aisne 02",
				coul: "#6699CC",
				target: "_self",
				url: "",
				path: "M 258.7,69.5 C 259.3,77.9 258.9,87 257.6,96.5 C 262.9,101.3 266.7,105.9 268.9,110.4 C 276.1,100.6 281.6,91.2 285.1,82.3 C 288.9,72.8 290.8,63.2 290.9,53.6 L 290.9,53.6 C 275.4,50.7 263.9,51.1 256.4,54.8 C 257.5,59.5 258.3,64.4 258.7,69.5 z "
				},
				D3: {
				title: "Allier 03",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 278.1,210.3 C 271.8,211.5 263.9,209.3 254.3,203.8 C 250.9,213.6 243.9,221 233.5,225.9 C 236.9,228.2 240.1,231.2 243.1,235 C 259.3,233.5 270.9,236.6 278.1,244.5 C 280.9,239.6 283,235.2 284.3,231.3 C 287.4,221.2 285.4,214.2 278.1,210.3 z "
				},
				D4: {
				title: "Alpes-de-Haute-Provence 04",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 388.2,310.5 C 386.6,308.1 385.1,305.4 383.7,302.3 C 371.6,311.8 359.8,318.1 348.3,321.5 C 345.3,322.3 342.3,323 339.4,323.5 C 338.6,332.5 341.7,340.2 348.9,346.7 C 358.3,346.5 368.6,344.7 379.6,341 L 388.2,310.5 z "
				},
				D5: {
				title: "Hautes-Alpes 05",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 377.1,280.5 L 363.3,279.5 C 364.5,286.7 360.1,293.5 350.1,300 C 337.9,308.3 337.3,315.5 348.3,321.5 C 359.8,318.1 371.6,311.8 383.7,302.3 C 381,296.3 378.8,289 377.1,280.5 z "
				},
				D6: {
				title: "Alpes-Maritimes 06",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 388.2,310.5 L 379.6,341 L 393.4,358.9 C 401.6,350.7 408.5,339.2 414.1,324.5 C 403.4,324.7 394.8,320 388.2,310.5 z "
				},
				D7: {
				title: "Ardèche 07",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 314.1,270.5 C 312.5,273.3 310.8,275.9 309.1,278.3 C 302.1,288.4 294.3,295.4 285.6,299.5 C 285.1,305.6 286.1,310.5 288.4,314 C 292.2,319.6 299.4,322 310.1,321 C 317.3,299.2 318.6,282.3 314.1,270.5 z "
				},
				D8: {
				title: "Ardennes 08",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 285.1,82.3 C 291.9,88.4 301.8,91.2 314.9,90.8 C 316.3,82.2 320.1,76 326.1,72.3 C 313.5,65 308,57 309.7,48.3 C 299.9,55.3 293.6,57 290.9,53.6 C 290.8,63.2 288.9,72.8 285.1,82.3 z "
				},
				D9: {
				title: "Ariège 09",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 223.6,395.9 C 223.8,380.8 219.2,371.2 209.6,367.1 C 197.9,371.8 188.2,379.3 180.6,389.5 C 192.2,396.6 203,402 213,405.7 C 216.3,401.8 219.8,398.6 223.6,395.9 z "
				},
				D10: {
				title: "Aube 10",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 311.4,146.1 C 308.8,139.2 306.9,130.4 305.9,119.9 C 295.4,123.2 283.8,122.9 271.1,119 C 271.3,123.1 270.1,127.1 267.6,131 C 275.4,144 284.7,150.4 295.6,150.3 C 300.6,150.2 305.8,148.8 311.4,146.1 z "
				},
				D11: {
				title: "Aude 11",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 209.6,367.1 C 219.2,371.2 223.8,380.8 223.6,395.9 C 234.6,388.1 247.5,385.5 262.4,388.1 C 262.9,382.3 264.4,377.5 266.8,373.5 C 252.1,371.9 243.9,367.8 242.1,361 C 236.1,361.1 230.5,361.7 225.3,362.6 C 219.7,363.6 214.5,365.1 209.6,367.1 z "
				},
				D12: {
				title: "Aveyron 12",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 240.6,304.5 L 228.4,307.5 C 228.2,312.2 227.2,316.6 225.4,320.7 C 234.2,336.8 244.4,347.1 255.8,351.6 C 261.4,347 265.3,342.6 267.4,338.2 C 269.3,334.4 269.9,330.7 269.2,327.1 C 261.3,323.7 256.9,316.2 256.1,304.5 C 249.6,288 244.5,288 240.6,304.5 z "
				},
				D13: {
				title: "Bouches-du-Rhône 13",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 348.9,346.7 C 335.8,346.9 324.2,343.6 314.1,337 C 312.3,345 306.7,353 297.2,360.9 C 301.4,361.1 306.1,361.6 311.1,362.5 C 325.3,369.6 338.2,373.6 349.9,374.5 C 346.3,366.5 345.9,357.2 348.9,346.7 z "
				},
				D14: {
				title: "Calvados 14",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 182.8,103.9 C 180.3,96.5 177,88.8 172.9,80.8 C 152.8,86.9 139.1,87.6 131.8,82.9 C 135.8,95.4 137.6,105.2 137.2,112.1 C 151.1,104.1 166.2,101.3 182.8,103.9 z "
				},
				D15: {
				title: "Cantal 15",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 269.3,288.6 C 265.7,284.5 262.1,279.3 258.6,273 C 250.7,271.6 245.1,268.8 241.7,264.8 C 236.5,275.3 231,282.6 225.2,286.6 C 227.4,293.4 228.5,299.7 228.5,305.5 C 228.4,306.1 228.4,306.8 228.4,307.5 L 240.6,304.5 C 244.5,288 249.6,288 256.1,304.5 C 256.5,296.6 260.9,291.3 269.3,288.6 z "
				},
				D16: {
				title: "Charente 16",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 156.3,239.9 C 141,247.1 141.2,260.8 157.1,281 C 167.7,271.3 175.4,262.9 180.3,255.9 C 186.8,246.5 188.3,239.5 184.6,235 C 177.1,238.1 170.3,239.8 164.1,240.2 C 161.4,240.3 158.8,240.2 156.3,239.9 z "
				},
				D17: {
				title: "Charente-Maritime 17",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 156.3,239.9 C 147.5,238.5 140.2,233.9 134.6,225.8 C 131.1,227.7 126.3,228.6 120.1,228.5 C 120.1,239.8 119.9,250.5 119.4,260.6 C 135.3,278 147.8,284.8 157.1,281 C 141.2,260.8 141,247.1 156.3,239.9 z "
				},
				D18: {
				title: "Cher 18",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 229.6,167.8 C 231,176.8 226.9,182.5 217.4,185 C 229.7,197.6 232.8,210.1 226.5,222.7 C 228.9,223.4 231.2,224.5 233.5,225.9 C 243.9,221 250.9,213.6 254.3,203.8 C 257.6,194.4 257.6,182.8 254.6,169 C 244.7,169.9 236.4,169.5 229.6,167.8 z "
				},
				D19: {
				title: "Corrèze 19",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 204.6,287.5 C 211.8,291.4 218.7,291.1 225.2,286.6 C 231,282.6 236.5,275.3 241.7,264.8 C 239.8,262.4 238.6,259.6 238.2,256.4 C 232.6,257.6 227.2,256.9 222,254.2 C 211.3,258.3 204.2,262.7 200.7,267.4 C 196.1,273.5 197.4,280.2 204.6,287.5 z "
				},
				D2A: {
				title: "Corse-du-Sud 2A",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 377.5,400.7 C 383.7,432.4 393.1,447.4 405.5,445.7 C 406,437.8 407.1,430.5 409,423.7 C 400.4,410.3 389.9,402.7 377.5,400.7 z "
				},
				D2B: {
				title: "Haute-Corse 2B",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 403,370.7 L 402.5,382.7 C 391.8,384.8 383.5,390.8 377.5,400.7 C 389.9,402.7 400.4,410.3 409,423.7 C 410.2,419.2 411.7,414.8 413.5,410.7 C 413.8,394.4 412,385.9 408,385.2 C 408.1,373 406.5,368.2 403,370.7 z "
				},
				D21: {
				title: "Côte-d'Or 21",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 330.3,180.3 L 333.1,165.5 C 323.4,165.1 316.2,158.6 311.4,146.1 C 305.8,148.8 300.6,150.2 295.6,150.3 C 291.7,162.2 290.4,171.8 291.6,179 C 292.2,182 293.1,184.6 294.5,186.8 C 299.6,194.8 310.6,197.6 327.6,195 L 330.3,180.3 z "
				},
				D22: {
				title: "Côtes-d'Armor 22",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 45.7,105.9 C 50.5,110.3 52.4,119.6 51.6,134 C 70.4,133.7 83.5,136.8 90.6,143 C 101.2,134.7 105.1,126.3 102.5,118 C 83.7,119.4 72.1,115.1 67.7,105 C 64.7,103.2 57.4,103.5 45.7,105.9 z "
				},
				D23: {
				title: "Creuse 23",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 243.1,235 C 240.1,231.2 236.9,228.2 233.5,225.9 C 231.2,224.5 228.9,223.4 226.5,222.7 C 218.4,220.1 209,221.4 198.6,226.5 C 205.9,240.7 213.7,249.9 222,254.2 C 227.2,256.9 232.6,257.6 238.2,256.4 C 237.4,250.6 239,243.5 243.1,235 z "
				},
				D24: {
				title: "Dordogne 24",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 200.7,267.4 C 196.5,261.6 189.7,257.8 180.3,255.9 C 175.4,262.9 167.7,271.3 157.1,281 C 161.3,284.8 163.2,289.7 162.9,296 C 170.3,303.7 180.2,308.3 192.6,309.8 L 204.6,287.5 C 197.4,280.2 196.1,273.5 200.7,267.4 z "
				},
				D25: {
				title: "Doubs 25",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 380.1,182.1 C 377.5,177.2 375.9,171.7 375.2,165.9 C 360.4,169.2 348.8,175.1 340.4,183.5 C 347.1,187.9 353.2,196.8 358.5,210.3 C 358.8,204.4 366,195 380.1,182.1 z "
				},
				D26: {
				title: "Drôme 26",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 348.3,321.5 C 337.3,315.5 337.9,308.3 350.1,300 L 337.1,295 C 339.7,284.4 332.1,276.3 314.1,270.5 C 318.6,282.3 317.3,299.2 310.1,321 C 319.6,324.2 329.4,325 339.4,323.5 C 342.3,323 345.3,322.3 348.3,321.5 z "
				},
				D27: {
				title: "Eure 27",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 215.2,89.5 C 215.8,86.7 216.1,83.8 216.1,80.8 C 202.3,87.3 187.9,87.3 172.9,80.8 C 177,88.8 180.3,96.5 182.8,103.9 C 184.3,108.6 185.6,113.2 186.4,117.7 C 196,114.2 203.2,109.6 208.2,103.7 C 211.6,99.6 214,94.8 215.2,89.5 z "
				},
				D28: {
				title: "Eure-et-Loir 28",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 209.1,148.5 C 216.5,148.4 220,144.2 219.6,136.2 C 219.1,128.7 215.4,117.9 208.2,103.7 L 208.2,103.7 C 203.2,109.6 196,114.2 186.4,117.7 C 188,125.9 188.4,133.7 187.6,141 C 194.1,147.4 201.3,149.9 209.1,148.5 z "
				},
				D29: {
				title: "Finistère 29",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 51.6,134 C 52.4,119.6 50.5,110.3 45.7,105.9 C 37.6,107.6 27.4,110.3 15.1,114 C 13.3,118.7 13.3,121.9 15.1,123.5 C 23,121.3 28.5,122.3 31.6,126.5 L 20.1,127 C 34.9,133 33.6,135.9 16.1,135.6 C 21.4,138.2 24.4,142.9 25.1,149.5 C 33.1,149.3 41.2,150.8 49.2,153.8 C 50.4,146.4 51.2,139.8 51.6,134 z "
				},
				D30: {
				title: "Gard 30",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 310.1,321 C 299.4,322 292.2,319.6 288.4,314 C 285.9,319.9 286.4,324.6 290.1,328 C 281.5,329.7 274.5,329.3 269.2,327.1 C 269.9,330.7 269.3,334.4 267.4,338.2 C 289.9,338.7 298.3,346.3 292.6,360.9 C 294,360.9 295.6,360.9 297.2,360.9 C 306.7,353 312.3,345 314.1,337 C 318.2,332.9 316.8,327.6 310.1,321 z "
				},
				D31: {
				title: "Haute-Garonne 31",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 175.6,366.5 C 169.4,371.7 167.4,380.5 169.5,392.9 C 173.3,392.1 177,391 180.6,389.5 C 188.2,379.3 197.9,371.8 209.6,367.1 C 214.5,365.1 219.7,363.6 225.3,362.6 C 214.7,356.4 209,348.4 208.2,338.6 C 202.8,341.6 196.4,344.2 189,346.2 C 193.8,358 189.3,364.8 175.6,366.5 z "
				},
				D32: {
				title: "Gers 32",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 143.8,352.7 C 147,353.3 150.1,353.9 153.1,354.8 C 162,357.3 169.5,361.2 175.6,366.5 C 189.3,364.8 193.8,358 189,346.2 C 187.4,342.1 184.6,337.4 180.6,332 C 172.3,330.7 165.2,331.4 159.4,334.3 C 152.6,337.7 147.4,343.8 143.8,352.7 z "
				},
				D33: {
				title: "Gironde 33",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 157.1,281 C 147.8,284.8 135.3,278 119.4,260.6 C 118.4,278.9 116.5,295.3 113.5,309.8 C 132.3,312.5 145.4,317 152.7,323.2 C 159.2,312.4 162.6,303.3 162.9,296 C 163.2,289.7 161.3,284.8 157.1,281 z "
				},
				D34: {
				title: "Hérault 34",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 292.6,360.9 C 298.3,346.3 289.9,338.7 267.4,338.2 C 265.3,342.6 261.4,347 255.8,351.6 C 252,354.7 247.4,357.9 242.1,361 C 243.9,367.8 252.1,371.9 266.8,373.5 C 271.6,365.5 280.2,361.3 292.6,360.9 z "
				},
				D35: {
				title: "Ille-et-Vilaine 35",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 102.5,118 C 105.1,126.3 101.2,134.7 90.6,143 C 96.7,148.3 98,154.8 94.4,162.5 C 102,158.4 111.2,156.5 122.1,156.5 C 129.8,143 131.5,132.5 127.2,124.9 C 125.1,121.3 121.5,118.3 116.6,116 C 111.5,117 106.8,117.6 102.5,118 z "
				},
				D36: {
				title: "Indre 36",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 217.4,185 C 213.3,186.1 207.9,186.6 201.2,186.5 C 201,192.9 197.4,199.6 190.5,206.7 C 194.6,212.5 197.3,219.1 198.6,226.5 C 209,221.4 218.4,220.1 226.5,222.7 C 232.8,210.1 229.7,197.6 217.4,185 z "
				},
				D37: {
				title: "Indre-et-Loire 37",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 180.8,161.2 C 177.4,164 172.9,166 167.1,167 C 166.9,175.1 164.8,181.3 161,185.5 C 174.2,190.6 184.1,197.6 190.5,206.7 C 197.4,199.6 201,192.9 201.2,186.5 C 201.6,177.2 194.8,168.8 180.8,161.2 z "
				},
				D38: {
				title: "Isère 38",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 363.3,279.5 C 362,272.3 354.9,264.8 342.1,257 C 334.9,254.6 329,251.9 324.3,248.9 C 322.7,261.8 316.9,266.6 307,263 C 309,265.5 311.4,268 314.1,270.5 C 332.1,276.3 339.7,284.4 337.1,295 L 350.1,300 C 360.1,293.5 364.5,286.7 363.3,279.5 z "
				},
				D39: {
				title: "Jura 39",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 340.4,183.5 C 337.2,181.4 333.8,180.3 330.3,180.3 L 327.6,195 L 329.6,216.5 C 337.3,229.6 345.4,230.1 354,217.8 C 355.5,215.7 357,213.2 358.5,210.3 C 353.2,196.8 347.1,187.9 340.4,183.5 z "
				},
				D40: {
				title: "Landes 40",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 159.4,334.3 C 158.7,330.1 156.5,326.4 152.7,323.2 C 145.4,317 132.3,312.5 113.5,309.8 C 110,327.2 105.1,341.8 98.8,353.7 C 116.1,351 131.1,350.7 143.8,352.7 C 147.4,343.8 152.6,337.7 159.4,334.3 z "
				},
				D41: {
				title: "Loir-et-Cher 41",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 180.8,161.2 C 194.8,168.8 201.6,177.2 201.2,186.5 C 207.9,186.6 213.3,186.1 217.4,185 C 226.9,182.5 231,176.8 229.6,167.8 C 218.5,165 211.6,158.6 209.1,148.5 C 201.3,149.9 194.1,147.4 187.6,141 C 188.3,150 186,156.7 180.8,161.2 z "
				},
				D42: {
				title: "Loire 42",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 300.6,232.7 C 295.8,233.6 290.3,233.1 284.3,231.3 C 283,235.2 280.9,239.6 278.1,244.5 C 283.7,250.7 286.5,259.6 286.6,271.5 C 292.3,272.1 299.8,274.4 309.1,278.3 C 310.8,275.9 312.5,273.3 314.1,270.5 C 311.4,268 309,265.5 307,263 C 298.6,252.5 296.4,242.4 300.6,232.7 z "
				},
				D43: {
				title: "Haute-Loire 43",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 258.6,273 C 262.1,279.3 265.7,284.5 269.3,288.6 C 274.7,294.8 280.1,298.5 285.6,299.5 C 294.3,295.4 302.1,288.4 309.1,278.3 C 299.8,274.4 292.3,272.1 286.6,271.5 C 276.3,270.2 266.9,270.8 258.6,273 z "
				},
				D44: {
				title: "Loire-Atlantique 44",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 91.6,186 C 106.9,195.9 116.9,197.2 121.4,189.8 C 125,184 125.2,172.9 122.1,156.5 C 111.2,156.5 102,158.4 94.4,162.5 C 88.9,165.4 84.2,169.3 80.4,174.4 C 84.2,177.9 87.9,181.8 91.6,186 z "
				},
				D45: {
				title: "Loiret 45",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 219.6,136.2 C 220,144.2 216.5,148.4 209.1,148.5 C 211.6,158.6 218.5,165 229.6,167.8 C 236.4,169.5 244.7,169.9 254.6,169 C 259.2,155.3 258.6,145.5 252.8,139.6 C 242.6,144 236.8,142.5 235.5,135.1 C 231.6,137.5 226.3,137.8 219.6,136.2 z "
				},
				D46: {
				title: "Lot 46",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 225.2,286.6 C 218.7,291.1 211.8,291.4 204.6,287.5 L 192.6,309.8 C 192.3,321.5 203.2,325.1 225.4,320.7 C 227.2,316.6 228.2,312.2 228.4,307.5 C 228.4,306.8 228.4,306.1 228.5,305.5 C 228.5,299.7 227.4,293.4 225.2,286.6 z "
				},
				D47: {
				title: "Lot-et-Garonne 47",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 152.7,323.2 C 156.5,326.4 158.7,330.1 159.4,334.3 C 165.2,331.4 172.3,330.7 180.6,332 L 192.6,309.8 C 180.2,308.3 170.3,303.7 162.9,296 C 162.6,303.3 159.2,312.4 152.7,323.2 z "
				},
				D48: {
				title: "Lozère 48",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 290.1,328 C 286.4,324.6 285.9,319.9 288.4,314 C 286.1,310.5 285.1,305.6 285.6,299.5 C 280.1,298.5 274.7,294.8 269.3,288.6 C 260.9,291.3 256.5,296.6 256.1,304.5 C 256.9,316.2 261.3,323.7 269.2,327.1 C 274.5,329.3 281.5,329.7 290.1,328 z "
				},
				D49: {
				title: "Maine-et-Loire 49",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 149.2,158.4 C 141.2,156.2 132.1,155.6 122.1,156.5 C 125.2,172.9 125,184 121.4,189.8 C 125.4,190.8 129.1,191.6 132.6,192 C 141.7,193.3 149,192.7 154.6,190.1 C 157.1,189 159.2,187.4 161,185.5 C 164.8,181.3 166.9,175.1 167.1,167 C 161.8,163.1 155.9,160.2 149.2,158.4 z "
				},
				D50: {
				title: "Manche 50",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 131.8,82.9 C 127.3,79.9 125.2,74.9 125.6,67.9 L 104.1,66 C 114.7,82.1 118.9,98.7 116.6,116 C 121.5,118.3 125.1,121.3 127.2,124.9 C 127.4,124.9 127.6,124.9 127.8,124.9 C 133.6,124.1 136.8,119.9 137.2,112.1 C 137.6,105.2 135.8,95.4 131.8,82.9 z "
				},
				D51: {
				title: "Marne 51",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 314.9,90.8 C 301.8,91.2 291.9,88.4 285.1,82.3 C 281.6,91.2 276.1,100.6 268.9,110.4 C 270.3,113.3 271,116.2 271.1,119 C 283.8,122.9 295.4,123.2 305.9,119.9 C 309.2,118.8 312.4,117.3 315.6,115.5 C 313.9,105.8 313.7,97.6 314.9,90.8 z "
				},
				D52: {
				title: "Haute-Marne 52",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 333.1,165.5 C 339.3,162.1 342.3,156.9 342,150.2 C 341.6,143.6 338.3,135.6 331.8,126 C 325.2,123.9 319.8,120.4 315.6,115.5 C 312.4,117.3 309.2,118.8 305.9,119.9 C 306.9,130.4 308.8,139.2 311.4,146.1 C 316.2,158.6 323.4,165.1 333.1,165.5 z "
				},
				D53: {
				title: "Mayenne 53",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 161.3,126.6 C 151.6,124.1 140.4,123.5 127.8,124.9 C 127.6,124.9 127.4,124.9 127.2,124.9 C 131.5,132.5 129.8,143 122.1,156.5 C 132.1,155.6 141.2,156.2 149.2,158.4 L 161.3,126.6 z "
				},
				D54: {
				title: "Meurthe-et-Moselle 54",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 343.7,80.4 C 336.8,77.8 330.9,75.1 326.1,72.3 C 336.3,79.5 342.1,98.2 343.8,128.4 C 354.4,129.4 367.2,127.9 382.1,124 C 358.1,110.7 345.3,96.2 343.7,80.4 z "
				},
				D55: {
				title: "Meuse 55",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 331.8,126 C 335.5,127.2 339.4,128 343.8,128.4 C 342.1,98.2 336.3,79.5 326.1,72.3 C 320.1,76 316.3,82.2 314.9,90.8 C 313.7,97.6 313.9,105.8 315.6,115.5 C 319.8,120.4 325.2,123.9 331.8,126 z "
				},
				D56: {
				title: "Morbihan 56",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 49.2,153.8 C 59.7,157.8 70,164.7 80.4,174.4 C 84.2,169.3 88.9,165.4 94.4,162.5 C 98,154.8 96.7,148.3 90.6,143 C 83.5,136.8 70.4,133.7 51.6,134 C 51.2,139.8 50.4,146.4 49.2,153.8 z "
				},
				D57: {
				title: "Moselle 57",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 397.2,95 C 375.2,90.5 357.4,85.7 343.7,80.4 C 345.3,96.2 358.1,110.7 382.1,124 C 387.7,116.1 387.7,108.7 382.1,102 C 390.9,102.2 395.9,99.8 397.2,95 z "
				},
				D58: {
				title: "Nièvre 58",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 294.5,186.8 C 293.1,184.6 292.2,182 291.6,179 C 278.6,173.1 266.3,169.7 254.6,169 C 257.6,182.8 257.6,194.4 254.3,203.8 C 263.9,209.3 271.8,211.5 278.1,210.3 C 286.6,208.5 292,200.8 294.5,186.8 z "
				},
				D59: {
				title: "Nord 59",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 256.4,54.8 C 263.9,51.1 275.4,50.7 290.9,53.6 C 289.3,51.6 288.9,48.1 289.6,43 C 265.8,32.3 249.2,19.8 239.6,5.5 C 234.3,6.1 229.8,6.8 226,7.8 C 241.9,20.4 252,36 256.4,54.8 z "
				},
				D60: {
				title: "Oise 60",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 257.6,96.5 C 258.9,87 259.3,77.9 258.7,69.5 C 244.3,74.2 229.9,73.6 215.5,67.7 C 217,72.2 217.2,76.6 216.1,80.8 C 216.1,83.8 215.8,86.7 215.2,89.5 C 226.6,90.5 235.4,93.1 241.7,97.5 C 247,97.9 252.3,97.6 257.6,96.5 z "
				},
				D61: {
				title: "Orne 61",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 187.6,141 C 188.4,133.7 188,125.9 186.4,117.7 C 185.6,113.2 184.3,108.6 182.8,103.9 C 166.2,101.3 151.1,104.1 137.2,112.1 C 136.8,119.9 133.6,124.1 127.8,124.9 C 140.4,123.5 151.6,124.1 161.3,126.6 C 171.8,129.2 180.5,134 187.6,141 z "
				},
				D62: {
				title: "Pas-de-Calais 62",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 211.9,15.9 C 214.4,25 214.8,32.9 212.9,39.5 L 256.4,54.8 C 252,36 241.9,20.4 226,7.8 C 218,9.7 213.3,12.4 211.9,15.9 z "
				},
				D63: {
				title: "Puy-de-Dôme 63",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 286.6,271.5 C 286.5,259.6 283.7,250.7 278.1,244.5 C 270.9,236.6 259.3,233.5 243.1,235 C 239,243.5 237.4,250.6 238.2,256.4 C 238.6,259.6 239.8,262.4 241.7,264.8 C 245.1,268.8 250.7,271.6 258.6,273 C 266.9,270.8 276.3,270.2 286.6,271.5 z "
				},
				D64: {
				title: "Pyrénées-Atlantiques 64",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 98.8,353.7 C 97.3,356.4 95.7,359.2 94.1,362 C 110.9,377.2 126.9,387 141.9,391.3 C 152.8,373.3 156.5,361.1 153.1,354.8 C 150.1,353.9 147,353.3 143.8,352.7 C 131.1,350.7 116.1,351 98.8,353.7 z "
				},
				D65: {
				title: "Hautes-Pyrénées 65",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 153.1,354.8 C 156.5,361.1 152.8,373.3 141.9,391.3 C 151.5,394 160.7,394.5 169.5,392.9 C 167.4,380.5 169.4,371.7 175.6,366.5 C 169.5,361.2 162,357.3 153.1,354.8 z "
				},
				D66: {
				title: "Pyrénées-Orientales 66",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 262.4,388.1 C 247.5,385.5 234.6,388.1 223.6,395.9 C 219.8,398.6 216.3,401.8 213,405.7 C 233.2,413.3 250,414.3 263.6,408.5 C 262.2,400.8 261.8,394 262.4,388.1 z "
				},
				D67: {
				title: "Bas-Rhin 67",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 382.1,102 C 387.7,108.7 387.7,116.1 382.1,124 C 383.7,130 389,134.7 397.9,138.2 C 400.3,124 405.4,110.6 413.5,98.1 C 407.8,97.1 402.4,96 397.2,95 C 395.9,99.8 390.9,102.2 382.1,102 z "
				},
				D68: {
				title: "Haut-Rhin 68",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 397.9,138.2 C 389,134.7 383.7,130 382.1,124 C 378,134.6 375.7,144.3 375,153.1 L 390.1,173.3 C 392.2,171.5 394.5,169.6 396.9,167.7 C 396,157.5 396.3,147.7 397.9,138.2 z "
				},
				D69: {
				title: "Rhône 69",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 311.4,227.3 C 308.3,230.1 304.6,231.9 300.6,232.7 C 296.4,242.4 298.6,252.5 307,263 C 316.9,266.6 322.7,261.8 324.3,248.9 C 315.2,242.9 310.9,235.7 311.4,227.3 z "
				},
				D70: {
				title: "Haute-Saône 70",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 330.3,180.3 C 333.8,180.3 337.2,181.4 340.4,183.5 C 348.8,175.1 360.4,169.2 375.2,165.9 C 374.7,161.8 374.6,157.6 375,153.1 C 361.4,146.9 350.4,145.9 342,150.2 C 342.3,156.9 339.3,162.1 333.1,165.5 L 330.3,180.3 z "
				},
				D71: {
				title: "Saône-et-Loire 71",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 329.6,216.5 L 327.6,195 C 310.6,197.6 299.6,194.8 294.5,186.8 C 292,200.8 286.6,208.5 278.1,210.3 C 285.4,214.2 287.4,221.2 284.3,231.3 C 290.3,233.1 295.8,233.6 300.6,232.7 C 304.6,231.9 308.3,230.1 311.4,227.3 C 314.4,224.6 316.9,221 319.1,216.5 L 329.6,216.5 z "
				},
				D72: {
				title: "Sarthe 72",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 167.1,167 C 172.9,166 177.4,164 180.8,161.2 C 186,156.7 188.3,150 187.6,141 C 180.5,134 171.8,129.2 161.3,126.6 L 149.2,158.4 C 155.9,160.2 161.8,163.1 167.1,167 z "
				},
				D73: {
				title: "Savoie 73",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 342.1,257 C 354.9,264.8 362,272.3 363.3,279.5 L 377.1,280.5 C 387.9,279 392,269.7 389.3,252.7 L 369.1,245.3 C 364.4,255.9 357.9,255.9 349.5,245.3 C 347.4,248.9 345,252.8 342.1,257 z "
				},
				D74: {
				title: "Haute-Savoie 74",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 354,217.8 C 358.8,222.3 357.3,231.4 349.5,245.3 C 357.9,255.9 364.4,255.9 369.1,245.3 L 389.3,252.7 C 387.8,243.4 384.2,231.6 378.6,217.5 C 364.9,218.7 358.2,216.3 358.5,210.3 C 357,213.2 355.5,215.7 354,217.8 z "
				},
				D75: {
				title: "Paris 75",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 368.6,43.5 C 372.9,41.9 376.9,40.6 380.4,39.7 C 386.2,29.1 380.2,22.4 362.3,19.6 C 351,30.5 353.1,38.5 368.6,43.5 z "
				},
				D76: {
				title: "Seine-Maritime 76",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 181,63.6 C 164.7,73.1 161.9,78.8 172.9,80.8 C 187.9,87.3 202.3,87.3 216.1,80.8 C 217.2,76.6 217,72.2 215.5,67.7 C 213.8,62.7 210.4,57.5 205.5,52.1 C 199.9,57.5 191.8,61.3 181,63.6 z "
				},
				D77: {
				title: "Seine-et-Marne 77",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 241.7,97.5 C 243,105.3 243.5,111.9 243.2,117.4 C 242.7,126.3 240.1,132.1 235.5,135.1 C 236.8,142.5 242.6,144 252.8,139.6 C 256.9,137.7 261.9,134.9 267.6,131 C 270.1,127.1 271.3,123.1 271.1,119 C 271,116.2 270.3,113.3 268.9,110.4 C 266.7,105.9 262.9,101.3 257.6,96.5 C 252.3,97.6 247,97.9 241.7,97.5 z "
				},
				D78: {
				title: "Yvelines 78",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 208.2,103.7 C 215.4,117.9 219.1,128.7 219.6,136.2 L 227.9,109.4 C 227.4,108.1 227.9,106.6 229.2,105.1 C 221.6,98 214.6,97.6 208.2,103.7 z "
				},
				D79: {
				title: "Deux-Sèvres 79",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 154.6,190.1 C 149,192.7 141.7,193.3 132.6,192 C 142.9,209.8 143.6,221 134.6,225.8 C 140.2,233.9 147.5,238.5 156.3,239.9 C 158.8,240.2 161.4,240.3 164.1,240.2 C 165.9,217.9 162.7,201.2 154.6,190.1 z "
				},
				D80: {
				title: "Somme 80",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 258.7,69.5 C 258.3,64.4 257.5,59.5 256.4,54.8 L 212.9,39.5 C 211.6,44.4 209.1,48.6 205.5,52.1 C 210.4,57.5 213.8,62.7 215.5,67.7 C 229.9,73.6 244.3,74.2 258.7,69.5 z "
				},
				D81: {
				title: "Tarn 81",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 225.4,320.7 C 222.1,327.8 216.4,333.8 208.2,338.6 C 209,348.4 214.7,356.4 225.3,362.6 C 230.5,361.7 236.1,361.1 242.1,361 C 247.4,357.9 252,354.7 255.8,351.6 C 244.4,347.1 234.2,336.8 225.4,320.7 z "
				},
				D82: {
				title: "Tarn-et-Garonne 82",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 208.2,338.6 C 216.4,333.8 222.1,327.8 225.4,320.7 C 203.2,325.1 192.3,321.5 192.6,309.8 L 180.6,332 C 184.6,337.4 187.4,342.1 189,346.2 C 196.4,344.2 202.8,341.6 208.2,338.6 z "
				},
				D83: {
				title: "Var 83",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 348.9,346.7 C 345.9,357.2 346.3,366.5 349.9,374.5 C 367.1,375.9 381.6,370.7 393.4,358.9 L 379.6,341 C 368.6,344.7 358.3,346.5 348.9,346.7 z "
				},
				D84: {
				title: "Vaucluse 84",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 348.9,346.7 C 341.7,340.2 338.6,332.5 339.4,323.5 C 329.4,325 319.6,324.2 310.1,321 C 316.8,327.6 318.2,332.9 314.1,337 C 324.2,343.6 335.8,346.9 348.9,346.7 z "
				},
				D85: {
				title: "Vendée 85",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 121.4,189.8 C 116.9,197.2 106.9,195.9 91.6,186 C 97.2,201.1 106.7,215.3 120.1,228.5 C 126.3,228.6 131.1,227.7 134.6,225.8 C 143.6,221 142.9,209.8 132.6,192 C 129.1,191.6 125.4,190.8 121.4,189.8 z "
				},
				D86: {
				title: "Vienne 86",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 161,185.5 C 159.2,187.4 157.1,189 154.6,190.1 C 162.7,201.2 165.9,217.9 164.1,240.2 C 170.3,239.8 177.1,238.1 184.6,235 C 189.5,231.5 194.1,228.6 198.6,226.5 C 197.3,219.1 194.6,212.5 190.5,206.7 C 184.1,197.6 174.2,190.6 161,185.5 z "
				},
				D87: {
				title: "Haute-Vienne 87",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 198.6,226.5 C 194.1,228.6 189.5,231.5 184.6,235 C 188.3,239.5 186.8,246.5 180.3,255.9 C 189.7,257.8 196.5,261.6 200.7,267.4 C 204.2,262.7 211.3,258.3 222,254.2 C 213.7,249.9 205.9,240.7 198.6,226.5 z "
				},
				D88: {
				title: "Vosges 88",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 343.8,128.4 C 339.4,128 335.5,127.2 331.8,126 C 338.3,135.6 341.6,143.6 342,150.2 C 350.4,145.9 361.4,146.9 375,153.1 C 375.7,144.3 378,134.6 382.1,124 C 367.2,127.9 354.4,129.4 343.8,128.4 z "
				},
				D89: {
				title: "Yonne 89",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 267.6,131 C 261.9,134.9 256.9,137.7 252.8,139.6 C 258.6,145.5 259.2,155.3 254.6,169 C 266.3,169.7 278.6,173.1 291.6,179 C 290.4,171.8 291.7,162.2 295.6,150.3 C 284.7,150.4 275.4,144 267.6,131 z "
				},
				D90: {
				title: "Territoire de Belfort 90",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 375.2,165.9 C 375.9,171.7 377.5,177.2 380.1,182.1 C 383.1,179.4 386.4,176.4 390.1,173.3 L 375,153.1 C 374.6,157.6 374.7,161.8 375.2,165.9 z "
				},
				D91: {
				title: "Essonne 91",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 235.5,135.1 C 240.1,132.1 242.7,126.3 243.2,117.4 C 233.9,115.1 228.8,112.4 227.9,109.4 L 219.6,136.2 C 226.3,137.8 231.6,137.5 235.5,135.1 z "
				},
				D92: {
				title: "Hauts-de-Seine 92",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 370.5,12.7 C 369.7,12.5 368.9,12.3 368.1,12.1 L 367.7,12.2 C 332,27 331.3,43.1 365.6,60.5 L 368.6,43.5 C 353.1,38.5 351,30.5 362.3,19.6 C 364.5,17.4 367.3,15.1 370.5,12.7 z "
				},
				D93: {
				title: "Seine-Saint-Denis 93",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 401.1,6.5 C 391.3,12.7 381.1,14.7 370.5,12.7 C 367.3,15.1 364.5,17.4 362.3,19.6 C 380.2,22.4 386.2,29.1 380.4,39.7 C 392.4,36.7 399.7,37.7 402.4,42.7 C 406.6,32 406.1,19.9 401.1,6.5 z "
				},
				D94: {
				title: "Val-de-Marne 94",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 380.4,39.7 C 376.9,40.6 372.9,41.9 368.6,43.5 L 365.6,60.5 C 376.8,57.8 387.9,59.9 398.8,66.9 C 405.9,59.4 407.1,51.4 402.4,42.7 C 399.7,37.7 392.4,36.7 380.4,39.7 z "
				},
				D95: {
				title: "Val-d'Oise 95",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 241.7,97.5 C 235.4,93.1 226.6,90.5 215.2,89.5 C 214,94.8 211.6,99.6 208.2,103.7 L 208.2,103.7 C 214.6,97.6 221.6,98 229.2,105.1 C 231.3,102.7 235.4,100.2 241.7,97.5 z "
				},
				D971: {
				title: "Guadeloupe 971",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 238,440.2 C 234.2,431.7 231.5,432.5 230,442.3 C 234.7,445 232.8,448.7 224,453.6 C 222.9,452.2 221.9,451.1 221,450.1 C 213.6,442.3 209.5,444.1 208.7,455.2 C 211.5,459.5 212.2,463.9 211,468.4 L 216.6,477.7 C 217.5,478 218.9,477.6 221,476.4 C 222.6,475.5 224.5,474.1 226.8,472.3 C 227.8,467.1 227.4,461.5 225.5,455.6 L 227.6,454.1 C 229.2,459.1 238.2,459.2 254.5,454.3 C 252.1,451.7 249.1,449.8 245.7,448.7 C 241.4,448.7 238.8,445.9 238,440.2 z M 243.2,479.2 C 243.4,482.5 245.5,484.6 249.4,485.5 C 252.1,483.9 253.8,481.8 254.5,479 C 253.2,476.3 251.1,474.5 248.2,473.7 L 243.2,479.2 z M 269.7,448.5 L 266.9,446.1 L 260.3,450.2 C 262.1,451.3 265.3,450.7 269.7,448.5z"
				},
				D972: {
				title: "Martinique 972",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 110.2,443.3 C 105,441.2 100.8,440 97.9,439.9 C 92.5,439.7 90.9,442.9 93.2,449.5 C 96.3,451.4 97.6,454.7 97.1,459.4 C 97.3,459.7 97.6,460 97.9,460.3 C 102.3,464.7 108.1,467.7 115.2,469.4 C 112.1,471.1 108.5,471.8 104.5,471.6 C 104.3,475 105.2,477.9 107.3,480.2 C 116.1,477.3 122.7,479.6 127,487.1 C 133.6,482 132.7,473 124.5,460.4 C 116.6,458.5 117,455.2 125.4,450.4 L 125.3,448.2 L 116.5,451.5 L 110.2,443.3 z "
				},
				D973: {
				title: "Guyane 973",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 301.1,438.3 C 299.2,436.1 296.6,435 293.2,435.1 C 283.4,445.5 283.3,455.6 292.8,465.4 C 290.6,476.7 287.4,482.3 283.1,482.5 L 289.7,484.9 C 292.8,482.6 299,482.2 308.3,483.9 L 313.7,481.6 C 315.6,473.5 320.1,465.6 327.2,457.9 C 327.2,457.8 327.2,457.7 327.3,457.6 C 328.6,452.8 326.9,450.4 322.1,450.4 C 314,441.1 306.9,437.1 301.1,438.3 z "
				},
				D974: {
				title: "Réunion 974",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 70.3,478.5 C 72.7,473.9 73.8,469.4 73.8,465.1 C 68.2,459.7 65,453.7 64.4,447.3 C 53.4,440.8 42.2,440.5 31,446.4 C 30.8,450.4 29.5,453.1 27.2,454.2 C 30.3,460.5 31.3,465.4 29.9,468.7 L 43.6,478.5 C 52.9,483.4 61.7,483.4 70.3,478.5 z "
				},
				D976: {
				title: "Mayotte 976",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 165.4,471.4 C 162,481 166.5,484.8 178.8,482.8 C 176.9,477.7 178.3,472.9 182.9,468.3 C 178.8,465.5 179.9,460.3 186.2,452.7 C 174.5,451.6 167.6,447.6 165.4,440.9 C 161.8,443.6 159.9,447.5 159.9,452.6 C 162,454.8 164.3,455.6 166.6,454.7 C 174.9,474.7 174.5,480.3 165.4,471.4 z "
				},
				D111: {
				title: "Ile-de-France",
				coul: "#6699CC",
				target: "_self",
				url: "#",
				path: "M 227.9,109.4 C 228.8,112.4 233.9,115.1 243.2,117.4 C 243.5,111.9 243,105.3 241.7,97.5 C 235.4,100.2 231.3,102.7 229.2,105.1 C 227.9,106.6 227.4,108.1 227.9,109.4 z "
				}
	
	
	
}
/* ne rien modifier ci-dessous */