<?php
  $tabs = array(
    'vckit'              => __( 'General', 'legocreative' ),
    'vckit-module'       => __( 'Modules', 'legocreative' ),
    'vckit-smoothscroll' => __( 'Smooth Scroll', 'legocreative' ),
    'vckit-about'        => __( 'About', 'legocreative' ),
  );

  if ( ! isset( $active_tab ) ) {
    $active_tab = '';
  }
?>
<div class="vckit-setting-wrapper">
  <nav class="vckit-setting-nav">
    <ul>
    <?php foreach ( $tabs as $slug => $title ) :  ?>
      <?php $url = 'admin.php?page=' . rawurlencode( $slug ); ?>
      <li class="<?php echo $active_tab === $slug ? esc_attr( ' vckit-nav-tab-active' ) : '' ?>">
        <a href="<?php echo esc_attr( is_network_admin() ? network_admin_url( $url ) : admin_url( $url ) ) ?>">
          <?php echo esc_html( $title ) ?>
        </a>
      </li>
      <?php endforeach ?>
    </ul>
  </nav>
