<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Button class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Button extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_button';
  protected $name = 'Button';
  protected $desc = 'Fresh styles for the modern button.';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/buttons.png' ),
      'js_view' => 'VcButton3View',
      'custom_markup' => '{{title}}<div class="vc_btn3-container vckit-button-container"><button class="vckit-vc-button">{{{ params.title }}}</button></div>',
      'params' => array_merge( array(
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Style', 'legocreative' ),
          'param_name' => 'style',
          'value'      => array(
            __( 'Winona', 'legocreative' ) => 'winona',
            __( 'Ujarak', 'legocreative' ) => 'ujarak',
            __( 'Wayra', 'legocreative' ) => 'wayra',
            __( 'Tamaya', 'legocreative' ) => 'tamaya',
            __( 'Rayen', 'legocreative' ) => 'rayen',
            __( 'Pipaluk', 'legocreative' ) => 'pipaluk',
            __( 'Moema', 'legocreative' ) => 'moema',
            __( 'Isi', 'legocreative' ) => 'isi',
            __( 'Aylen', 'legocreative' ) => 'aylen',
            __( 'Saqui', 'legocreative' ) => 'saqui',
            __( 'Wapasha', 'legocreative' ) => 'wapasha',
            __( 'Nina', 'legocreative' ) => 'nina',
            __( 'Nanuk', 'legocreative' ) => 'nanuk',
            __( 'Nuka', 'legocreative' ) => 'nuka',
            __( 'Antiman', 'legocreative' ) => 'antiman',
            __( 'Itzel', 'legocreative' ) => 'itzel',
            __( 'Naira', 'legocreative' ) => 'naira',
            __( 'Quidel', 'legocreative' ) => 'quidel',
            __( 'Sacnite', 'legocreative' ) => 'sacnite',
            __( 'Shikoba', 'legocreative' ) => 'shikoba',
          ),
          'std'         => 'winona',
          'description' => __( 'Select hover effect for Icon.', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Text', 'legocreative' ),
          'param_name' => 'title',
          'value' => __( 'Read more', 'legocreative' ),
        ),
        array(
          'type' => 'vc_link',
          'heading' => __( 'URL (Link)', 'legocreative' ),
          'param_name' => 'link',
          'description' => __( 'Add link to button.', 'legocreative' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Size', 'legocreative' ),
          'param_name' => 'size',
          'description' => __( 'Select button display size.', 'legocreative' ),
          'std' => 'm',
          'value' => $this->getValues( 'sizes' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Border Size', 'legocreative' ),
          'param_name' => 'border_size',
          'description' => __( 'Select button border size.', 'legocreative' ),
          'std' => 'thin',
          'value' => $this->getValues( 'border' ),
          'edit_field_class' => 'vc_col-sm-6',
          'dependency' => array(
            'element' => 'style',
            'value_not_equal_to' => array( 'quidel' ),
          ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Border Radius Size', 'legocreative' ),
          'param_name' => 'radius_size',
          'description' => __( 'Select button border radius size.', 'legocreative' ),
          'std' => 's',
          'value' => $this->getValues( 'round' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Font Weight', 'legocreative' ),
          'param_name' => 'text_size',
          'description' => __( 'Select button text size.', 'legocreative' ),
          'std' => 'thin',
          'value' => $this->getValues( 'text' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Alignment', 'legocreative' ),
          'param_name' => 'align',
          'description' => __( 'Select button alignment.', 'legocreative' ),
          'value' => array(
            __( 'Inline', 'legocreative' ) => 'inline',
            __( 'Left', 'legocreative' ) => 'left',
            __( 'Right', 'legocreative' ) => 'right',
            __( 'Center', 'legocreative' ) => 'center',
          ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Set full width button?', 'legocreative' ),
          'param_name' => 'button_block',
          'dependency' => array(
            'element' => 'align',
            'value_not_equal_to' => 'inline',
          ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Add icon?', 'legocreative' ),
          'param_name' => 'add_icon',
          'dependency' => array(
            'element' => 'style',
            'value_not_equal_to' => array( 'winona', 'nanuk', 'nina', 'rayen', 'tamaya' ),
          ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Icon Alignment', 'legocreative' ),
          'description' => __( 'Select icon alignment.', 'legocreative' ),
          'param_name' => 'icon_align',
          'value' => array(
            __( 'Left', 'legocreative' ) => 'left',
            // default as well
            __( 'Right', 'legocreative' ) => 'right',
          ),
          'dependency' => array(
            'element' => 'add_icon',
            'value' => 'true',
          ),
        ),
      ),
      $this->addIconLibrary( array(
        'element' => 'add_icon',
        'value'   => 'true',
      ) ),
      array(
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Text color', 'legocreative' ),
          'param_name' => 'text_color',
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Background color', 'legocreative' ),
          'param_name' => 'background_color',
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Border color', 'legocreative' ),
          'param_name' => 'border_color',
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Hover Text color', 'legocreative' ),
          'param_name' => 'hover_text_color',
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Hover Background color', 'legocreative' ),
          'param_name' => 'hover_background_color',
          'edit_field_class' => 'vc_col-sm-4',
          'dependency' => array(
            'element' => 'style',
            'value_not_equal_to' => array( 'quidel' ),
          ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Hover Border color', 'legocreative' ),
          'param_name' => 'hover_border_color',
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Extra class name', 'legocreative' ),
          'param_name' => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Advanced on click action', 'legocreative' ),
          'param_name' => 'custom_onclick',
          'description' => __( 'Insert inline onclick javascript action.', 'legocreative' ),
          'value'      => array(
            __( 'Default', 'legocreative' ) => '',
            __( 'Open lightbox', 'legocreative' ) => 'lightbox',
            __( 'Open Video or Maps', 'legocreative' ) => 'video',
            __( 'Execute code', 'legocreative' ) => 'code',
          ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Lightbox ID', 'legocreative' ),
          'param_name' => 'lightbox_id',
          'description' => __( 'Enter lightbox ID.', 'legocreative' ),
          'dependency' => array(
            'element' => 'custom_onclick',
            'value' => 'lightbox',
          ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Video URL or Link', 'legocreative' ),
          'param_name' => 'video_url',
          'description' => __( 'Enter Video URL or link to google maps', 'legocreative' ),
          'dependency' => array(
            'element' => 'custom_onclick',
            'value' => 'video',
          ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'On click code', 'legocreative' ),
          'param_name' => 'custom_onclick_code',
          'description' => __( 'Enter onclick action code.', 'legocreative' ),
          'dependency' => array(
            'element' => 'custom_onclick',
            'value' => 'code',
          ),
        ),
        array(
          'type' => 'css_editor',
          'heading' => __( 'CSS box', 'legocreative' ),
          'param_name' => 'css',
          'group' => __( 'Design Options', 'legocreative' ),
        ),
        array(
          'type'       => 'vckit_class',
          'heading'    => '',
          'param_name' => 'custom_class',
          'value'      => '',
        ),
      )
      ),
    );
  }

  public function getValues( $type ) {
    $values = array();
    switch ( $type ) {
      case 'sizes':
        $values = array(
          __( 'Small', 'legocreative' ) => 's',
          __( 'Medium', 'legocreative' ) => 'm',
          __( 'Large', 'legocreative' ) => 'l',
        );
        break;
      case 'round':
        $values = array(
          __( 'None', 'legocreative' ) => 'none',
          __( 'Small', 'legocreative' ) => 's',
          __( 'Medium', 'legocreative' ) => 'm',
          __( 'Large', 'legocreative' ) => 'l',
        );
        break;
      case 'border':
        $values = array(
          __( 'None', 'legocreative' ) => 'none',
          __( 'Thin', 'legocreative' ) => 'thin',
          __( 'Medium', 'legocreative' ) => 'medium',
          __( 'Thick', 'legocreative' ) => 'thick',
        );
        break;
      case 'text':
        $values = array(
          __( 'Thin', 'legocreative' ) => 'thin',
          __( 'Medium', 'legocreative' ) => 'medium',
          __( 'Thick', 'legocreative' ) => 'thick',
        );
        break;
    }

    return $values;
  }

  public function getCustomCSS( $atts ) {
    $custom_class =
    $style =
    $hover_text_color =
    $hover_background_color =
    $hover_border_color =
    $text_color =
    $border_color =
    $background_color =
    $custom_class = '';

    extract( $atts );

    $css = '';
    if ( $custom_class ) {
      $custom_class = '.vckit-btn.' . $custom_class;

      if ( ! $style ) {
        $style = 'winona'; // Fix default error
      }

      if ( $text_color ) {
        $css .= $custom_class . ' { color: ' . $text_color . '}';
        if ( preg_match( '/tamaya|nina/', $style ) ) {
          $css .= $custom_class . ':before { color: ' . $text_color . '}';
          $css .= $custom_class . ':after { color: ' . $text_color . '}';
        }
      }

      if ( $border_color ) {
        $css .= $custom_class . ' { border-color: ' . $border_color . '}';
        // After
        if ( preg_match( '/quidel/', $style ) ) {
          $css .= $custom_class . ' { background-color: ' . $border_color . '}';
        }
      }

      // HOVER TEXT
      if ( $hover_text_color ) {
        $css .= $custom_class . ':hover { color: ' . $hover_text_color . '}';

        // Before
        if ( preg_match( '/rayen/', $style ) ) {
          $css .= $custom_class . ':before { color: ' . $hover_text_color . '}';
        }
        // After
        if ( preg_match( '/winona|saqui/', $style ) ) {
          $css .= $custom_class . ':after { color: ' . $hover_text_color . '}';
        }
        // Special for tamaya
        if ( preg_match( '/tamaya/', $style ) ) {
          $css .= $custom_class . ' { color: ' . $hover_text_color . '}';
        }
      }

      // BACKGROUND
      if ( $background_color ) {
        // Before
        if ( preg_match( '/tamaya/', $style ) ) {
          $css .= $custom_class . ':before { background-color: ' . $background_color . '}';
        } else if ( preg_match( '/quidel/', $style ) ) { // @codingStandardsIgnoreLine
          // QUIDEL
        } else {
          $css .= $custom_class . ' { background-color: ' . $background_color . '}';
        }

        // After
        if ( preg_match( '/tamaya|pipaluk|nuka|antiman|quidel/', $style ) ) {
          $css .= $custom_class . ':after { background-color: ' . $background_color . '}';
        }
        // Another rule
        if ( preg_match( '/sacnite/', $style ) ) {
          $css .= $custom_class . ':before { box-shadow: inset 0 0 0 35px ' . $background_color . '}';
        }
      }

      // HOVER BACKGROUND
      if ( $hover_background_color ) {
        // All except
        if ( ! preg_match( '/ujarak|wayra|pipaluk|aylen|isi|wapasha|quidel/', $style ) ) {
          $css .= $custom_class . ':hover { background-color: ' . $hover_background_color . '}';
        }

        // Before
        if ( preg_match( '/ujarak|wayra|rayen|isi|wapasha|antiman|naira/', $style ) ) {
          $css .= $custom_class . ':before, ' .
            $custom_class . ':hover:before { background-color: ' . $hover_background_color . '}';
        }

        // After
        if ( preg_match( '/wayra|pipaluk|nuka/', $style ) ) {
          $css .= $custom_class . ':hover:after { background-color: ' . $hover_background_color . '}';
        }

        // Special
        if ( preg_match( '/saqui/', $style ) ) {
          $css .= $custom_class . ':hover { color: ' . $hover_background_color . '}';
        }
        if ( preg_match( '/aylen/', $style ) ) {
          $css .= $custom_class . ':after { background-color: ' . $hover_background_color . '}';

          // Only hex color is acceptable
          if ( preg_match( '/#([a-f]|[A-F]|[0-9]){3}(([a-f]|[A-F]|[0-9]){3})?\b/', $hover_background_color ) ) {
            $css .= $custom_class . ':before { background-color: ' . adjustBrightness( $hover_background_color, 50 ) . '}';
          } else {
            $css .= $custom_class . ':before { background-color: transparent; }';
          }
        }
      }

      // HOVER BORDER
      if ( $hover_border_color ) {
        $css .= $custom_class . ':hover { border-color: ' . $hover_border_color . '}';
        if ( preg_match( '/pipaluk|wapasha|antiman/', $style ) ) {
          $css .= $custom_class . ':hover:before { border-color: ' . $hover_border_color . '}';
        }
        if ( preg_match( '/antiman/', $style ) ) {
          $css .= $custom_class . ':before { border-color: ' . $hover_border_color . '}';
        }
        if ( preg_match( '/nuka|quidel/', $style ) ) {
          $css .= $custom_class . ':hover:before { background-color: ' . $hover_border_color . '}';
        }

        // Another rule
        if ( preg_match( '/sacnite/', $style ) ) {
          $css .= $custom_class . ':hover:before { box-shadow: inset 0 0 0 2px ' . $hover_border_color . '}';
        }
      }
    } // End if().

    return $css;
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Button extends WPBakeryShortCode {}
}
