<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * Elegant Addons Shortcode Drop Caps class.
 *
 * @since 1.0
 * @package Elegant Addons for VC
 */

class Vckit_Shortcode_Drop_Caps extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_drop_caps';
  protected $name = 'Drop Caps';
  protected $desc = 'Create nice Drop Caps';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/drop-caps.png' ),
      'params'      => array(

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Drop Caps character', 'legocreative' ),
          'param_name'  => 'drop_cap',
          'value'       => 'A',
        ),

        array(
          'type'        => 'textarea',
          'heading'     => __( 'Content', 'legocreative' ),
          'param_name'  => 'rest_content',
          'value'       => 't vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
        ),

        array(
          'type'              => 'dropdown',
          'heading'           => __( 'Drop Caps wrapper shape', 'legocreative' ),
          'param_name'        => 'dc_shape',
          'edit_field_class'  => 'vc_col-sm-4',
          'std'               => 'squared',
          'value'             => array(
            __( 'Squared', 'legocreative' ) => 'squared',
            __( 'Rounded', 'legocreative' ) => 'rounded',
            __( 'Circled', 'legocreative' ) => 'circled',
          ),
          'save_always'       => true,
        ),

        array(
          'type'              => 'dropdown',
          'heading'           => __( 'Drop Caps size', 'legocreative' ),
          'param_name'        => 'dc_size',
          'edit_field_class'  => 'vc_col-sm-4',
          'std'               => 'md',
          'value'             => array(
            __( 'Small', 'legocreative' ) => 'sm',
            __( 'Medium', 'legocreative' )  => 'md',
            __( 'Large', 'legocreative' )   => 'lg',
            __( 'X-large', 'legocreative' ) => 'xl',
          ),
          'save_always'       => true,
        ),

        array(
          'type'              => 'colorpicker',
          'heading'           => __( 'Drop Caps color', 'legocreative' ),
          'param_name'        => 'dc_color',
          'edit_field_class'  => 'vc_col-sm-4',
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Drop Caps background options', 'legocreative' ),
          'param_name'  => 'dc_bg_enable',
          'value'       => array(
            __( 'Enable', 'legocreative' ) => 'yes',
          ),
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Drop Caps Border options', 'legocreative' ),
          'param_name'  => 'dc_border_enable',
          'value'       => array(
            __( 'Enable', 'legocreative' ) => 'yes',
          ),
        ),

        // --- Background options ---
        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Background type', 'legocreative' ),
          'param_name'  => 'dc_bg_type',
          'std'         => 'color',
          'value'       => array(
            __( 'Background color', 'legocreative' ) => 'color',
            __( 'Background image', 'legocreative' ) => 'image',
          ),
          'dependency'  => array(
            'element'   => 'dc_bg_enable',
            'not_empty' => true,
          ),
          'save_always' => true,
          'group'       => __( 'Background Options', 'legocreative' ),
        ),

        array(
          'type'        => 'attach_image',
          'heading'     => __( 'Background image', 'legocreative' ),
          'param_name'  => 'dc_bg_img',
          'dependency'  => array(
            'element' => 'dc_bg_type',
            'value'   => 'image',
          ),
          'group'       => __( 'Background Options', 'legocreative' ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Backgound color type', 'legocreative' ),
          'param_name'  => 'dc_bg_color_type',
          'std'         => 'simple',
          'value'       => array(
            __( 'Simple', 'legocreative' )    => 'simple',
            __( 'Gradient', 'legocreative' )  => 'gradient',
          ),
          'dependency'  => array(
            'element' => 'dc_bg_type',
            'value'   => 'color',
          ),
          'save_always' => true,
          'group'       => __( 'Background Options', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Background color', 'legocreative' ),
          'param_name'  => 'dc_bg_color',
          'dependency'  => array(
            'element' => 'dc_bg_color_type',
            'value'   => 'simple',
          ),
          'group'       => __( 'Background Options', 'legocreative' ),
        ),

        array(
          'type'              => 'colorpicker',
          'heading'           => __( 'Gradient start color', 'legocreative' ),
          'param_name'        => 'dc_gradient_start',
          'edit_field_class'  => 'vc_col-sm-4',
          'dependency'        => array(
            'element' => 'dc_bg_color_type',
            'value'   => 'gradient',
          ),
          'group'             => __( 'Background Options', 'legocreative' ),
        ),

        array(
          'type'              => 'colorpicker',
          'heading'           => __( 'Gradient end color', 'legocreative' ),
          'param_name'        => 'dc_gradient_end',
          'edit_field_class'  => 'vc_col-sm-4',
          'dependency'        => array(
            'element' => 'dc_bg_color_type',
            'value'   => 'gradient',
          ),
          'group'             => __( 'Background Options', 'legocreative' ),
        ),

        array(
          'type'              => 'dropdown',
          'heading'           => __( 'Gradient direction', 'legocreative' ),
          'param_name'        => 'dc_gradient_dir',
          'edit_field_class'  => 'vc_col-sm-8',
          'description'       => __( 'Choose direction to apply gradient background', 'legocreative' ),
          'std'               => '0',
          'value'             => array(
            __( 'From top to bottom', 'legocreative' )            => '0',
            __( 'From bottom-left to top-right', 'legocreative' ) => '45',
            __( 'From right to left', 'legocreative' )            => '90',
            __( 'From top-left to bottom-right', 'legocreative' ) => '135',
            __( 'From bottom to top', 'legocreative' )            => '180',
            __( 'From top-right to bottom-left', 'legocreative' ) => '225',
            __( 'From left to right', 'legocreative' )            => '270',
            __( 'From bottom-right to top-left', 'legocreative' ) => '315',
          ),
          'dependency'        => array(
            'element' => 'dc_bg_color_type',
            'value'   => 'gradient',
          ),
          'save_always'       => true,
          'group'             => __( 'Background Options', 'legocreative' ),
        ),

        // --- Border options ---
        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Border type', 'legocreative' ),
          'param_name'  => 'dc_border_type',
          'description' => __( 'Gradient only work with Squared shape and Solid border.', 'legocreative' ),
          'std'         => 'normal',
          'value'       => array(
            __( 'Normal', 'legocreative' )    => 'normal',
            __( 'Gradient', 'legocreative' )  => 'gradient',
          ),
          'dependency'  => array(
            'element'   => 'dc_border_enable',
            'not_empty' => true,
          ),
          'save_always' => true,
          'group'       => __( 'Border Options', 'legocreative' ),
        ),

        array(
          'type'              => 'dropdown',
          'heading'           => __( 'Border width', 'legocreative' ),
          'param_name'        => 'dc_border_width',
          'edit_field_class'  => 'vc_col-sm-6',
          'std'               => 'md',
          'value'             => array(
            __( 'Thin', 'legocreative' )  => 'sm',
            __( 'Normal', 'legocreative' )  => 'md',
            __( 'Thick', 'legocreative' ) => 'lg',
            __( 'Thicker', 'legocreative' ) => 'xl',
          ),
          'dependency'  => array(
            'element'   => 'dc_border_enable',
            'not_empty' => true,
          ),
          'save_always'       => true,
          'group'             => __( 'Border Options', 'legocreative' ),
        ),

        array(
          'type'              => 'dropdown',
          'heading'           => __( 'Border style', 'legocreative' ),
          'param_name'        => 'dc_border_style',
          'edit_field_class'  => 'vc_col-sm-6',
          'std'               => 'solid',
          'value'             => array(
            __( 'Solid', 'legocreative' ) => 'solid',
            __( 'Dotted', 'legocreative' ) => 'dotted',
            __( 'Dashed', 'legocreative' ) => 'dashed',
            __( 'Double', 'legocreative' ) => 'double',
          ),
          'dependency'  => array(
            'element'   => 'dc_border_enable',
            'not_empty' => true,
          ),
          'save_always'       => true,
          'group'             => __( 'Border Options', 'legocreative' ),
        ),

        array(
          'type'              => 'colorpicker',
          'heading'           => __( 'Border color', 'legocreative' ),
          'param_name'        => 'dc_border_color',
          'dependency'        => array(
            'element' => 'dc_border_type',
            'value'   => 'normal',
          ),
          'save_always'       => true,
          'group'             => __( 'Border Options', 'legocreative' ),
        ),

        array(
          'type'              => 'colorpicker',
          'heading'           => __( 'Gradient start color', 'legocreative' ),
          'param_name'        => 'dc_border_gradient_start',
          'edit_field_class'  => 'vc_col-sm-4',
          'dependency'        => array(
            'element' => 'dc_border_type',
            'value'   => 'gradient',
          ),
          'group'             => __( 'Border Options', 'legocreative' ),
        ),

        array(
          'type'              => 'colorpicker',
          'heading'           => __( 'Gradient end color', 'legocreative' ),
          'param_name'        => 'dc_border_gradient_end',
          'edit_field_class'  => 'vc_col-sm-4',
          'dependency'        => array(
            'element' => 'dc_border_type',
            'value'   => 'gradient',
          ),
          'group'             => __( 'Border Options', 'legocreative' ),
        ),

        array(
          'type'              => 'dropdown',
          'heading'           => __( 'Gradient direction', 'legocreative' ),
          'param_name'        => 'dc_border_gradient_dir',
          'edit_field_class'  => 'vc_col-sm-8',
          'description'       => __( 'Choose direction to apply gradient border', 'legocreative' ),
          'std'               => '0',
          'value'             => array(
            __( 'From top to bottom', 'legocreative' )            => '0',
            __( 'From bottom-left to top-right', 'legocreative' ) => '45',
            __( 'From right to left', 'legocreative' )            => '90',
            __( 'From top-left to bottom-right', 'legocreative' ) => '135',
            __( 'From bottom to top', 'legocreative' )            => '180',
            __( 'From top-right to bottom-left', 'legocreative' ) => '225',
            __( 'From left to right', 'legocreative' )            => '270',
            __( 'From bottom-right to top-left', 'legocreative' ) => '315',
          ),
          'dependency'        => array(
            'element' => 'dc_border_type',
            'value'   => 'gradient',
          ),
          'save_always'       => true,
          'group'             => __( 'Border Options', 'legocreative' ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Display border options', 'legocreative' ),
          'param_name'  => 'custom_border',
          'description' => __( 'Display border on which edges you want. Default is all.', 'legocreative' ),
          'std'         => 'full',
          'value'       => array(
            __( 'Full - 4 edges', 'legocreative' )  => 'full',
            __( 'Custom', 'legocreative' )          => 'custom',
          ),
          'dependency'  => array(
            'element'   => 'dc_border_enable',
            'not_empty' => true,
          ),
          'save_always' => true,
          'group'       => __( 'Border Options', 'legocreative' ),
        ),

        array(
          'type'              => 'checkbox',
          'heading'           => __( 'Available edges', 'legocreative' ),
          'param_name'        => 'avail_edges',
          'edit_field_class'  => 'vc_col-xs-12 dc-avail-edges',
          'value'             => array(
            __( 'Top', 'legocreative' )    => 'top',
            __( 'Right', 'legocreative' )  => 'right',
            __( 'Bottom', 'legocreative' ) => 'bottom',
            __( 'Left', 'legocreative' )   => 'left',
          ),
          'dependency'        => array(
            'element' => 'custom_border',
            'value'   => 'custom',
          ),
          'group'             => __( 'Border Options', 'legocreative' ),
        ),

      ),
    );
  }



  /**
   * Functions to generate gradient css for background.
   *
   * @see https://github.com/twbs/bootstrap-sass/blob/master/assets/stylesheets/bootstrap/mixins/_gradients.scss
   * @see https://msdn.microsoft.com/en-us/library/ms532887(v=vs.85).aspx
   */

  protected function generateVerticalGradient( $gradient_start, $gradient_end, $gradient_dir ) {
    $dir = ( '0' === $gradient_dir ) ? 'top' : 'bottom';
    $dir_standard = ( '0' === $gradient_dir ) ? 'to bottom' : 'to top';

    $result = '';

    $result .= "background-image: -webkit-linear-gradient({$dir}, {$gradient_start} 0%, {$gradient_end} 100%);"; // Safari 5.1-6, Chrome 10+
    $result .= "background-image: -o-linear-gradient({$dir}, {$gradient_start} 0%, {$gradient_end} 100%);"; // Opera 12
    $result .= "background-image: linear-gradient({$dir_standard}, {$gradient_start} 0%, {$gradient_end} 100%);"; // Standard, IE10(?), Firefox 16+, Opera 12.10+, Safari 7+, Chrome 26+
    $result .= "filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='{$gradient_start}', endColorstr='{$gradient_end}', GradientType=0);"; // IE6,7
    $result .= "-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='{$gradient_start}', endColorstr='{$gradient_end}', GradientType=0);"; // IE8,9
    $result .= "background-image: -ms-linear-gradient({$dir}, {$gradient_start}, {$gradient_end});";
    $result .= 'background-repeat: repeat-x;';

    return $result;
  }

  protected function generateHorizontalGradient( $gradient_start, $gradient_end, $gradient_dir ) {
    $dir = ('90' === $gradient_dir) ? 'right' : 'left';
    $dir_standard = ('90' === $gradient_dir) ? 'to left' : 'to right';

    $result = '';

    $result .= "background-image: -webkit-linear-gradient({$dir}, {$gradient_start} 0%, {$gradient_end} 100%);"; // Safari 5.1-6, Chrome 10+
    $result .= "background-image: -o-linear-gradient({$dir}, {$gradient_start} 0%, {$gradient_end} 100%);"; // Opera 12
    $result .= "background-image: linear-gradient({$dir_standard}, {$gradient_start} 0%, {$gradient_end} 100%);"; // Standard, IE10(?), Firefox 16+, Opera 12.10+, Safari 7+, Chrome 26+
    $result .= "filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='{$gradient_start}', endColorstr='{$gradient_end}', GradientType=1);"; // IE6,7
    $result .= "-ms-filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='{$gradient_start}', endColorstr='{$gradient_end}', GradientType=1);"; // IE8,9
    $result .= "background-image: -ms-linear-gradient({$dir}, {$gradient_start}, {$gradient_end});"; // IE10(?)
    $result .= 'background-repeat: repeat-x;';

    return $result;
  }

  protected function generateDiagonalGradient( $gradient_start, $gradient_end, $gradient_dir ) {
    $gradient_dir -= 360;
    $result = '';

    $result .= "background-image: -webkit-linear-gradient({$gradient_dir}deg, {$gradient_start}, {$gradient_end});"; // Safari 5.1-6, Chrome 10+
    $result .= "background-image: -o-linear-gradient({$gradient_dir}deg, {$gradient_start}, {$gradient_end});"; // Opera 12
    $result .= "background-image: linear-gradient({$gradient_dir}deg, {$gradient_start}, {$gradient_end});"; // Standard, IE10, Firefox 16+, Opera 12.10+, Safari 7+, Chrome 26+
    $result .= 'background-repeat: repeat-x;';

    return $result;
  }

  public function generateGradient( $gradient_start, $gradient_end, $gradient_dir ) {
    $result = '';

    if ( '0' === $gradient_dir || '180' === $gradient_dir ) {
      $result = $this->generateVerticalGradient( $gradient_start, $gradient_end, $gradient_dir );
    } else if ( '90' === $gradient_dir || '270' === $gradient_dir ) {
      $result = $this->generateHorizontalGradient( $gradient_start, $gradient_end, $gradient_dir );
    } else {
      $result = $this->generateDiagonalGradient( $gradient_start, $gradient_end, $gradient_dir );
    }

    return $result;
  }



  /**
   * Functions to generate gradient css for border.
   * Not sure about IE support (As caniuse.com: IE11, Edge14+)
   *
   * @see https://developer.mozilla.org/en-US/docs/Web/CSS/border-image
   * @see http://www.hongkiat.com/blog/css-gradient-border/
   */

  protected function generateVerticalBorderGradient( $gradient_start, $gradient_end, $gradient_dir ) {
    $dir = ('0' === $gradient_dir) ? 'top' : 'bottom';
    $dir_standard = ('0' === $gradient_dir) ? 'to bottom' : 'to top';

    $result = '';

    $result .= "-webkit-border-image: -webkit-linear-gradient({$dir}, {$gradient_start} 0%, {$gradient_end} 100%);";
    $result .= "-moz-border-image: -moz-linear-gradient({$dir}, {$gradient_start} 0%, {$gradient_end} 100%);";
    $result .= "border-image: linear-gradient({$dir_standard}, {$gradient_start} 0%, {$gradient_end} 100%);";
    $result .= 'border-image-slice: 1;';

    return $result;
  }

  protected function generateHorizontalBorderGradient( $gradient_start, $gradient_end, $gradient_dir ) {
    $dir = ('90' === $gradient_dir) ? 'right' : 'left';
    $dir_standard = ('90' === $gradient_dir) ? 'to left' : 'to right';

    $result = '';

    $result .= "-webkit-border-image: -webkit-linear-gradient({$dir}, {$gradient_start} 0%, {$gradient_end} 100%);";
    $result .= "-moz-border-image: -moz-linear-gradient({$dir}, {$gradient_start} 0%, {$gradient_end} 100%);";
    $result .= "border-image: linear-gradient({$dir_standard}, {$gradient_start} 0%, {$gradient_end} 100%);";
    $result .= 'border-image-slice: 1;';

    return $result;
  }

  protected function generateDiagonalBorderGradient( $gradient_start, $gradient_end, $gradient_dir ) {
    $gradient_dir -= 360;
    $result = '';

    $result .= "-webkit-border-image: -webkit-linear-gradient({$gradient_dir}deg, {$gradient_start} 0%, {$gradient_end} 100%);";
    $result .= "-moz-border-image: -moz-linear-gradient({$gradient_dir}deg, {$gradient_start} 0%, {$gradient_end} 100%);";
    $result .= "border-image: linear-gradient({$gradient_dir}deg, {$gradient_start} 0%, {$gradient_end} 100%);";
    $result .= 'border-image-slice: 1;';

    return $result;
  }

  public function generateBorderGradient( $gradient_start, $gradient_end, $gradient_dir ) {
    $result = '';

    if ( '0' === $gradient_dir || '180' === $gradient_dir ) {
      $result = $this->generateVerticalBorderGradient( $gradient_start, $gradient_end, $gradient_dir );
    } else if ( '90' === $gradient_dir || '270' === $gradient_dir ) {
      $result = $this->generateHorizontalBorderGradient( $gradient_start, $gradient_end, $gradient_dir );
    } else {
      $result = $this->generateDiagonalBorderGradient( $gradient_start, $gradient_end, $gradient_dir );
    }

    return $result;
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Drop_Caps extends WPBakeryShortCode {}
}
