<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * Elegant Addons Shortcode Google Map class.
 *
 * @since 1.0
 * @package Elegant Addons for VC
 */

class Vckit_Shortcode_Google_Map extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_google_map';
  protected $name = 'Google Map';
  protected $desc = 'Google Map shortcode';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/google-map.png' ),
      'params'  => array(

        // --- General ---
        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Set location by', 'legocreative' ),
          'param_name'  => 'location_by',
          'description' => __( 'Set map center by Address or Coordinate.', 'legocreative' ),
          'value'       => array(
            __( 'Address', 'legocreative' )     => 'address',
            __( 'Coordinate', 'legocreative' )  => 'coordinate',
          ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Address', 'legocreative' ),
          'param_name'  => 'address',
          'value'       => 'Greenwich, London, UK',
          'dependency'  => array(
            'element' => 'location_by',
            'value'   => 'address',
          ),
        ),

        array(
          'type'              => 'textfield',
          'heading'           => __( 'Latitude', 'legocreative' ),
          'param_name'        => 'latitude',
          'description'       => __( 'GPS Coordinates - Latitude (Decimal degrees)', 'legocreative' ),
          'value'             => '51.482750',
          'edit_field_class'  => 'vc_col-xs-6',
          'dependency'        => array(
            'element' => 'location_by',
            'value'   => 'coordinate',
          ),
        ),

        array(
          'type'              => 'textfield',
          'heading'           => __( 'Longitude', 'legocreative' ),
          'param_name'        => 'longitude',
          'description'       => __( 'GPS Coordinates - Longitude (Decimal degrees)', 'legocreative' ),
          'value'             => '-0.007627',
          'edit_field_class'  => 'vc_col-xs-6',
          'dependency'        => array(
            'element' => 'location_by',
            'value'   => 'coordinate',
          ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Map height', 'legocreative' ),
          'param_name'  => 'height',
          'description' => __( 'Enter map height in pixel', 'legocreative' ),
          'value'       => '480',
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Zoom level', 'legocreative' ),
          'param_name'  => 'zoom_level',
          'description' => __( 'The initial Map zoom level. Valid values: Integers between zero, and up to the supported maximum zoom level.', 'legocreative' ),
          'value'       => '12',
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Map type', 'legocreative' ),
          'param_name'  => 'map_type',
          'description' => __( 'The initial Map mapTypeId. Defaults to ROADMAP.', 'legocreative' ),
          'value'       => array(
            'Roadmap'   => 'roadmap',
            'Satellite' => 'satellite',
            'Hybrid'    => 'hybrid',
            'Terrain'   => 'terrain',
          ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Map style', 'legocreative' ),
          'param_name'  => 'map_style',
          'description' => __( 'Styles to apply to each of the default map types. Note that for satellite/hybrid and terrain modes, these styles will only apply to labels and geometry.', 'legocreative' ),
          'value'       => array(
            'Default'                         => 'default',
            'Light Dream'                     => 'style01',
            'Blue Essence'                    => 'style02',
            'Apple Maps-esque'                => 'style03',
            'Apple Maps-esque+'               => 'style04',
            'Midnight Commander'              => 'style05',
            'Paper'                           => 'style06',
            'Light gray'                      => 'style07',
            'Mondrian'                        => 'style08',
            'Icy Blue'                        => 'style09',
            'MapBox'                          => 'style10',
            'Simple and Light'                => 'style11',
            'Clean cut'                       => 'style12',
            'Nature'                          => 'style13',
            'Hopper'                          => 'style14',
            'Pastel tones'                    => 'style15',
            'Vintage Simple Blue and Yellow'  => 'style16',
            '50 Shades of Blue'               => 'style17',
            'Neon World'                      => 'style18',
            'Bates green'                     => 'style19',
            'Dark yellow'                     => 'style20',
            'Military'                        => 'style21',
            'Esperanto'                       => 'style22',
            'Blue Taticle'                    => 'style23',
            'Mrad Architecture Map'           => 'style24',
            'Subtle Pink'                     => 'style25',
            'Holiday'                         => 'style26',
            'Colorblind-friendly'             => 'style27',
            'Custom'                          => 'custom',
          ),
        ),

        array(
          'type'        => 'textarea_raw_html',
          'heading'     => __( 'Map style snippet', 'legocreative' ),
          'param_name'  => 'map_style_snippet',
          'description' => __( 'Go to https://snazzymaps.com, create your own or search for your expected style, then copy and paste snippet here.', 'legocreative' ),
          'dependency'  => array(
            'element' => 'map_style',
            'value'   => 'custom',
          ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'If you want to use multiple Google Maps in one page, please add a class name for them.', 'legocreative' ),
        ),

        // --- Advanced Settings ---
        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Markers', 'legocreative' ),
          'param_name'  => 'marker_enable',
          'std'         => 'true',
          'value'       => array(
            __( 'Enable', 'legocreative' ) => 'true',
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Marker type', 'legocreative' ),
          'param_name'  => 'custom_icon_enable',
          'description' => __( 'Don\'t want to use default icon of google maps? Use your custom icon.', 'legocreative' ),
          'value'       => array(
            __( 'Use custom icon', 'legocreative' )   => 'true',
          ),
          'dependency'  => array(
            'element'   => 'marker_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'attach_image',
          'heading'     => __( 'Marker icon', 'legocreative' ),
          'param_name'  => 'marker_icon',
          'description' => __( 'Choose your custom icon for marker. You can also use image. (You can visit https://mapicons.mapsmarker.com/ to get many nice icons.)', 'legocreative' ),
          'dependency'  => array(
            'element'   => 'custom_icon_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'              => 'checkbox',
          'heading'           => __( 'Infowindow', 'legocreative' ),
          'param_name'        => 'infowindow_enable',
          'description'       => __( 'Enable to display Infowindow.', 'legocreative' ),
          'value'             => array(
            __( 'Enable', 'legocreative' ) => 'true',
          ),
          'edit_field_class'  => 'infowindow-setting-divider vc_col-xs-12',
          'group'             => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Infowindow Layout', 'legocreative' ),
          'param_name'  => 'infowindow_layout',
          'description' => __( 'Choose layout to display the Infowindow.', 'legocreative' ),
          'value'       => array(
            __( 'Text only', 'legocreative' )               => 'default',
            __( 'Image top - Text bottom', 'legocreative' ) => 'layout1',
            __( 'Image left - Text right', 'legocreative' ) => 'layout2',
            __( 'Image right - Text left', 'legocreative' ) => 'layout3',
            __( 'Custom HTML', 'legocreative' )             => 'custom',
          ),
          'dependency'  => array(
            'element'   => 'infowindow_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'attach_image',
          'heading'     => __( 'Infowindow image', 'legocreative' ),
          'param_name'  => 'infowindow_image',
          'dependency'  => array(
            'element' => 'infowindow_layout',
            'value'   => array(
              'layout1',
              'layout2',
              'layout3',
            ),
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Infowindow heading', 'legocreative' ),
          'param_name'  => 'infowindow_heading',
          'description' => __( 'You can leave it empty if you don\'t want to display heading of infowindow', 'legocreative' ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
          'dependency'  => array(
            'element'   => 'infowindow_enable',
            'not_empty' => true,
          ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Infowindow heading background color', 'legocreative' ),
          'param_name'  => 'infowindow_heading_background',
          'description' => __( 'We only support 4 colors on Google logo at the moment', 'legocreative' ),
          'value'       => array(
            __( 'Blue', 'legocreative' ) => 'blue',
            __( 'Red', 'legocreative' ) => 'red',
            __( 'Yellow', 'legocreative' ) => 'yellow',
            __( 'Green', 'legocreative' ) => 'green',
          ),
          'dependency'  => array(
            'element'   => 'infowindow_heading',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'textarea_html',
          'heading'     => __( 'Infowindow content', 'legocreative' ),
          'param_name'  => 'content',
          'description' => __( 'It should be only text (heading and paragraph are OK) when you choose any layout that is different from \'Custom HTML\'.', 'legocreative' ),
          'dependency'  => array(
            'element'   => 'infowindow_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        // --- Control Settings
        array(
          'type'              => 'checkbox',
          'param_name'        => 'zoom_control_disable',
          'value'             => array(
            __( 'Disables Zoom control. By default Zoom control is enable.', 'legocreative' ) => 'yes',
          ),
          'edit_field_class'  => 'control-setting',
          'group'             => __( 'Control Settings', 'legocreative' ),
        ),

        array(
          'type'              => 'checkbox',
          'param_name'        => 'street_view_control_disable',
          'value'             => array(
            __( 'Disable state of the Street View Pegman control. By default Street View control is enable.', 'legocreative' ) => 'yes',
          ),
          'edit_field_class'  => 'control-setting',
          'group'             => __( 'Control Settings', 'legocreative' ),
        ),

        array(
          'type'              => 'checkbox',
          'param_name'        => 'draggable_disable',
          'value'             => array(
            __( 'Prevents the map from being dragged. By default the map is draggable.', 'legocreative' ) => 'yes',
          ),
          'edit_field_class'  => 'control-setting',
          'group'             => __( 'Control Settings', 'legocreative' ),
        ),

        array(
          'type'              => 'checkbox',
          'param_name'        => 'double_click_zoom_disable',
          'value'             => array(
            __( 'Disables zoom and center on double click. By default double click zooming is enable.', 'legocreative' ) => 'yes',
          ),
          'edit_field_class'  => 'control-setting',
          'group'             => __( 'Control Settings', 'legocreative' ),
        ),

        array(
          'type'              => 'checkbox',
          'param_name'        => 'scrollwheel_zoom_disable',
          'value'             => array(
            __( 'Disables scrollwheel zooming on the map. By default scrollwheel zooming is enable.', 'legocreative' ) => 'yes',
          ),
          'edit_field_class'  => 'control-setting',
          'group'             => __( 'Control Settings', 'legocreative' ),
        ),

        array(
          'type'              => 'checkbox',
          'param_name'        => 'map_type_control_disable',
          'value'             => array(
            __( 'Disables Map type control. By default Map type control is enable at the top-left conner.', 'legocreative' ) => 'yes',
          ),
          'edit_field_class'  => 'control-setting',
          'group'             => __( 'Control Settings', 'legocreative' ),
        ),

        array(
          'type'              => 'checkbox',
          'param_name'        => 'icon_clickable_disable',
          'value'             => array(
            __( 'A map icon represents a point of interest, also known as a POI. By default map icons are clickable. Check this to disable it.', 'legocreative' ) => 'yes',
          ),
          'edit_field_class'  => 'control-setting',
          'group'             => __( 'Control Settings', 'legocreative' ),
        ),

      ),
    );
  }

  public function enqueueScripts() {
    wp_enqueue_script( 'vckit_google_map_js' );
    wp_enqueue_script( 'gmap3' );
    wp_enqueue_script( 'vckit-google-map-shortcode' );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Google_Map extends WPBakeryShortCode {}
}
