<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}


/**
 * VC KIT Shortcode Interactive Notification class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Interactive_Notification extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_interactive_notification';
  protected $name = 'Interactive Notification';
  protected $desc = 'Inspiration for Notification Indicators';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/interactive-notification.png' ),
      'params'      => array(
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Notification layout', 'legocreative' ),
          'param_name' => 'layout',
          'value'      => array(
            __( 'Growl', 'legocreative' )  => 'growl',
            __( 'Attached', 'legocreative' )  => 'attached',
            __( 'Bar', 'legocreative' )  => 'bar',
            __( 'Other', 'legocreative' )  => 'other',
          ),
          'std'         => 'growl',
          'description' => __( 'Select layout for the notification.', 'legocreative' ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Effect', 'legocreative' ),
          'param_name' => 'growl_effect',
          'value'      => array(
            __( 'Scale', 'legocreative' )  => 'scale',
            __( 'Jelly', 'legocreative' )  => 'jelly',
            __( 'Slide in', 'legocreative' )  => 'slide',
            __( 'Genie', 'legocreative' )  => 'genie',
          ),
          'description' => __( 'Select effect.', 'legocreative' ),
          'dependency' => array(
            'element' => 'layout',
            'value'   => array( 'growl' ),
          ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Effect', 'legocreative' ),
          'param_name' => 'attached_effect',
          'value'      => array(
            __( 'Flip', 'legocreative' )  => 'flip',
            __( 'Bouncy', 'legocreative' )  => 'bouncyflip',
          ),
          'description' => __( 'Select effect.', 'legocreative' ),
          'dependency' => array(
            'element' => 'layout',
            'value'   => array( 'attached' ),
          ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Effect', 'legocreative' ),
          'param_name' => 'bar_effect',
          'value'      => array(
            __( 'Slide on top', 'legocreative' )  => 'slidetop',
            __( 'Expading loader', 'legocreative' )  => 'exploader',
          ),
          'description' => __( 'Select effect.', 'legocreative' ),
          'dependency' => array(
            'element' => 'layout',
            'value'   => array( 'bar' ),
          ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Effect', 'legocreative' ),
          'param_name' => 'other_effect',
          'value'      => array(

            // Remove conner expand in version 2
            // __( 'Corner expand', 'legocreative' )  => 'cornerexpand',

            __( 'Loading circle', 'legocreative' )  => 'loadingcircle',
            __( 'Box spinner', 'legocreative' )  => 'boxspinner',
            __( 'Thumb slider', 'legocreative' )  => 'thumbslider',
          ),
          'description' => __( 'Select effect.', 'legocreative' ),
          'dependency' => array(
            'element' => 'layout',
            'value'   => array( 'other' ),
          ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Notification Type', 'legocreative' ),
          'param_name' => 'type',
          'value'      => array(
            __( 'Notice', 'legocreative' )  => 'notice',
            __( 'warning', 'legocreative' )  => 'warning',
            __( 'Error', 'legocreative' )  => 'error',
            __( 'Success', 'legocreative' )  => 'success',
          ),
          'std'         => 'notice',
          'description' => __( 'Select type of notification.', 'legocreative' ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Show notification', 'legocreative' ),
          'param_name' => 'event',
          'value'      => array(
            __( 'When page loaded', 'legocreative' )  => 'loaded',
            __( 'When scroll to its position', 'legocreative' )  => 'scrolled',
          ),
          'std'         => 'loaded',
          'description' => __( 'Choose time to show the notification.', 'legocreative' ),
        ),
        array(
          'type'        => 'attach_image',
          'heading'     => 'Image',
          'param_name'  => 'image',
          'description' => __( 'Select thumbnail', 'legocreative' ),
          'dependency' => array(
            'element' => 'other_effect',
            'value'   => array( 'thumbslider' ),
          ),
        ),
        array(
          'type'       => 'iconpicker',
          'heading'    => __( 'Icon', 'legocreative' ),
          'param_name' => 'icon_fontawesome',
          'value'      => 'fa fa-image',
          'settings'   => array(
            'emptyIcon' => false,
          ),
          'dependency' => array(
            'element' => 'layout',
            'value'   => array( 'bar' ),
          ),
          'description' => __( 'Select icon from library.', 'legocreative' ),
        ),
        array(
          'type'       => 'iconpicker',
          'heading'    => __( 'Icon', 'legocreative' ),
          'param_name' => 'icon_for_cornerexpand',
          'value'      => 'fa fa-image',
          'settings'   => array(
            'emptyIcon' => false,
          ),
          'dependency' => array(
            'element' => 'other_effect',
            'value'   => array( 'cornerexpand' ),
          ),
          'description' => __( 'Select icon from library.', 'legocreative' ),
        ),
        array(
          'type'         => 'textarea_html',
          'heading'      => __( 'Notification content', 'legocreative' ),
          'param_name'   => 'content',
          'description'  => __( 'Add content here', 'legocreative' ),
          'value'        => 'yo!',
        ),
        //array(
          //'type' => 'checkbox',
          //'heading' => __( 'Show close button', 'legocreative' ),
          //'param_name' => 'close_btn',
          //'value' => array( __( 'Yes', 'legocreative' ) => 'yes' ),
        //),
        array(
          'type'             => 'textfield',
          'heading'          => __( 'Delay before start', 'legocreative' ),
          'param_name'       => 'delay',
          'value'            => '3',
          'description'      => __( 'Delay before start. Value in seconds', 'legocreative' ),
          'dependency' => array(
            'element' => 'event',
            'value'   => 'loaded',
          ),
        ),
        array(
          'type'             => 'textfield',
          'heading'          => __( 'Duration', 'legocreative' ),
          'param_name'       => 'duration',
          'value'            => '6',
          'description'      => __( 'Set duration (timeout) for the notification. Value in seconds', 'legocreative' ),
        ),
        array(
          'type'         => 'textfield',
          'heading'      => __( 'Extra class name', 'legocreative' ),
          'param_name'   => 'el_class',
          'description'  => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Interactive_Notification extends WPBakeryShortCode {}
}

