<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Interactive Item class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Interactive extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_interactive';
  protected $name = 'Interactive Hover';
  protected $desc = 'Creative and subtle hover effects.';

  /**
   * Hooks
   *
   * @since  1.0
   * @return void
   */
  function hooks() {
    parent::hooks();
  }

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/interactive-hover.png' ),
      'params' => array(
        array(
          'type' => 'dropdown',
          'heading' => __( 'Square ratio', 'legocreative' ),
          'param_name' => 'ratio',
          'value' => array(
            __( 'Original', 'legocreative' )   => 'original',
            __( '4:3', 'legocreative' )        => '43',
            __( '1:1 Square', 'legocreative' ) => '11',
            __( '16:9', 'legocreative' )       => '169',
            __( '3:2', 'legocreative' )        => '32',
            __( '2:1', 'legocreative' )        => '21',
            __( '3:4', 'legocreative' )        => '34',
          ),
          'description' => __( 'Select image size.', 'legocreative' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Effect', 'legocreative' ),
          'param_name' => 'effect',
          'value' => $this->getEffects(),
          'std' => 'lily',
          'description' => __( 'Select hover effect you want to display.', 'legocreative' ),
        ),
        array(
          'type'        => 'attach_image',
          'heading'     => 'Image',
          'param_name'  => 'image',
          'description' => __( 'Select image from media library for effect, Default image size should be 960x720', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Heading thin text', 'legocreative' ),
          'param_name' => 'heading_thin',
          'value' => 'Interactive',
          'description' => __( 'Choose heading thin text', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Heading bold text', 'legocreative' ),
          'param_name' => 'heading_bold',
          'value' => 'Hover',
          'description' => __( 'Choose heading bold text', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'textarea',
          'heading' => __( 'Description text', 'legocreative' ),
          'param_name' => 'description',
          'value' => '',
          'description' => __( "Description to uppear, example: Roxy was my best friend. She'd cross any border for me.", 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Use theme default font family?', 'legocreative' ),
          'param_name' => 'disable_font',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Use font family from the theme.', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Add link to image', 'legocreative' ),
          'param_name' => 'enable_link',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Enable this option to add link to image', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Url', 'legocreative' ),
          'param_name' => 'url',
          'value' => '',
          'description' => __( 'Add link to image', 'legocreative' ),
          'dependency' => array(
            'element' => 'enable_link',
            'value' => array( 'yes' ),
          ),
        ),
        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Open link in new tab', 'legocreative' ),
          'param_name'  => 'link_new_tab',
          'value'       => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Enable this option to open link in new tab', 'legocreative' ),
          'dependency'  => array(
            'element' => 'enable_link',
            'value'   => array( 'yes' ),
          ),
        ),
        array(
          'type'       => 'textfield',
          'heading'    => __( 'Extra class name', 'legocreative' ),
          'param_name' => 'el_class',
          'description'       => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Image opacity', 'legocreative' ),
          'param_name' => 'image_opacity',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Interactive hover set opacity on Image to create the overlay. Choose image opacity', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Hover image opacity', 'legocreative' ),
          'param_name' => 'hover_image_opacity',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Choose hover image opacity', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Text Color', 'legocreative' ),
          'param_name' => 'color',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select color for heading and paragraph.', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Hover text color', 'legocreative' ),
          'param_name' => 'hover_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select color for when hover in.', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Overlay color', 'legocreative' ),
          'param_name' => 'overlay_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Hover overlay color', 'legocreative' ),
          'param_name' => 'hover_overlay_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Heading font size', 'legocreative' ),
          'group'      => __( 'Customize', 'legocreative' ),
          'param_name' => 'heading_font_size',
          'description' => __( 'Choose heading font size', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Description font size', 'legocreative' ),
          'group'      => __( 'Customize', 'legocreative' ),
          'param_name' => 'description_font_size',
          'description' => __( 'Choose description font size', 'legocreative' ),
        ),
        array(
          'type'       => 'vckit_class',
          'heading'    => '',
          'param_name' => 'custom_class',
          'group'      => __( 'Customize', 'legocreative' ),
          'value'      => '',
        ),

        array(
          'type' => 'css_editor',
          'heading' => __( 'CSS box', 'legocreative' ),
          'param_name' => 'css',
          'group' => __( 'Design Options', 'legocreative' ),
        ),
      ),
    );
  }

  public function registerScripts() {
    $query_args = apply_filters( 'vc_addons_kit_interactive_fonts', array(
      'family' => 'Raleway:300,400,800',
      'subset' => 'latin,latin-ext',
    ) );
    wp_register_style( 'vckit_interactive_hover_fonts', add_query_arg( $query_args, '//fonts.googleapis.com/css' ), array(), null );
  }

  /**
   * Load plugin google fonts
   */
  public function loadFonts() {
    wp_enqueue_style( 'vckit_interactive_hover_fonts' );
  }

  public function getEffects( $reverse = false ) {
    $effects = apply_filters( 'vc_addons_kit_interactive_hover_effect', array(
      __( 'Lily', 'legocreative' )   => 'lily',
      __( 'Sadie', 'legocreative' )  => 'sadie',
      __( 'Honey', 'legocreative' )  => 'honey',
      __( 'Layla', 'legocreative' )  => 'layla',
      __( 'Zoe', 'legocreative' )    => 'zoe',
      __( 'Oscar', 'legocreative' )  => 'oscar',
      __( 'Marley', 'legocreative' ) => 'marley',
      __( 'Ruby', 'legocreative' )   => 'ruby',
      __( 'Roxy', 'legocreative' )   => 'roxy',
      __( 'Bubba', 'legocreative' )  => 'bubba',
      __( 'Romeo', 'legocreative' )  => 'romeo',
      __( 'Dexter', 'legocreative' ) => 'dexter',
      __( 'Sarah', 'legocreative' )  => 'sarah',
      __( 'Chico', 'legocreative' )  => 'chico',
      __( 'Milo', 'legocreative' )   => 'milo',

      // set2
      __( 'Julia', 'legocreative' )   => 'julia',
      __( 'Goliath', 'legocreative' ) => 'goliath',
      __( 'Hera', 'legocreative' )    => 'hera',
      __( 'Winston', 'legocreative' ) => 'winston',
      __( 'Selena', 'legocreative' )  => 'selena',
      __( 'Terry', 'legocreative' )   => 'terry',
      __( 'Phoebe', 'legocreative' )  => 'phoebe',
      __( 'Apollo', 'legocreative' )  => 'apollo',
      __( 'Kira', 'legocreative' )    => 'kira',
      __( 'Steve', 'legocreative' )   => 'steve',
      __( 'Moses', 'legocreative' )   => 'moses',
      __( 'Jazz', 'legocreative' )    => 'jazz',
      __( 'Ming', 'legocreative' )    => 'ming',
      __( 'Lexi', 'legocreative' )    => 'lexi',
      __( 'Duke', 'legocreative' )    => 'duke',
    ));

    if ( $reverse ) {
      $rev = array();

      foreach ( $effects as $key => $value ) {
        $rev[ $value ] = $key;
      }

      return $rev;
    }

    return $effects;
  }

  public function getCustomCSS( $atts ) {
    $color =
    $hover_color =
    $heading_font_size =
    $description_font_size =
    $image_opacity =
    $hover_image_opacity =
    $overlay_color =
    $hover_overlay_color =
    $custom_class = '';

    if ( ! isset( $atts ) ) {
      return '';
    }

    extract( $atts );

    $css = '';
    if ( $custom_class ) {
      $custom_class = '.effect-hover.' . $custom_class;

      // Fontsize
      if ( $heading_font_size ) {
        $css .= $custom_class . ' h2 { font-size: ' . $heading_font_size . '; }';
      }
      if ( $description_font_size ) {
        $css .= $custom_class . ' p { font-size: ' . $description_font_size . '; }';
      }

      // Color
      if ( $color ) {
        $css .= $custom_class . ' h2, ' . $custom_class . ' p { color: ' . $color . '; }';
      }
      if ( $hover_color ) {
        $css .= $custom_class . ':hover h2, ' . $custom_class . ':hover p { color: ' . $hover_color . '; }';
      }

      // Opacity
      if ( $image_opacity ) {
        $css .= $custom_class . ' img { opacity: ' . $image_opacity . '; }';
      }
      if ( $hover_image_opacity ) {
        $css .= $custom_class . ':hover img { opacity: ' . $hover_image_opacity . '; }';
      }

      // Overlay
      if ( $overlay_color ) {
        $css .= $custom_class . ' { background: ' . $overlay_color . '; }';
      }
      if ( $hover_overlay_color ) {
        $css .= $custom_class . ':hover { background: ' . $hover_overlay_color . '; }';
      }
    }

    return $css;
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Interactive_Item extends WPBakeryShortCode {}
}
