<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Sample class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Onepage_Navigator extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_onepage_navigator';
  protected $name = 'One Page Navigator';
  protected $desc = 'Setting and customize your own NavBar';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/one-page-navigator.png' ),
      'params'      => array(
        array(
          'type'        => 'dropdown',
          'heading'     => 'Choose position',
          'description' => __( 'Choose the position of the NavBar here', 'legocreative' ),
          'param_name'  => 'position',
          'value' => array(
            __( 'Bottom', 'legocreative' ) => 'bottom',
            __( 'Left','legocreative' )    => 'left',
            __( 'Right','legocreative' )   => 'right',
          ),
          'std' => 'bottom',
        ),
        array(
          'type'        => 'param_group',
          'heading'     => __( 'Navigator', 'legocreative' ),
          'description' => __( 'Enter features for your dots.', 'legocreative' ),
          'param_name'  => 'navigators',
          'value' => urlencode(json_encode(array(
            array(
              'link'  => '#contact',
              'title' => __( 'Contact', 'legocreative' ),
            ),
          ))),
          'params' => array(
            array(
              'type'        => 'textfield',
              'value'       => '',
              'heading'     => 'Title',
              'param_name'  => 'title',
              'admin_label' => true,
            ),
            array(
              'type'        => 'textfield',
              'value'       => '#',
              'heading'     => 'Target',
              'description' => __( 'Enter the link that you want to parse here', 'legocreative' ),
              'param_name'  => 'link',
              'admin_label' => true,
            ),
            array(
              'type'       => 'checkbox',
              'heading'    => __( 'Add Icon', 'legocreative' ),
              'param_name' => 'add_icon',
              'value'      => array(
                __( 'Yes', 'legocreative' ) => 'yes',
              ),
            ),
            array(
              'type'        => 'iconpicker',
              'heading'     => __( 'Icon', 'legocreative' ),
              'param_name'  => 'icon_fontawesome',
              'group'       => __( 'Icon', 'legocreative' ),
              'value'       => 'fa fa-circle',
              'settings'    => array(
                'emptyIcon' => false,
              ),
              'dependency' => array(
                'element'  => 'add_icon',
                'value'    => 'yes',
              ),
              'description' => __( 'Select icon from library.', 'legocreative' ),
            ),
          ),
        ),
        array(
          'type'             => 'colorpicker',
          'heading'          => __( 'Bar background color', 'legocreative' ),
          'param_name'       => 'nav_color',
          'description'      => __( 'Choose your background color', 'legocreative' ),
        ),
        array(
          'type'             => 'colorpicker',
          'heading'          => __( 'Item background color', 'legocreative' ),
          'param_name'       => 'dot_color',
          'description'      => __( 'Choose your dot background color', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'             => 'colorpicker',
          'heading'          => __( 'Item active background color', 'legocreative' ),
          'param_name'       => 'dot_active_color',
          'description'      => __( 'Choose your dot active background color', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'             => 'colorpicker',
          'heading'          => __( 'Item border color', 'legocreative' ),
          'param_name'       => 'dot_border',
          'description'      => __( 'Choose your dot border', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'             => 'colorpicker',
          'heading'          => __( 'Item active border color', 'legocreative' ),
          'param_name'       => 'dot_active_border',
          'description'      => __( 'Choose your dot active border', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'             => 'textfield',
          'heading'          => __( 'Speed', 'legocreative' ),
          'param_name'       => 'speed',
          'value'            => '750',
          'description'      => __( 'Navigation speed', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Top offset', 'legocreative' ),
          'param_name' => 'top_offset',
          'value' => '0',
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __('Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative'),
        ),
        array(
          'type'       => 'vckit_class',
          'heading'    => '',
          'param_name' => 'custom_class',
          'value'      => '',
        ),
      ),
    );
  }

  public function getCustomCSS( $atts ) {
    $dot_active_color = '';
    $nav_color = '';
    $dot_color = '';
    $dot_border = '';
    $dot_active_border = '';
    $custom_class = '';

    extract( $atts );

    $css = '';
    if ( $custom_class ) {
      $custom_class = '.' . $custom_class;

      // HOVER TEXT
      if ( $nav_color ) {
        $css .= $custom_class . '.vckit-navigator { background-color: '
          . $nav_color . '; box-shadow: 1px 1px 2px 0 rgba(0,0,0,0.44) }';
      }
      if ( $dot_color ) {
        $css .= $custom_class . '.vckit-navigator a .dot { color: '
          . $dot_color . '; background-color: '
          . $dot_color . '; }';
      }
      if ( $dot_border ) {
        $css .= $custom_class . '.vckit-navigator a .dot { border-color: '
          . $dot_border . '; }';
      }
      if ( $dot_active_color ) {
        $css .= $custom_class . '.vckit-navigator a:hover .dot,'
          . $custom_class . '.vckit-navigator a.vckit-active .dot { color: '
          . $dot_active_color . '; background-color: '
          . $dot_active_color . '; }';
      }
      if ( $dot_active_border ) {
        $css .= $custom_class . '.vckit-navigator a:hover .dot,'
          . $custom_class . '.vckit-navigator a.vckit-active .dot { border-color: '
          . $dot_active_border . ' } ';
      }
    }

    return $css;
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Onepage_Navigator extends WPBakeryShortCode {}
}
