<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Carousel class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Scroller_Image extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_scroller_image';
  protected $name = 'Scroller Image';
  protected $desc = '';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/scroller-image.png' ),
      'params' => array(
        array(
          'type' => 'attach_image',
          'param_name' => 'image',
          'heading' => __( 'Image', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'param_name' => 'height',
          'heading' => __( 'Height', 'legocreative' ),
          'std' => '500',
          'description' => __( 'Height of frame view. Unit is pixel (px)', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'checkbox',
          'param_name' => 'config_border',
          'heading' => __( 'Config border', 'legocreative' ),
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'std' => 'no',
        ),
        array(
          'type' => 'textfield',
          'param_name' => 'border_width',
          'heading' => __( 'Border width', 'legocreative' ),
          'std' => '0',
          'dependency' => array(
            'element' => 'config_border',
            'value' => 'yes',
          ),
          'description' => __( 'Unit is pixel (px)', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'border_style',
          'heading' => __( 'Border style', 'legocreative' ),
          'value' => array(
            __( 'Dashed' ) => 'dashed',
            __( 'Dotted' ) => 'dotted',
            __( 'Double' ) => 'double',
            __( 'Groove' ) => 'groove',
            __( 'Ridge' ) => 'ridge',
            __( 'Solid' ) => 'solid',
            __( 'Inset' ) => 'inset',
            __( 'Outset' ) => 'outset',
          ),
          'std' => 'solid',
          'dependency' => array(
            'element' => 'config_border',
            'value' => 'yes',
          ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'colorpicker',
          'param_name' => 'border_color',
          'heading' => __( 'Border color', 'legocreative' ),
          'std' => '#DDDDDD',
          'dependency' => array(
            'element' => 'config_border',
            'value' => 'yes',
          ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'textfield',
          'param_name' => 'border_radius',
          'heading' => __( 'Border radius', 'legocreative' ),
          'std' => '0',
          'dependency' => array(
            'element' => 'config_border',
            'value' => 'yes',
          ),
          'description' => __( 'Unit is pixel (px)', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'textfield',
          'param_name' => 'duration',
          'heading' => __( 'Duration', 'legocreative' ),
          'std' => '2',
          'description' => __( 'Duration to view image. Unit is second (s)', 'legocreative' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'effect',
          'heading' => __( 'Effect', 'legocreative' ),
          'value' => array(
            __( 'Ease', 'legocreative' ) => 'ease',
            __( 'Ease in', 'legocreative' ) => 'ease-in',
            __( 'Ease out', 'legocreative' ) => 'ease-out',
            __( 'Ease in out', 'legocreative' ) => 'ease-in-out',
            __( 'Linear', 'legocreative' ) => 'linear',
          ),
          'std' => 'ease',
          'description' => __( 'Image movement effect', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'param_name' => 'delay',
          'heading' => __( 'Delay', 'legocreative' ),
          'std' => '0',
          'description' => __( 'Delay before scroll image. Unit is second (s)', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'param_name' => 'enable_link',
          'heading' => __( 'Enable link', 'legocreative' ),
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'std' => 'no',
        ),
        array(
          'type' => 'textfield',
          'param_name' => 'link',
          'heading' => __( 'Link', 'legocreative' ),
          'dependency' => array(
            'element' => 'enable_link',
            'value' => 'yes',
          ),
        ),
        array(
          'type'        => 'textfield',
          'param_name'  => 'el_class',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),

        array(
          'type' => 'css_editor',
          'param_name' => 'css',
          'heading' => __( 'CSS box', 'legocreative' ),
          'group' => __( 'Design Options', 'legocreative' ),
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Scroller_Image extends WPBakeryShortCode {}
}
