<?php

if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Sharer class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */
class Vckit_Shortcode_Sharer extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_sharer';
  protected $name = 'Social Share';
  protected $desc = 'Share your link via facebook, twitter,..';
  protected $default_enabled = false;

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/social-share.png' ),
      'params'      => array(
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Style', 'legocreative' ),
          'param_name' => 'style',
          'value'      => array(
              __( 'Basic', 'legocreative' )   => 'basic',
              __( 'Style 1', 'legocreative' )   => 'style1',
              __( 'Style 2', 'legocreative' )   => 'style2',
              __( 'Style 3', 'legocreative' )   => 'style3',
              __( 'Style 4', 'legocreative' )   => 'style4',
              __( 'Style 5', 'legocreative' )   => 'style5',
              __( 'Style 6', 'legocreative' )   => 'style6',
              __( 'Style 7', 'legocreative' )   => 'style7',
              __( 'Style 8', 'legocreative' )   => 'style8',
              __( 'Style 9', 'legocreative' )   => 'style9',
              __( 'Style 10', 'legocreative' )   => 'style10',
              __( 'Style 11', 'legocreative' )   => 'style11',
              __( 'Style 12', 'legocreative' )   => 'style12',
              __( 'Style 13', 'legocreative' )   => 'style13',
              __( 'Style 14', 'legocreative' )   => 'style14',
              __( 'Style 15', 'legocreative' )   => 'style15',
              __( 'Style 16', 'legocreative' )   => 'style16',
          ),
          'std' => 'base',
          'description' => __( 'Select icon type. If you don\'t want to use icon, you can use your image', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Show Facebook link', 'legocreative' ),
          'param_name' => 'facebook',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'std' => 'yes',
          'description' => __( 'Share your current link on facebook.', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Show Twiter link', 'legocreative' ),
          'param_name' => 'twitter',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'std' => 'yes',
          'description' => __( 'Share your current link on twitter.', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Show Google plus link', 'legocreative' ),
          'param_name' => 'google',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'std' => 'yes',
          'description' => __( 'Share your current link on google plus.', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Show linkedIn link', 'legocreative' ),
          'param_name' => 'linkedin',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'std' => 'yes',
          'description' => __( 'Share your current link on linkedIn.', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Show pinterest link', 'legocreative' ),
          'param_name' => 'pinterest',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'std' => 'yes',
          'description' => __( 'Share your current link on pinterest.', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Open link in new window?', 'legocreative' ),
          'param_name' => 'open_new_window',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Open new window instead of current tab when share.', 'legocreative' ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Icon align', 'legocreative' ),
          'param_name' => 'align',
          'value'      => array(
              __( 'Left', 'legocreative' )   => 'left',
              __( 'Center', 'legocreative' )   => 'center',
              __( 'Right', 'legocreative' )   => 'right',
          ),
          'std' => 'left',
          'description' => __( 'Select alignment', 'legocreative' ),
        ),
        array(
          'type'             => 'colorpicker',
          'heading'          => __( 'Background color', 'legocreative' ),
          'param_name'       => 'background_color',
          'description'      => __( 'Choose the background of the link', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'             => 'colorpicker',
          'heading'          => __( 'Icon color', 'legocreative' ),
          'param_name'       => 'color',
          'description'      => __( 'Choose the color of the icon', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
      ),
    );
  }

  public function enqueueScripts() {
    vc_icon_element_fonts_enqueue( 'fontawesome' );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Sharer extends WPBakeryShortCode {}
}
