<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * Elegant Addons Shortcode Team Member class.
 *
 * @since 1.0
 * @package Elegant Addons for VC
 */

class Vckit_Shortcode_Team_Member extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_team_member';
  protected $name = 'Team member';
  protected $desc = 'Create a member info block';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/team-member.png' ),
      'params'      => array(

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Style', 'legocreative' ),
          'param_name'  => 'member_style',
          'description' => __( 'Choose one layout to display member block', 'legocreative' ),
          'std'         => 'layout01',
          'value'       => array(
            __( 'Simple', 'legocreative' )    => 'layout01',
            __( 'Avatar overlay', 'legocreative' ) => 'layout02',
          ),
          'save_always' => true,
        ),

        array(
          'type'        => 'attach_image',
          'heading'     => __( 'Member avatar', 'legocreative' ),
          'param_name'  => 'member_ava',
          'description' => __( 'Choose an avatar for member. Should choose the same size for all members\' avatars.', 'legocreative' ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Member name', 'legocreative' ),
          'param_name'  => 'member_name',
          'value'       => 'Sample Text',
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Member role', 'legocreative' ),
          'param_name'  => 'member_role',
          'value'       => 'Sample Text',
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Member personal site URL', 'legocreative' ),
          'param_name'  => 'member_url',
          'description' => __( 'Optional. Enter personal site URL of member.', 'legocreative' ),
        ),

        array(
          'type'        => 'param_group',
          'heading'     => __( 'Social link', 'legocreative' ),
          'param_name'  => 'member_social',
          'description' => __( 'Show member\'s social link', 'legocreative' ),
          'value'       => urlencode( json_encode( array() ) ),
          'params'      => array(
            array(
              'type'        => 'dropdown',
              'heading'     => __( 'Social network', 'legocreative' ),
              'param_name'  => 'network',
              'edit_field_class'  => 'vc_col-sm-6',
              'std'         => 'none',
              'value'       => array(
                __( 'None', 'legocreative' )      => 'none',
                __( 'Facebook', 'legocreative' )    => 'facebook',
                __( 'Twitter', 'legocreative' )     => 'twitter',
                __( 'Google plus', 'legocreative' ) => 'google-plus',
                __( 'Instagram', 'legocreative' )   => 'instagram',
                __( 'Linkedin', 'legocreative' )    => 'linkedin',
                __( 'Pinterest', 'legocreative' )   => 'pinterest-p',
                __( 'Tumblr', 'legocreative' )      => 'tumblr',
                __( 'Youtube', 'legocreative' )     => 'youtube',
              ),
              'save_always' => true,
            ),

            array(
              'type'        => 'textfield',
              'heading'     => __( 'URL', 'legocreative' ),
              'param_name'  => 'url',
              'edit_field_class'  => 'vc_col-sm-6 vckit-social-url',
              'dependency'  => array(
                'element'             => 'network',
                'value_not_equal_to'  => 'none',
              ),
            ),
          ),
        ),

      ),
    );
  }

  public function enqueueScripts() {
    vc_icon_element_fonts_enqueue( 'fontawesome' );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Team_Member extends WPBakeryShortCode {}
}
