<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Workflow Item class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Workflow_Item extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_workflow_item';
  protected $name = 'Workflow Item';
  protected $desc = '';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/workflow.png' ),
      'as_child'        => array(
        'only' => 'vckit_workflow',
      ),
      'show_settings_on_create' => true,
      'params'          => array(
        array(
          'type'    => 'textfield',
          'heading'   => esc_html__( 'Title', 'legocreative' ),
          'param_name'  => 'title',
          'admin_label' => true,
          'description' => esc_html__( 'Enter workflow item title.', 'legocreative' ),
        ),
        array(
          'type'      => 'dropdown',
          'heading'   => esc_html__( 'Title Tag', 'legocreative' ),
          'param_name'  => 'title_tag',
          'value' => array(
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
          ),
          'std'   => 'h3',
          'group' => esc_html__( 'Design Group','legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => esc_html__( 'Subtitle', 'legocreative' ),
          'param_name'  => 'subtitle',
          'admin_label' => true,
          'description' => esc_html__( 'Enter workflow item subtitle.', 'legocreative' ),
        ),
        array(
          'type'      => 'dropdown',
          'heading'   => esc_html__( 'Subtitle Tag', 'legocreative' ),
          'param_name'  => 'subtitle_tag',
          'value' => array(
            'h2' => 'h2',
            'h3' => 'h3',
            'h4' => 'h4',
            'h5' => 'h5',
            'h6' => 'h6',
          ),
          'std'   => 'h5',
          'group' => esc_html__( 'Design Group','legocreative' ),
        ),
        array(
          'type'        => 'textarea_html',
          'heading'     => esc_html__( 'Content', 'legocreative' ),
          'param_name'  => 'content',
        ),
        array(
          'type'        => 'attach_image',
          'heading'     => esc_html__( 'Image', 'legocreative' ),
          'param_name'  => 'image',
          'description' => esc_html__( 'Insert workflow item image.', 'legocreative' ),
        ),
        array(
          'type'    => 'checkbox',
          'heading'   => esc_html__( 'Set image on right side', 'legocreative' ),
          'param_name'  => 'image_float',
          'value'     => array(
            'Make Image Float Right?' => 'yes',
          ),
        ),
        array(
          'type'    => 'dropdown',
          'heading'   => esc_html__( 'Image alignment', 'legocreative' ),
          'param_name'  => 'image_alignment',
          'admin_label' => true,
          'value'     => array(
            esc_html__( 'Center', 'legocreative' ) => 'center',
            esc_html__( 'Left', 'legocreative' )   => 'left',
            esc_html__( 'Right', 'legocreative' )  => 'right',
          ),
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Workflow_Item extends WPBakeryShortCode {}
}
