<?php

/**
 * Create submenu pages.
 *
 * @link       themelego.com
 * @since      1.0.0
 *
 * @package    Vckit
 * @subpackage Vckit/includes
 */

/**
 * Create submenu pages.
 *
 * Provides the functionality necessary for rendering the page corresponding
 * to the submenu with which this page is associated.
 *
 * @package    Vckit
 * @subpackage Vckit/includes
 * @author     ThemeLego <contact@themelego.com>
 */
class Vckit_Submenu_Pages {

  /**
   * This function renders the contents of the edit page associated with the Submenu
   * that invokes the render method. In the context of this plugin, this is the
   * Submenu class.
   */
  public function vckit_general() {
    $active_tab = 'vckit';
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/header.php' );
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/general.php' );
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/footer.php' );
  }

  /**
   * This function renders the contents of the create page associated with the Submenu
   * that invokes the render method. In the context of this plugin, this is the
   * Submenu class.
   */
  public function vckit_module() {
    $active_tab = 'vckit-module';
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/header.php' );
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/module.php' );
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/footer.php' );
  }

  public function vckit_smooth_scroll() {
    $active_tab = 'vckit-smoothscroll';
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/header.php' );
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/smooth-scroll.php' );
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/footer.php' );
  }

  public function vckit_about() {
    $active_tab = 'vckit-about';
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/header.php' );
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/about.php' );
    require_once( VCKIT_PLUGIN_DIR . '/includes/settings/footer.php' );
  }
}
