<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

define( 'VCKIT_VIDEO_TUTORIAL', 'https://www.youtube.com/watch?v=A11rn_p94QQ&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F&index=3' );
define( 'VCKIT_VIDEO_INTERACTIVE_HOVER', 'https://www.youtube.com/watch?v=byGeJUINP7w&index=1&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F' );
define( 'VCKIT_VIDEO_GRID_SAMSUNG', 'https://www.youtube.com/watch?v=PwWxT607gSs&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F&index=5' );
define( 'VCKIT_VIDEO_GRID_MAGAZINE', 'https://www.youtube.com/watch?v=AP8DCu-dNZ0&index=6&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F' );
define( 'VCKIT_VIDEO_GRID_INTERACTIVE', 'https://www.youtube.com/watch?v=I3aIkDNLCTw&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F&index=7' );
define( 'VCKIT_VIDEO_GRID_GOOGLE', 'https://www.youtube.com/watch?v=-MM3WETJT6I&index=8&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F' );
define( 'VCKIT_VIDEO_GRID_ANIMATE', 'https://www.youtube.com/watch?v=aJ3xWg3nHFg&index=9&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F' );
define( 'VCKIT_VIDEO_CAROUSEL', 'https://www.youtube.com/watch?v=iCPGFbD9OM8&index=10&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F' );
define( 'VCKIT_VIDEO_TESTIMONIAL', 'https://www.youtube.com/watch?v=1Lza5VdX6C8&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F&index=11' );
define( 'VCKIT_VIDEO_LIGHTBOX', 'https://www.youtube.com/watch?v=Ny4ZkRmB2ac&index=15&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F' );
define( 'VCKIT_VIDEO_MAILCHIMP', 'https://www.youtube.com/watch?v=sC763C2xEgg&index=13&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F' );
define( 'VCKIT_VIDEO_PRICING_BOX', 'https://www.youtube.com/watch?v=yDuO1SiCSOQ&list=PLqO8BVTBpMDlrzQP4r6pOE7bu0vGhMZ9F&index=14' );

if ( ! function_exists( 'vckit_get_video_tutorial' ) ) {
  function vckit_get_video_tutorial( $shortcode ) {
    switch ( $shortcode ) {
      case 'vckit_interactive':
        return VCKIT_VIDEO_INTERACTIVE_HOVER;
      case 'vckit_grid_samsung':
        return VCKIT_VIDEO_GRID_SAMSUNG;
      case 'vckit_grid_magazine':
        return VCKIT_VIDEO_GRID_MAGAZINE;
      case 'vckit_grid_interactive':
        return VCKIT_VIDEO_GRID_INTERACTIVE;
      case 'vckit_grid_google':
        return VCKIT_VIDEO_GRID_GOOGLE;
      case 'vckit_grid_animate':
        return VCKIT_VIDEO_GRID_ANIMATE;
      case 'vckit_carousel':
        return VCKIT_VIDEO_CAROUSEL;
      case 'vckit_testimonial':
        return VCKIT_VIDEO_TESTIMONIAL;
      case 'vckit_lightbox':
        return VCKIT_VIDEO_LIGHTBOX;
      case 'vckit_mailchimp':
        return VCKIT_VIDEO_MAILCHIMP;
      case 'vckit_pricing_box':
        return VCKIT_VIDEO_PRICING_BOX;
    }

    return VCKIT_VIDEO_TUTORIAL;
  }
}

if ( ! function_exists( 'vckit_shortcodes_template' ) ) {
  /**
   * Get shortcode template path in plugin.
   *
   * @param string $name - path name
   * @param string $file
   *
   * @since  1.0
   * @return string
   */
  function vckit_shortcodes_template( $file = '' ) {
    return vc_addons_kit()->path( 'shortcodes', $file );
  }
}

if ( ! function_exists( 'vckit_shortcodes_theme_templates' ) ) {
  /**
   * Get custom theme template path
   * @since 1.0
   *
   * @param $template - filename for template
   *
   * @return string
   */
  function vckit_shortcodes_theme_templates( $template ) {
    return vc_addons_kit()->getShortcodesTemplateDir( $template );
  }
}

if ( ! function_exists( 'vc_addons_kit_set_shortcodes_templates_dir' ) ) {
  /**
   * Sets directory where Visual Composer KIT should look for template files for content elements.
   * @since 1.0
   *
   * @param string - full directory path to new template directory with trailing slash
   */
  function vc_addons_kit_set_shortcodes_templates_dir( $dir ) {
    vc_addons_kit()->setCustomUserShortcodesTemplateDir( $dir );
  }
}
