<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
/**
 * Shortcode attributes
 *
 * @var $atts
 * @var $el_class
 * Shortcode class
 * @var $this Vckit_Shortcode_Checklist
 */
$add_icon =
$list_item =
$font_color =
$font_size =
$line_height =
$icon_color =
$icon_size =
$checklist = '';

extract( $atts );

$matches = array();
$pattern = '/\d+|[a-z]+/';
preg_match_all( $pattern, $font_size, $matches );
$checklist = (array) vc_param_group_parse_atts( $checklist );

$styles = array(
  'font-size:' . $font_size,
  'color:' . $font_color,
  'margin-bottom:' . $line_height,
);

if ( isset( $matches[0] ) && isset( $matches[0][0] ) ) {
  $styles[] = 'padding-left:' . $matches[0][0] * 1.5 . 'px';
}
?>
<ul class="vckit-checklist-list">
  <?php foreach ( $checklist as $list_item ) { ?>
    <li style="<?php echo implode( ';', $styles ) //@codingStandardsIgnoreLine ?>">
      <?php if ( 'yes' === $add_icon ) {
        $atts['icon_type'] = 'fontawesome';
        $iconClass = $this->getIconClass( $atts );
        $icon_styles = array(
          'color: ' . $icon_color,
          'font-size: ' . $icon_size,
        );
      ?>
      <i class="<?php echo esc_attr( $iconClass ) ?> "
        style="<?php echo implode( ';', $icon_styles ) //@codingStandardsIgnoreLine ?>">
      </i>
      <?php } ?>
      <?php if ( isset( $list_item['content'] ) ) { ?>
        <span><?php echo esc_html( $list_item['content'] )  ?> </span>
      <?php } ?>
    </li>
  <?php } // End foreach(). ?>
</ul>
