<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts ); // @codingStandardsIgnoreLine
$el_class = $this->getExtraClass( $el_class );
?>

<div
  class="vckit-counter"
  data-counter-decimals="<?php echo esc_attr( $atts['decimals'] ); ?>"
  data-counter-duration="<?php echo esc_attr( $atts['duration'] ); ?>"
  data-counter-from="<?php echo esc_attr( $atts['startnumber'] ); ?>"
  data-counter-to="<?php echo esc_attr( $atts['endnumber'] ); ?>"
  data-counter-dese="<?php echo esc_attr( $atts['decimal-separator'] ); ?>"
  data-counter-dise="<?php echo esc_attr( $atts['digit-separator'] ); ?>">
  <div
    class="vckit-counter-icon"
    style="color: <?php echo esc_attr( $atts['color-icon'] ); ?>">
    <?php
    if ( 'yes' === $atts['addicon'] ) {
        $atts['icon_type'] = 'fontawesome';
        $iconClass = $this->getIconClass( $atts );
    ?>
    <i class="<?php echo esc_attr( $iconClass ) ?>" style="font-size: <?php echo esc_attr( $atts['size-icon'] ); ?>px;"></i>
    <?php } ?>
  </div>
  <div
    class="vckit-counter-value"
    style="color: <?php echo esc_attr( $atts['color-value'] ); ?>; font-size: <?php echo esc_attr( $atts['size-value'] ); ?>px">
    <span style="font-size: <?php echo esc_attr( $atts['size-value'] ); ?>"><?php echo esc_attr( $atts['prefix'] ); ?></span>
    <strong class="count-number" data-countup-selector="" id="vckit-countup-<?php echo esc_attr( rand() ) ?>">999</strong>
    <span style="font-size: <?php echo esc_attr( $atts['size-value'] ); ?>"><?php echo esc_attr( $atts['suffix'] ); ?></span>
  </div>
  <div
    class="vckit-counter-caption"
    style="color: <?php echo esc_attr( $atts['color-caption'] ); ?>; font-size: <?php echo esc_attr( $atts['size-caption'] ); ?>px">
    <?php echo esc_html( $atts['caption'] ); ?>
  </div>
</div>
