<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$unique_id = 'vckitDropcap-' . base_convert( microtime( false ), 10, 36 );

$dc_class = 'vckit-dropcap ';
$dc_class .= "dcap-{$dc_shape} dcap-{$dc_size} ";

// Even border-image need border-width and border-style.
// @see http://caniuse.com/#feat=border-image
if ( 'yes' === $dc_border_enable ) {
    $dc_class .= "border-{$dc_border_width} border-{$dc_border_style} ";
}

if ( $dc_bg_img ) {
    $bg_url = $this->getImageSrc( $dc_bg_img );
}
?>
<div class="vckit-dropcap-wrapper">
  <span
    class="<?php echo esc_attr( $dc_class ); ?>"
    id="<?php echo $unique_id; // @codingStandardsIgnoreLine ?>"
    <?php if ( isset( $bg_url ) ) : ?>
    style="background-image:url(<?php echo esc_url( $bg_url ); ?>)"
    <?php endif; ?>
  >
    <?php echo $drop_cap; // @codingStandardsIgnoreLine ?>
  </span>
  <p><?php echo $rest_content; //@codingStandardsIgnoreLine ?></p>
</div>
<style>
<?php
  $tmp = '';

if ( '' !== $dc_color ) {
    $tmp .= sprintf(
        '#%s { color: %s; }', $unique_id, $dc_color
    );
}

if ( 'color' === $dc_bg_type && 'simple' === $dc_bg_color_type && '' !== $dc_bg_color ) {
    $tmp .= sprintf(
        '#%s { background-color: %s; }', $unique_id, $dc_bg_color
    );
}

if ( 'color' === $dc_bg_type && 'gradient' === $dc_bg_color_type ) {
    if ( '' !== $dc_gradient_start && '' !== $dc_gradient_end ) {
        $tmp .= sprintf(
            '#%s { %s }', $unique_id, $this->generateGradient( $dc_gradient_start, $dc_gradient_end, $dc_gradient_dir )
        );
    }
}

if ( $dc_border_type && 'normal' === $dc_border_type && '' !== $dc_border_color ) {
    $tmp .= sprintf(
        '#%s { border-color: %s; }', $unique_id, $dc_border_color
    );

    if ( 'custom' === $custom_border ) {
        if ( '' !== $avail_edges ) {
            $edges = array( 'top', 'right', 'bottom', 'left' );
            $tmp .= ".vckit-dropcap-wrapper #{$unique_id} {";
            for ( $i = 0; $i < 4; $i++ ) {
                if ( false === strpos( $avail_edges, $edges[ $i ] ) ) {
                    $tmp .= "border-{$edges[$i]}-width: 0;";
                }
            }
            $tmp .= '}';
        }
    }
}

if ( $dc_border_type && 'gradient' === $dc_border_type ) {
    if ( '' !== $dc_border_gradient_start && '' !== $dc_border_gradient_end ) {
        $tmp .= sprintf(
            '#%s { %s }', $unique_id, $this->generateBorderGradient( $dc_border_gradient_start, $dc_border_gradient_end, $dc_border_gradient_dir )
        );
    }

    if ( 'custom' === $custom_border ) {
        if ( '' !== $avail_edges ) {
            $tmp .= sprintf(
                '#%s { border-image-slice: %s %s %s %s; }', $unique_id, ( false === strpos( $avail_edges, 'top' ) ) ? 0 : 1, ( false === strpos( $avail_edges, 'right' ) ) ? 0 : 1, ( false === strpos( $avail_edges, 'bottom' ) ) ? 0 : 1, ( false === strpos( $avail_edges, 'left' ) ) ? 0 : 1
            );
        }
    }
}

  echo $tmp; // @codingStandardsIgnoreLine
?>
</style>
