<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @package Visual Composer KIT
 *
 * @var $atts
 * @var $effect
 * @var $post_type
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Grid_Magazine
 */

$style =
$element_width =
$gap =
$grid_id =
$el_class =
$css = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$css_classes = array(
  //'vckit-grid',
  'vckit-grid-magazine',
  'vckit-grid-gutter-' . $gap,
);

$wrap_classes = array(
  'vckit-grid-magazine-wrap',
  $el_class,
  'vckit-magazine-' . $style,
  vc_shortcode_custom_css_class( $css ),
);

$this->addExcludedId( $this->postID() );
if ( 'custom' === $atts['post_type'] && ! empty( $atts['custom_query'] ) ) {
    $query = html_entity_decode( vc_value_from_safe( $atts['custom_query'] ), ENT_QUOTES, 'utf-8' );
    $post_data = query_posts( $query );
} else {
    $settings = $this->filterQuerySettings( $this->buildQuery( $atts ) );
    $post_data = query_posts( $settings );
}
?>
<?php if ( $post_data ) { ?>
  <div class="<?php echo esc_attr( implode( ' ', $wrap_classes ) ); ?>">
    <div class="<?php echo esc_attr( implode( ' ', $css_classes ) ); ?>" id="<?php echo esc_attr( $grid_id ) ?>">
        <?php foreach ( $post_data as $item ) { ?>
        <div class="vckit-grid-item">
          <h2 class="magazine-title magazine-title--preview"> <?php echo get_the_title( $item->ID ); ?> </h2>
          <div class="magazine-loader"></div>
          <ul class="magazine-category">
            <?php
            foreach ( get_the_category( $item->ID ) as $category ) {
              echo '<li>' . esc_html( $category->name ) . '</li>';
            } ?>
          </ul>
          <div class="magazine-meta meta--preview">
            <?php if ( $item->post_author ) { ?>
            <img class="meta__avatar" src="<?php echo esc_url( get_avatar_url( $item->post_author ) ); ?>" alt="author01" alt="<?php echo the_author_meta( 'display_name', $item->post_author ); ?>" />
            <?php } ?>
            <span class="meta__date"><i class="fa fa-calendar-o"></i> <?php echo get_the_date( null, $item->ID ) ?></span>
            <span class="meta__reading-time"><i class="fa fa-clock-o"></i> <?php echo esc_html( vckit_estimate_read_time( $item->post_content ) ) ?></span>
          </div>
        </div>
        <?php } ?>
    </div>

    <div class="vckit-magazine-content">
      <div class="scroll-wrap">
        <?php foreach ( $post_data as $item ) { ?>
          <article class="content__item">
            <div class="magazine-category magazine-category--full">
                <?php echo esc_attr( get_the_category_list( null, null, $item->ID ) ); ?>
            </div>
            <h2 class="magazine-title magazine-title--full"> <?php echo get_the_title( $item->ID ); ?> </h2>
            <div class="magaine-meta meta--full">
                <?php if ( $item->post_author ) { ?>
                <img class="meta__avatar" src="<?php echo esc_url( get_avatar_url( $item->post_author ) ); ?>" alt="author01" alt="<?php echo the_author_meta( 'display_name', $item->post_author ); ?>" />
                <span class="meta__author"><?php the_author_meta( 'user_nicename', $item->post_author ); ?> </span>
                <?php } ?>
              <span class="meta__date"><i class="fa fa-calendar-o"></i> <?php echo get_the_date( null, $item->ID ) ?></span>
              <span class="meta__reading-time"><i class="fa fa-clock-o"></i> <?php echo esc_html( vckit_estimate_read_time( $item->post_content ) ) ?></span>
            </div>
            <div class="vckit-page-content">
              <?php echo $item->post_content; //@codingStandardsIgnoreLine ?>
            </div>
          </article>
        <?php } ?>
      </div>
      <button class="vckit-magazine-close-button"><i class="fa fa-close"></i><span>Close</span></button>
    </div>
  </div>
<?php } // End if(). ?>
