<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @package Visual Composer KIT
 *
 * @var $atts
 * @var $effect
 * @var $post_type
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Grid_Samsung
 */

$effect =
$element_width =
$gap =
$grid_id =
$el_class =
$css = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$css_classes = array(
  'vckit-grid',
  'vckit-grid-samsung',
  $effect,
  'vckit-grid-gutter-' . $gap,
);

$wrap_classes = array(
  'vckit-grid-wrap',
  $el_class,
  vc_shortcode_custom_css_class( $css ),
);

$this->addExcludedId( $this->postID() );
if ( 'custom' === $atts['post_type'] && ! empty( $atts['custom_query'] ) ) {
    $query = html_entity_decode( vc_value_from_safe( $atts['custom_query'] ), ENT_QUOTES, 'utf-8' );
    $post_data = query_posts( $query );
} else {
    $settings = $this->filterQuerySettings( $this->buildQuery( $atts ) );
    $post_data = query_posts( $settings );
}
?>
<?php if ( $post_data ) { ?>
  <div class="<?php echo esc_attr( implode( ' ', $wrap_classes ) ); ?>">
    <div class="<?php echo esc_attr( implode( ' ', $css_classes ) ); ?>" id="<?php echo esc_attr( $grid_id ) ?>">
        <?php foreach ( $post_data as $item ) { ?>
        <div class="vckit-grid-item vc_col-xs-12 <?php echo $element_width < 12 ? 'vc_col-sm-6' : 'vc_col-sm-12' ?> vc_col-md-<?php echo esc_attr( $element_width ) ?>">
          <div class="vckit-grid-item-wrap">
            <a href="<?php echo esc_url( get_permalink( $item->ID ) ); ?>">
                <?php
                if ( has_post_thumbnail( $item->ID ) ) {
                  echo get_the_post_thumbnail( $item->ID, 'full', array(
                    'class' => '',
                  ) );
                } else {
                  echo '<img src="' . vc_addons_kit_assets( 'img/dummy.png' ) . '" alt="dummy">'; // @codingStandardsIgnoreLine
                }
                ?>
              <h3> <?php echo get_the_title( $item->ID ); ?> </h3>
            </a>
          </div>
        </div>
        <?php } ?>
    </div>
  </div>
<?php } ?>
