<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}
/**
 * Shortcode attributes
 *
 * @package Visual Compoer KIT
 */

$eib_custom_class =
$layout =
$icon_align =
$icon_type =
$icon_top_align =
$icon_box_type =
$image =
$image_width =
$image_height =
$title =
$enable_link =
$link =
$enable_readmore =
$readmore_text =
$css_animation =
$el_class =
$enable_hover_icon_only =
$icon_boxed_radius =
$icon_effect =
$icon_size  =
$icon_text_color =
$icon_hover_text_color =
$icon_color =
$icon_hover_color =
$title_font_size =
$title_color =
$description_color =
$readmore_color =
$a_title =
$a_href =
$title_attr =
$css =
$svg = '';

$svg_duration = '200';
$svg_timing = 'LINEAR';

$atts   = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts ); // @codingStandardsIgnoreLine

$hover_scope_class = 'eib-hover-global';
if ( 'yes' == $enable_hover_icon_only ) {
    $hover_scope_class = 'eib-hover-icon';
}

$css_classes = array(
  'vckit-icon-box',
  'elegant-icon-box',
  $icon_effect,
  'eib-layout-' . $layout,
  'eib-align-' . $icon_align,
  'eib-top-align-' . $icon_top_align,
  'eib-icon-' . $icon_boxed_radius,
  'eib-size-' . $icon_size,
  'eib-type-' . $icon_box_type,
  $hover_scope_class,
  vc_shortcode_custom_css_class( $css, ' ' ),
  $this->getCSSAnimation( $css_animation ),
  $eib_custom_class,
  $el_class,
);

$icon_pre_tag = '';
$before_icon = '<span class="eib-before-icon"></span>';
$after_icon = '<span class="eib-after-icon"></span>';

// Icon for output
$icon_output = '<div class="eib-fonts-icon">' . $before_icon;
$iconClass = $this->getIconClass( $atts );

if ( 'image' == $icon_box_type ) {
  $icon_output .= '<div class="eib-img"><img src="' .
  $this->getImageSrc( $image ) . '" style="width:' . $image_width .
  'px; height:' . $image_height . 'px;" alt="' . $title .
  '" /></div>';
} else if ( 'svg' == $icon_box_type ) {
  $svg_src = $this->getImageSrc( $svg );
  if ( isset( $svg_src ) ) {
    $svg_id = 'eib-svg-' . rand();
    $icon_output .= '<div class="eib-img" id="' . $svg_id
    . '" data-duration="' . $svg_duration . '" data-src="' . $svg_src
    . '" data-timing="' . $svg_timing . '"></div>';
  }
} elseif ( 'pixelicons' == $icon_type ) {
  $icon_output .= '<div class="eib-img"><i class="' . esc_attr( $iconClass ) . '"></i></div>';
} else {
  $icon_output .= '<i class="' . esc_attr( $iconClass ) . '"></i>';
}

$icon_output .= $after_icon . '</div>';
// End Icon for output

//parse link
  $link = ( '||' === $link ) ? '' : $link;
  $link = vc_build_link( $link );
  $use_link = false;
if ( strlen( $link['url'] ) > 0 ) {
  $use_link = true;
  $a_href = $link['url'];
  $a_title = $link['title'];
  $a_target = $link['target'];
  $a_rel = $link['rel'];
}

  $attributes = array();
  $attributes[] = 'href="' . trim( $a_href ) . '"';
  $attributes[] = 'title="' . esc_attr( trim( $a_title ) ) . '"';
if ( ! empty( $a_target ) ) {
  $attributes[] = 'target="' . esc_attr( trim( $a_target ) ) . '"';
}
if ( ! empty( $a_rel ) ) {
  $attributes[] = 'rel="' . esc_attr( trim( $a_rel ) ) . '"';
}
  $link_attributes = implode( ' ', $attributes );

  // Title attr
if ( '' != $title_font_size ) {
  $title_attr = 'style="font-size: ' . $title_font_size . '"';
}
?>

<div class="<?php echo esc_attr( implode( ' ', $css_classes ) ) ?>" >
  <div class="eib-wrapper">
    <?php if ( 'yes' == $enable_link ) { ?>
      <div class="eib-icon">
        <a <?php echo $link_attributes //@codingStandardsIgnoreLine ?>>
          <?php echo $icon_output //@codingStandardsIgnoreLine ?>
        </a>
      </div>
        <?php if ( '' != $title ) { ?>
        <h3 <?php echo $title_attr //@codingStandardsIgnoreLine ?>>
          <a <?php echo $link_attributes //@codingStandardsIgnoreLine ?>><?php echo esc_html( $title ) ?></a>
        </h3>
        <?php } ?>
    <?php } else { ?>
      <div class="eib-icon">
        <?php echo $icon_output //@codingStandardsIgnoreLine ?>
      </div>
        <?php if ( '' != $title ) { ?>
        <h3 <?php echo $title_attr //@codingStandardsIgnoreLine ?>><?php echo esc_html( $title ) ?></h3>
      <?php } ?>
    <?php } ?>

    <div class="eib-clearfix"></div>
    <div class="eib-description"><?php echo wpb_js_remove_wpautop( $content, true ); // @codingStandardsIgnoreLine ?></div>

    <?php if ( 'yes' == $enable_link && 'yes' == $enable_readmore ) { ?>
      <a class="eib-readmore" <?php echo $link_attributes //@codingStandardsIgnoreLine ?>> <?php echo esc_html( $readmore_text ) ?> </a>
    <?php } ?>
  </div>
    <?php if ( 'flag' == $layout ) { ?>
    <div class="eib-after-wrapper"><svg viewBox="0 0 1000 20" preserveAspectRatio="none" width="100%" height="20"><path d="M 0,-0.5 0,20 500,0 1000,20 1000,-0.5"></path></svg></div>
    <?php } ?>
</div>
