<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Shortcode class
 *
 * @var $this Vckit_Shortcode_Icon_Showcase
 */

$autoplay =
$autoplay_interval =
$primary_color =
$secondary_color =
$custom_class =
$el_class = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
  'vckit-icon-showcase',
  $custom_class,
  $el_class,
);

if ( 'yes' == $autoplay ) {
  $css_classes[] = 'vckit-icon-showcase-autoplay';
}
?>

<div
  class="<?php echo esc_attr( implode( $css_classes, ' ' ) ) ?>"
  <?php if ( $autoplay_interval ) { echo 'data-interval="' . esc_attr( $autoplay_interval ) . '"'; } ?>
  >
  <div class="vckit-icon-showcase-inner">
    <?php echo wpb_js_remove_wpautop( $content ); //@codingStandardsIgnoreLine ?>
  </div>
  <div class="vckit-icon-showcase-circle"> </div>
</div>
<style type="text/css"
  data-type="vckit-shortcode-css"
  data-shortcode="<?php echo esc_attr( $this->getShortCode() ); ?>">
  .<?php echo esc_attr( $custom_class ); ?> .vckit-icon-holder {
    color: <?php echo esc_attr( $primary_color ); ?>;
    background-color: <?php echo esc_attr( $secondary_color ); ?>;
  }
  .<?php echo esc_attr( $custom_class ); ?> .vckit-icon-showcase-circle:before {
    border-color: <?php echo esc_attr( $secondary_color ); ?>;
  }
  .<?php echo esc_attr( $custom_class ); ?> .vckit-icon-showcase-active .vckit-icon-holder,
  .<?php echo esc_attr( $custom_class ); ?> .vckit-icon-showcase:hover .vckit-icon-holder {
    color: <?php echo esc_attr( $secondary_color ); ?>;
    background-color: <?php echo esc_attr( $primary_color ); ?>;
  }
</style>
