<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

/**
 * Shortcode class
 *
 * @var $this Vckit_Shortcode_Icon_Showcase_Item
 */

$title_tag =
$title =
$link =
$text = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

//parse link
$link_attribute = '';

if ( ! empty( $link ) ) {
  $link = vc_build_link( $link );

  if ( ! empty( $link['url'] ) ) {
    $link_attribute = 'href="' . esc_attr( $link['url'] ) . '"'
      . ( $link['target'] ? ' target="' . esc_attr( $link['target'] ) . '"' : '' )
      . ( $link['rel'] ? ' rel="' . esc_attr( $link['rel'] ) . '"' : '' )
      . ( $link['title'] ? ' title="' . esc_attr( $link['title'] ) . '"' : '' );
  }
}

$icon_class = $this->getIconClass( $atts );

?>
<div class="vckit-icon-showcase-item">
  <div class="vckit-icon-showcase-icon">
    <span class="vckit-icon-holder">
      <i class="<?php echo esc_attr( $icon_class ); ?>"></i>
    </span>
  </div>
  <div class="vckit-icon-showcase-content">
    <div class="vckit-icon-showcase-content-table">
      <div class="vckit-icon-showcase-content-cell">
        <?php if ( '' !== $title ) { ?>
          <<?php echo esc_attr( $title_tag );?> class="vckit-icon-showcase-title">
            <?php if ( ! empty( $link ) & ! empty( $link_attribute ) ) {
              echo '<a ' . $link_attribute . '>' . $title . '</a>'; // @codingStandardsIgnoreLine
            } else {
              echo $title; // @codingStandardsIgnoreLine
            } ?>
          </<?php echo esc_attr( $title_tag );?>>
        <?php } ?>
        <?php if ( '' !== $text ) { ?>
          <div class="vckit-icon-showcase-content-inner">
            <?php echo esc_attr( $text ); ?>
          </div>
        <?php } ?>
      </div>
    </div>
  </div>
</div>
