<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$ava_url = $this->getImageSrc( $member_ava, 'medium' );

$member_social = json_decode( urldecode( $member_social ) );
?>
<div class="vckit-member <?php echo esc_attr( $member_style ); ?>">
    <?php if ( $ava_url ) : ?>
  <div class="vckit-member__ava">
    <?php if ( $member_url ) : ?>
    <a href="<?php echo esc_url( $member_url ); ?>">
      <img
        src="<?php echo esc_url( $ava_url ); ?>"
        alt="<?php echo esc_attr( $member_name ); ?>"
      >
    </a>
    <?php else : ?>
    <img
      src="<?php echo esc_url( $ava_url ); ?>"
      alt="<?php echo esc_attr( $member_name ); ?>"
    >
    <?php endif; ?>
  </div>
    <?php endif; ?>
  <div class="vckit-member__info">
    <h5>
        <?php if ( $member_url ) : ?>
      <a href="<?php echo esc_url( $member_url ); ?>" class="">
        <?php echo esc_attr( $member_name ); // @codingStandardsIgnoreLine ?>
      </a>
        <?php else : ?>
      <?php echo esc_attr( $member_name ); // @codingStandardsIgnoreLine ?>
      <?php endif; ?>
    </h5>
    <p><?php echo esc_attr( $member_role ); // @codingStandardsIgnoreLine ?></p>
  </div>
  <div class="vckit-member__social">
    <?php
      $length = count( $member_social );
    if ( $length ) {
      for ( $i = 0; $i < $length; $i++ ) {
        if ( 'none' !== $member_social[ $i ]->network ) {
          ?>
          <a
            class="vckit-member__social__link"
            href="<?php if ( isset( $member_social[ $i ]->url ) ) { echo esc_url( $member_social[ $i ]->url ); } ?>">
            <i class="fa fa-<?php echo $member_social[$i]->network; // @codingStandardsIgnoreLine ?>"></i>
          </a>&nbsp;
        <?php
        }
      }
    }
    ?>
  </div>
</div>
