<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Shortcode attributes
 *
 * @var $atts
 * @var $el_class
 *
 * Shortcode class
 * @var $this WPBakeryShortCode_Vckit_Testimonial
 */

$autoplay_speed = 5000;
$equalheight_enable = true;
$category = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

if ( ! $autoplay_speed ) {
  $autoplay_speed = 5000;
}

// Get extra class for multi maps.
$el_class = $this->getExtraClass( $el_class );

// Prepare template to display.
if ( $layout && '' !== $layout ) {
  include_once "testimonial-layout/{$layout}.php";
}

$div_class = "{$el_class} {$layout} {$ava_shape}";

if ( 'true' == $slider_enable ) {
  $div_class .= ' testimonials-has-slick';
}
?>
  <div <?php echo 'class="legocreative-testimonial ' . esc_attr( $div_class ) . '"'; ?>>
    <?php
      $args = array(
        'limit'           => $limit,
        'orderby'         => $orderby,
        'order'           => $order,
        'display_author'  => $display_author,
        'display_avatar'  => $display_avatar,
        'display_url'     => $display_url,
        'size'            => $ava_size,
        'before_title'    => '<h4 class="testi_title">',
        'after_title'     => '</h4>',
      );

      if ( ! empty( $category ) ) {
        $args['category'] = $category;
      }

      if ( 'true' != $slider_enable ) {
        if ( '' != $per_row ) {
          $args['per_row'] = $per_row;
        }
      }

      do_action( 'woothemes_testimonials', $args ); ?>
  </div>

  <style>
    <?php
      $tmp = '';

      $tmp .= sprintf( '.%s .slick-slide { height: auto; }', $layout );

    if ( '' !== $font_size ) {
      $tmp .= sprintf(
        '.%s .legocreative-testi-item .testi-text { font-size: %s; }', $layout, $font_size
      );
    }

    if ( '' !== $title_color ) {
      $tmp .= sprintf(
        '.%s span[itemprop="name"] { color: %s; }', $layout, $title_color
      );
    }

    if ( '' !== $byline_color ) {
      $tmp .= sprintf(
        '.%s span[itemprop="jobTitle"] { color: %s; } .%s span[itemprop="jobTitle"]:before, .%s span[itemprop="jobTitle"]:after { background-color: %s; }', $layout, $byline_color, $layout, $layout, $byline_color
      );
    }

    if ( '' !== $content_color ) {
      $tmp .= sprintf(
        '.%s blockquote.testi-text { color: %s; }', $layout, $content_color
      );
    }

    if ( '' !== $url_color ) {
      $tmp .= sprintf(
        '.%s .url a[itemprop="url"] { color: %s; }', $layout, $url_color
      );
    }

    if ( '' !== $url_hover_color ) {
      $tmp .= sprintf(
        '.%s .url a[itemprop="url"]:hover, .%s .url a[itemprop="url"]:focus, .%s .url a[itemprop="url"]:active { color: %s; }', $layout, $layout, $layout, $url_hover_color
      );
    }

    if ( '' !== $arrow_color ) {
      $tmp .= sprintf(
        '.%s .vckit-slide-button { color: %s; }', $layout, $arrow_color
      );
    }

    if ( '' !== $arrow_bg_color && '' !== $arrow_border_color ) {
      $tmp .= sprintf(
        '.%s .vckit-slide-button[class*="square"] { background-color: %s; border-color: %s; }', $layout, $arrow_bg_color, $arrow_border_color
      );
    } elseif ( '' !== $arrow_bg_color ) {
      $tmp .= sprintf(
        '.%s .vckit-slide-button[class*="square"] { background-color: %s; }', $layout, $arrow_bg_color
      );
    } elseif ( '' !== $arrow_border_color ) {
      $tmp .= sprintf(
        '.%s .vckit-slide-button[class*="square"] { border-color: %s; }', $layout, $arrow_border_color
      );
    }

    if ( '' !== $arrow_bg_color ) {
      $tmp .= sprintf(
        '.%s button.vckit-slide-button[class*="square"]:hover { background-color: %s; }', $layout, $arrow_bg_color
      );
    }

    if ( '' !== $dot_bg_color && '' !== $dot_border_color ) {
      $tmp .= sprintf(
        '.%s .slick-dots li button { background-color: %s; border-color: %s; }', $layout, $dot_bg_color, $dot_border_color
      );
    } elseif ( '' === $dot_bg_color && '' !== $dot_border_color ) {
      $tmp .= sprintf(
        '.%s .slick-dots li button { background-color: %s; border-color: %s; }', $layout, 'transparent', $dot_border_color
      );
    } elseif ( '' !== $dot_bg_color ) {
      $tmp .= sprintf(
        '.%s .slick-dots li button { background-color: %s; }', $layout, $dot_bg_color
      );
    }

    if ( '' !== $active_dot_bg_color ) {
      $tmp .= sprintf(
        '.%s .slick-dots li.slick-active button { background-color: %s; }', $layout, $active_dot_bg_color
      );
    }

      $tmp .= sprintf( '.%s .legocreative-testi-item blockquote.testi-text:before {', $layout );
    if ( '' !== $icon_color ) {
      $tmp .= sprintf( 'color: %s;', $icon_color );
    }
    if ( '' !== $icon_bg_color ) {
      $tmp .= sprintf( 'background-color: %s;', $icon_bg_color );
    }
    if ( '' !== $icon_border_color ) {
      $tmp .= sprintf( 'border-color: %s;', $icon_border_color );
    }
      $tmp .= '}';

    if ( '' !== $quote_bg_color ) {
      $tmp .= sprintf(
        '.%s .legocreative-testi-item blockquote.testi-text { background-color: %s } .%s .legocreative-testi-item blockquote.testi-text:after { border-top-color: %s }', $layout, $quote_bg_color, $layout, $quote_bg_color
      );
    }

      echo $tmp; // @codingStandardsIgnoreLine
    ?>
  </style>

<?php
// @codingStandardsIgnoreStart

if ( 'true' == $slider_enable ) {
?>
  <script>
    jQuery( document ).ready(function($) {
      $('.wpb_row .<?php echo $layout; ?> .testimonials-list').slick({
      <?php if ( 'true' == $autoplay_enable ) { ?>
        autoplay: true,
        autoplaySpeed: <?php echo $autoplay_speed; ?>,
        pauseOnHover: false,
        adaptiveHeight: true,
      <?php } else { ?>
        autoplay: false,
      <?php } ?>
        infinite: true,
        speed: 500,
        slidesToShow: <?php echo $slides_to_show; ?>,
        slidesToScroll: <?php echo $slides_to_scroll; ?>,
      <?php if ( 'true' == $dots_enable ) { ?>
        dots: true,
      <?php } else { ?>
        dots: false,
      <?php } ?>
      <?php if ( 'true' == $arrows_enable ) { ?>
        arrows: true,
        prevArrow: '<button type="button" class="vckit-slide-button <?php echo $arrow_style; ?>-prev"><i class="fa fa-angle-left"></i></button>',
        nextArrow: '<button type="button" class="vckit-slide-button <?php echo $arrow_style; ?>-next"><i class="fa fa-angle-right"></i></button>',
      <?php } else { ?>
        arrows: false,
      <?php } ?>
      <?php if ( 1 === $slides_to_show * 1 ) { ?>
        fade: true,
      <?php } ?>

        cssEase: 'linear',
        responsive: [
          {
            breakpoint: 767,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1,
              dots: true
            }
          }
        ]
      });
    });
  </script>
<?php } ?>

<?php if ( 'true' == $equalheight_enable ) { ?>
  <script type="text/javascript">
    jQuery( document ).ready(function($) {
      function vckitTestimonialHeight() {
        var maxHeight = -1;
        $('.<?php echo $layout; ?> .testi-text').css('height', 'auto');
        $('.<?php echo $layout; ?> .testi-text').each(function() {
          maxHeight = maxHeight > $(this).outerHeight() ? maxHeight : $(this).outerHeight();
        });

        $('.<?php echo $layout; ?> .testi-text').each(function() {
          $(this).outerHeight(maxHeight);
        });
      }

      $(window).on('resize', vckitTestimonialHeight);
      vckitTestimonialHeight();
    });
  </script>
<?php } ?>
