<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns:html="http://www.w3.org/TR/REC-html40"
	xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
	xmlns:s="http://www.sitemaps.org/schemas/sitemap/0.9"
	xmlns:n="http://www.google.com/schemas/sitemap-news/0.9"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<title>XML News Sitemap</title>
				<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
				<style type="text/css">
					body {
						font-family: Helvetica, Arial, sans-serif;
						font-size: 13px;
						color: #545353;
					}
					table {
						border: none;
						border-collapse: collapse;
					}
					#sitemap tbody tr:nth-child( odd ) {
						background-color: #eee;
					}
					#sitemap tbody tr:hover {
						background-color: #ccc;
					}
					#sitemap tbody tr:hover td, #sitemap tbody tr:hover td a {
						color: #000;
					}
					#content {
						margin: 0 auto;
						width: 1000px;
					}
					p.expl {
						margin: 10px 3px;
						line-height: 1.3em;
					}
					.expl a, .expl a:visited {
						color: #da3114;
						font-weight: bold;
					}
					a {
						color: #000;
						text-decoration: none;
					}
					a:visited {
						color: #777;
					}
					a:hover {
						text-decoration: underline;
					}
					td {
						font-size:11px;
					}
					th {
						text-align:left;
						padding-right:30px;
						font-size:11px;
					}
					thead th {
						border-bottom: 1px solid #000;
					}
				</style>
			</head>
			<body>
				<div id="content">
					<h1>XML News Sitemap</h1>
					<p class="expl">
						Generated by <a href="http://yoast.com/">Yoast</a> <a href="https://yoast.com/wordpress/plugins/seo/">SEO</a> and its <a href="https://yoast.com/wordpress/plugins/news-seo/">Google News SEO module</a>, this is an XML News Sitemap, meant for consumption by Google News.
					</p>
					<p class="expl">
						<a href="https://support.google.com/news/publisher/answer/74288">Read more information about XML News sitemaps</a>.
					</p>
					<p class="expl">
						This sitemap contains <xsl:value-of select="count(s:urlset/s:url)"/> URLs.
					</p>
					<table id="sitemap" cellpadding="3">
						<thead>
							<tr>
								<th width="55%">Title</th>
								<th width="15%">Genre(s)</th>
								<th width="15%"># Images</th>
								<th width="15%">Publication Date</th>
							</tr>
						</thead>
						<tbody>
							<xsl:for-each select="s:urlset/s:url">
								<tr>
									<td>
										<xsl:variable name="itemURL">
											<xsl:value-of select="s:loc"/>
										</xsl:variable>
										<a href="{$itemURL}">
											<xsl:value-of select="n:news/n:title"/>
										</a>
									</td>
									<td>
										<xsl:value-of select="n:news/n:genres"/>
									</td>
									<td>
										<xsl:value-of select="count(image:image)"/>
									</td>
									<td>
										<xsl:value-of select="n:news/n:publication_date"/>
									</td>
								</tr>
							</xsl:for-each>
						</tbody>
					</table>
				</div>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>
