<?php
/*
Plugin Name: Cmap regions France
Plugin URI: https://comersis.com
Description: Carte regions France
Version: 5.1
Author: Stefan M.
Text Domain: fr_reg_wp
Author URI: https://comersis.com
License: GPL2
*/
// Runs when plugin is activated
register_activation_hook(__FILE__,'db_reg_install');
// Runs when plugin is desactivated
register_uninstall_hook( __FILE__, 'db_reg_delete' );
function db_reg_install() {
global $wpdb;
$table_reg = $wpdb->prefix.'frregsvg';
$table_map = $wpdb->prefix.'frregset';
if($wpdb->get_var("SHOW TABLES LIKE '$table_reg'") != $table_reg) {
$charset_collate = $wpdb->get_charset_collate();
$sql = "CREATE TABLE IF NOT EXISTS $table_reg (
  reg char(3) NOT NULL,
  nom varchar(100) NOT NULL,
  color varchar(7) NOT NULL DEFAULT '#F6F4EC',
  url varchar(255) NOT NULL DEFAULT '#',
  target varchar(9) NOT NULL DEFAULT '_self',
  path text NOT NULL
) $charset_collate;";

$sql2 = "CREATE TABLE IF NOT EXISTS $table_map (
  idp int(1) NOT NULL,
  mapfill varchar(7) NOT NULL,
  mapoff varchar(7) NOT NULL,
  maphover_fill varchar(7) NOT NULL,
  mapstroke varchar(7) NOT NULL,
  mapstroke_width varchar(5) NOT NULL,
  mapOriginWidth varchar(5) NOT NULL,
  mapOriginHeight varchar(5) NOT NULL,
  mapWidth varchar(5) NOT NULL,
  mapHeight varchar(5) NOT NULL,
  aff_dom varchar(5) NOT NULL DEFAULT 'true',
  aff_reg varchar(5) NOT NULL DEFAULT 'true'
) $charset_collate;";

require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
dbDelta( $sql );
dbDelta( $sql2 );
// requete
$wpdb->query("INSERT INTO $table_reg (`reg`, `nom`, `color`, `url`, `target`, `path`) VALUES
(122, 'Départements d''Outre-Mer', '#0099FF', '#', '_self', 'M70.3,478.5c2.4-4.6,3.5-9.1,3.5-13.4c-5.6-5.4-8.8-11.4-9.4-17.8c-11-6.5-22.2-6.8-33.4-0.9    c-0.2,4-1.5,6.6-3.8,7.8c3.1,6.3,4.1,11.2,2.7,14.5l13.7,9.8C52.9,483.4,61.7,483.4,70.3,478.5z M110.2,443.3c-5.2-2.1-9.4-3.3-12.3-3.4c-5.4-0.2-7,3-4.7,9.6c3.1,1.9,4.4,5.2,3.9,9.9    c0.2,0.3,0.5,0.6,0.8,0.9c4.4,4.4,10.2,7.4,17.3,9.1c-3.1,1.7-6.7,2.4-10.7,2.2c-0.2,3.4,0.7,6.3,2.8,8.6    c8.8-2.9,15.4-0.6,19.7,6.9c6.6-5.1,5.7-14.1-2.5-26.7c-7.9-1.9-7.5-5.2,0.9-10l-0.1-2.2l-8.8,3.3L110.2,443.3zM165.4,471.4    c9.1,8.9,9.5,3.3,1.2-16.7c-2.3,0.8-4.6,0.1-6.7-2.2c0-5,1.9-8.9,5.5-11.6c2.2,6.7,9.1,10.7,20.8,11.8c-6.3,7.6-7.4,12.8-3.3,15.6    c-4.6,4.6-6,9.4-4.1,14.6C166.5,484.8,162,481,165.4,471.4zM230,442.3    c4.7,2.7,2.8,6.4-6,11.2c-1.1-1.3-2.1-2.5-3-3.4c-7.4-7.8-11.5-6-12.3,5.1c2.8,4.3,3.5,8.7,2.3,13.2l5.6,9.3    c0.9,0.3,2.3-0.1,4.4-1.3c1.6-0.9,3.5-2.3,5.8-4.1c1-5.2,0.6-10.8-1.3-16.7l2.1-1.6c1.6,5.1,10.6,5.2,26.9,0.3    c-2.4-2.6-5.4-4.5-8.8-5.6c-4.3,0-6.9-2.8-7.7-8.5C234.2,431.8,231.5,432.5,230,442.3zM243.2,479.2l5-5.5    c2.9,0.8,5,2.6,6.3,5.3c-0.7,2.8-2.4,4.9-5.1,6.5C245.5,484.6,243.4,482.5,243.2,479.2zM301.1,438.3c-1.9-2.2-4.5-3.3-7.9-3.2c-9.8,10.4-9.9,20.5-0.4,30.3c-2.2,11.3-5.4,17-9.7,17.1l6.6,2.4    c3.1-2.3,9.3-2.7,18.6-1l5.4-2.3c1.9-8.1,6.4-15.9,13.5-23.7c0-0.1,0-0.2,0.1-0.3c1.3-4.8-0.4-7.2-5.2-7.2    C314,441.1,306.9,437.1,301.1,438.3z'),
(111, 'Île-de-France', '#0099FF', '#', '_self', 'M267.1,132.1c4.3-5.9,5-13,2.2-21.2l-51.4-19.3c-2.2,6.5-5.1,11.8-8.6,15.9c0.9,27.5,15.4,39.3,43.5,35.5   C259.3,139.9,264.1,136.3,267.1,132.1z'),
(106, 'Centre-Val de Loire', '#0099FF', '#', '_self', 'M188.9,117.8c2.1,9.2,1.3,17-2.5,23.4c-3,19-10.5,35.5-22.3,49.5c17.5,5,27.9,17,31.3,36.2   c12.8,0.8,24.6-0.8,35.4-4.9c9.2-3.4,17.7-8.6,25.4-15.6l-3.4-63.4c-28.1,3.8-42.6-8-43.5-35.5   C203.9,113.6,197.1,117.1,188.9,117.8z'),
(203, 'Normandie', '#0099FF', '#', '_self', 'M202.7,51.6c-7.6,18.3-17.6,29-30.2,32.1c-12.9,3.2-28.4-1.5-46.5-14.1l-20.3-2.3   c9.3,15.9,13.6,32.5,13.1,49.8c3.1,3.2,5.6,6.4,7.5,9.6l60.1,14.5c3.8-6.4,4.6-14.2,2.5-23.4c8.2-0.7,15-4.2,20.4-10.3   c3.5-4.1,6.4-9.4,8.6-15.9C221.4,77.5,216.3,64.2,202.7,51.6z'),
(204, 'Bourgogne-Franche-Comté', '#0099FF', '#', '_self', 'M345.4,153.7c-4.5,2.7-9.2,6.8-14.1,12.1c-27.6-5.5-49-16.7-64.2-33.7c-3,4.2-7.8,7.8-14.3,10.9l3.4,63.4   c11.5,8.8,21.9,15.2,31.2,19.2c18.2,7.8,32.2,6.1,42-4.8c3.1,8.2,11.8,8.1,26-0.4c9-26.3,19.1-42.5,30.5-48.7   c-3.5-6.7-7.2-11.8-11-15.5C366.1,147.8,356.2,146.9,345.4,153.7z'),
(206, 'Hauts-de-France', '#0099FF', '#', '_self', 'M289,54.9h-0.1c-19.8-13.1-36.4-28.7-49.8-46.8l-27,9.9c-1.7,9.2-3.8,17.5-6.2,24.8c-1.1,3.1-2.1,6-3.2,8.8   c13.6,12.6,18.7,25.9,15.2,40l51.4,19.3C287.2,95.5,293.8,76.9,289,54.9z'),
(200, 'Grand-Est', '#0099FF', '#', '_self', 'M395.9,96c-26.4-5.3-50.2-12.5-71.3-21.8c-12.9-5.7-24.7-12.1-35.6-19.3c4.8,22-1.8,40.6-19.7,56   c2.8,8.2,2.1,15.3-2.2,21.2c15.2,17,36.6,28.2,64.2,33.7c4.9-5.3,9.6-9.4,14.1-12.1c10.8-6.8,20.7-5.9,29.5,2.5   c3.8,3.7,7.5,8.8,11,15.5c3.5-2,7.1-2.9,10.9-2.9c-6.1-24-0.6-47.2,16.7-69.7C407.5,98.1,401.7,97.1,395.9,96z'),
(117, 'Pays-de-la-Loire', '#0099FF', '#', '_self', 'M164.1,190.7c11.8-14,19.3-30.5,22.3-49.5l-60.1-14.5c11.3,19.4-4.3,35.7-47,48.8   c20.4,16.6,33.4,32.7,38.9,48.4C137.5,215.1,152.8,204,164.1,190.7z'),
(105, 'Bretagne', '#0099FF', '#', '_self', 'M17.2,115.2l-2.5,8.5l14.6-1l-9.6,6.4l10,6.8l-12.5,1.9c4.5,6.9,10.4,9.6,17.8,7.9   c17.4,10.1,32.1,20,44.3,29.8c42.7-13.1,58.3-29.4,47-48.8c-1.9-3.2-4.4-6.4-7.5-9.6c-25.9,2.8-44.1-1.4-54.5-12.6   C45.9,105.3,30.2,108.9,17.2,115.2z'),
(201, 'Nouvelle-Aquitaine', '#0099FF', '#', '_self', 'M118.2,223.9c3.7,10.5,4.1,20.8,1.2,31l14.1,22.4l-12.9-11.6L96,363c11.7,11.5,26.3,20.9,43.8,28.1   c1.9-41.1,15.6-60.7,41-58.6c14.7-17.7,22.4-32.7,23.4-44.9c5,3.3,9.9,5.9,14.7,7.8c26.3-24.7,30.3-49.2,11.9-73.4   c-10.8,4.1-22.6,5.7-35.4,4.9c-3.4-19.2-13.8-31.2-31.3-36.2C152.8,204,137.5,215.1,118.2,223.9z'),
(202, 'Auvergne-Rhône-Alpes', '#0099FF', '#', '_self', 'M355.4,220.4c-14.2,8.5-22.9,8.6-26,0.4c-9.8,10.9-23.8,12.6-42,4.8c-9.3-4-19.7-10.4-31.2-19.2   c-7.7,7-16.2,12.2-25.4,15.6c18.4,24.2,14.4,48.7-11.9,73.4c11.1,4.4,22.7,7,35,7.7c9.8,0.6,20-0.1,30.6-2   c-0.1,9.3,8.4,16.5,25.7,21.7c8,2.3,17.8,4.3,29.5,5.8c2.4-28.3,14.3-44.2,35.6-47.8c21-47.4,12.9-62.9-24.3-46.2   C352.4,229.6,353.9,224.9,355.4,220.4z'),
(205, 'Occitanie', '#0099FF', '#', '_self', 'M218.9,295.4c-4.8-1.9-9.7-4.5-14.7-7.8c-1,12.2-8.7,27.2-23.4,44.9c-25.4-2.1-39.1,17.5-41,58.6   c20.5,8.3,44.8,13.7,73.1,16.2c15.6,1.3,32.4,1.7,50.3,1.3c-6.4-32.7,5.2-48.8,34.9-48.4c18.4-12.4,22.4-24.9,12.1-37.4   c-17.3-5.2-25.8-12.4-25.7-21.7c-10.6,1.9-20.8,2.6-30.6,2C241.6,302.4,230,299.8,218.9,295.4z'),
(120, 'Provence-Alpes-Côte d''Azur', '#0099FF', '#', '_self', 'M375.3,280.8c-21.3,3.6-33.2,19.5-35.6,47.8c-11.7-1.5-21.5-3.5-29.5-5.8c10.3,12.5,6.3,25-12.1,37.4   c16.3,0.3,38.1,5.5,65.3,15.7c23.4-6.8,40.3-23.4,50.7-49.8C391.7,326.9,378.7,311.9,375.3,280.8z'),
(108, 'Corse', '#0099FF', '#', '_self', 'M423.2,372.5c-3.1-5.9-4.4-11.3-3.7-16.2l-3.8,1.5l0.4,11.7c-7.4-2.7-14.8,1-22.2,10.9   c-3.9,9.6-2.5,16.9,4.1,21.8l6.4,23l12.8,7.2c6.8-13.1,10.1-26.1,9.8-39.2L423.2,372.5z')
");
// requete
$wpdb->query("INSERT INTO $table_map (`idp`, `mapfill`, `mapoff`, `maphover_fill`, `mapstroke`, `mapstroke_width`, `mapOriginWidth`, `mapOriginHeight`, `mapWidth`, `mapHeight`, `aff_dom`, `aff_reg`) VALUES
(1, '#4AE7FF', '#C2C2C2', '#FF4D29', '#FFFFFF', '1.2', '700', '725', '700', '725', 'false', 'true')");
}
}
function db_reg_delete() {
global $wpdb;
$table_reg = $wpdb->prefix.'frregsvg';
$table_map = $wpdb->prefix.'frregset';
$wpdb->query( "DROP TABLE IF EXISTS $table_reg" );
$wpdb->query( "DROP TABLE IF EXISTS $table_map" );
    delete_option("my_plugin_db_version");
}
$plugin_dir = basename(dirname(__FILE__));
load_plugin_textdomain('fr_reg_wp',null,$plugin_dir.'/lang/');
//Affichage carte
define( 'fr_reg_wp', plugin_dir_path( __FILE__ ) );
function cmap_frreg( $atts ){
require_once( fr_reg_wp . 'map.php' );
}
add_shortcode( 'frreg', 'cmap_frreg' );
add_action( 'admin_menu', 'my_reg_menu' );
function my_reg_menu() {
	add_options_page( 'My Map Options', 'Cmap regions France', 'manage_options', 'frreg', 'my_reg_admin' );
}
function my_reg_admin() {
	require_once( fr_reg_wp . 'admin.php' );
}
?>