<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}


/**
 * VC KIT Shortcode Sample class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Before_After_Image extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_before_after_image';
  protected $name = 'Before After Image';
  protected $desc = 'Before and after images animation';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/before-after-image.png' ),
      'params'      => array(

        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Orientation' ),
          'param_name' => 'orientation',
          'value'      => array(
            __( 'Horizontal', 'legocreative' )  => 'horizontal',
            __( 'Vertical', 'legocreative' )    => 'vertical',
            ),
          'std'        => 'horizontal',
          'description' => __( 'Select orientation of the Slider', 'legocreative' ),
        ),
        array(
          'type'       => 'attach_image',
          'heading'    => __( 'Before image', 'legocreative' ),
          'param_name' => 'beforeimage',
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'Select your image', 'legocreative' ),
        ),
        array(
          'type'       => 'attach_image',
          'heading'    => __( 'After image', 'legocreative' ),
          'param_name' => 'afterimage',
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'Select your image', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Before label', 'legocreative' ),
          'param_name'        => 'beforelabel',
          'edit_field_class'  => 'vc_col-sm-6',
          'description'       => __( 'Put Before label', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'After label', 'legocreative' ),
          'param_name'        => 'afterlabel',
          'edit_field_class'  => 'vc_col-sm-6',
          'description'       => __( 'Put After label', 'legocreative' ),
        ),
        array(
          'type'              => 'textfield',
          'heading'           => __( 'Line offset percent', 'legocreative' ),
          'param_name'        => 'offset',
          'value'             => '0.5',
          'description'       => __( 'Value in percent tag, for example: 0.5', 'legocreative' ),
        ),
        array(
          'type'         => 'textfield',
          'heading'      => __( 'Extra class name', 'legocreative' ),
          'param_name'   => 'el_class',
          'description'  => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
        ),
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Before_After_Image extends WPBakeryShortCode {}
}

