<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Carousel Itemclass.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Carousel_Item extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_carousel_item';
  protected $name = 'Carousel Item';
  protected $desc = 'Item in carousel';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/carousel.png' ),
      'content_element' => true,
      'as_child' => array(
        'only' => 'vckit_carousel',
      ),
      'is_container' => true,
      'custom_markup' => '',
      'js_view' => 'VcColumnView',
      'show_settings_on_create' => false,
      'params' => array(
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
      ),
    );
  }
}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
  class WPBakeryShortCode_Vckit_Carousel_Item extends WPBakeryShortCodesContainer {
  }
}
