<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Carousel class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Carousel extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_carousel';
  protected $name = 'Carousel';
  protected $desc = 'Enable content to carousel, slider';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/carousel.png' ),
      'as_parent' => array(
        'only' => 'vckit_carousel_item',
      ),
      'content_element' => true,
      'is_container' => true,
      'custom_markup' => '',
      'js_view' => 'VcColumnView',
      'params' => $this->addCarouselOptions( null, null, true ),
    );
  }

  public function enqueueScripts() {
    vc_icon_element_fonts_enqueue( 'fontawesome' );
  }
}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
  class WPBakeryShortCode_Vckit_Carousel extends WPBakeryShortCodesContainer {
  }
}
