<?php
if ( ! defined( 'ABSPATH' ) ) { exit; //Exit if accessed directly
}
/**
 * VC KIT Shortcode Checklist class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */
class Vckit_Shortcode_Checklist extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_checklist';
  protected $name = 'List';
  protected $desc = 'Create your own list';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/list.png' ),
      'params' => array(
        array(
          'type' => 'checkbox',
          'heading' => __( 'Add Icon', 'legocreative' ),
          'param_name' => 'add_icon',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
        ),
        array(
          'type' => 'iconpicker',
          'heading' => __( 'Icon', 'legocreative' ),
          'param_name' => 'icon_fontawesome',
          'value' => 'fa fa-image',
          'settings' => array(
            'emptyIcon' => false,
          ),
          'dependency' => array(
            'element' => 'add_icon',
            'value' => 'yes',
          ),
          'description' => __( 'Select icon from library', 'legocreative' ),
        ),
        array(
          'type' => 'colorpicker',
          'heading' => __( 'Icon Color', 'legocreative' ),
          'param_name' => 'icon_color',
          'dependency' => array(
            'element' => 'add_icon',
            'value' => 'yes',
          ),
          'description' => __( 'Select the color of the icon here', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Icon Size', 'legocreative' ),
          'param_name' => 'icon_size',
          'dependency' => array(
            'element' => 'add_icon',
            'value' => 'yes',
          ),
          'description' => __( 'Select the size of the icon here', 'legocreative' ),
          'value' => 'px',
        ),
        array(
        'type' => 'param_group',
        'heading' => __( 'List', 'legocreative' ),
        'description' => __( 'Customize your list here', 'legocreative' ),
        'param_name' => 'checklist',
        'value' => urlencode(json_encode(array(
          array(
            'feature' => __( 'Customize the icons', 'legocreative' ),
          ),
        ))),
        'params' => array(
          array(
            'type' => 'textfield',
            'heading' => __( 'Content of list', 'legocreative' ),
            'param_name' => 'content',
            'description' => __( 'Enter the content of the list', 'legocreative' ),
          ),
         ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Size of content of list', 'legocreative' ),
          'param_name' => 'font_size',
          'value' => 'px',
        ),
        array(
          'type' => 'colorpicker',
          'heading' => __( 'Color of content of list', 'legocreative' ),
          'param_name' => 'font_color',
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Space between each content in list', 'legocreative' ),
          'param_name' => 'line_height',
          'value' => '5px',
          'description' => __( 'E.g: 12px', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Extra class name', 'legocreative' ),
          'param_name' => 'el_class',
          'description' => __('Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative'),
        ),
      ),
    );
  }
}
 if ( class_exists( 'WPBakeryShortCode' ) ) {
    class WPBakeryShortCode_Vckit_Checklist extends WPBakeryShortCode {}
}
