<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}


/**
 * Elegant Addons Shortcode Sample class.
 *
 * @since 1.0
 * @package Elegant Addons for VC
 */

class Vckit_Shortcode_Circle_Counter extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_circle_counter';
  protected $name = 'Counter Circle';
  protected $desc = 'Beautiful counter element';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/counter-circle.png' ),
      'params'      => array(
        array(
          'type' => 'textfield',
          'heading' => __( 'Filled area percentage', 'legocreative' ),
          'param_name' => 'percent',
          'description' => __( 'enter a numerical value to set the percentage of filled area', 'legocreative' ),
          'value' => '50',
          ),
        array(
          'type' => 'colorpicker',
          'heading' => __( 'Bar color', 'legocreative' ),
          'param_name' => 'bar-color',
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'select color of filled area', 'legocreative' ),
          'value' => '#888888',
          ),
        array(
          'type' => 'colorpicker',
          'heading' => __( 'Track color', 'legocreative' ),
          'param_name' => 'track-color',
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'select color of unfilled area', 'legocreative' ),
          'value' => '#e7e7e7',
          ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Size of Circle', 'legocreative' ),
          'param_name' => 'size',
          'std' => '110',
          'description' => __( 'enter size of Circle Counter in px', 'legocreative' ),
          ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Size of percentage number', 'legocreative' ),
          'param_name' => 'size-per-num',
          'std' => '15',
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'enter size of percentage number inside Circle Counter in px', 'legocreative' ),
          ),
        array(
          'type' => 'colorpicker',
          'heading' => __( 'Color of percentage number', 'legocreative' ),
          'param_name' => 'color-per-num',
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'select color of percentage number', 'legocreative' ),
          ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Title', 'legocreative' ),
          'param_name' => 'title',
          'group' => __( 'Advance', 'legocreative' ),
          'description' => __( 'title will be below Circle Counter', 'legocreatives' ),
          ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Size of title', 'legocreative' ),
          'param_name' => 'size-title',
          'std' => '15',
          'group' => __( 'Advance', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'enter size of title in px', 'legocreative' ),
          ),
        array(
          'type' => 'colorpicker',
          'heading' => __( 'Color of title', 'legocreative' ),
          'param_name' => 'color-title',
          'group' => __( 'Advance', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'select color of title', 'legocreative' ),
          ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Line cap', 'legocreative' ),
          'param_name' => 'line-cap',
          'group' => __( 'Advance', 'legocreative' ),
          'value' => array(
            __( 'Round', 'legocreative' ) => 'round',
            __( 'Butt', 'legocreative' ) => 'butt',
            __( 'Square', 'legocreative' ) => 'square',
            ),
          'std' => 'round',
          'description' => __( 'defines how the ending of the bar line looks like', 'legocreative' ),
          ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Line width', 'legocreative' ),
          'param_name' => 'line-width',
          'group' => __( 'Advance', 'legocreative' ),
          'std' => '5',
          'description' => __( 'width of the chart line in px', 'legocreative' ),
          ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Rotate', 'legocreative' ),
          'param_name' => 'rotate',
          'group' => __( 'Advance', 'legocreative' ),
          'std' => '0',
          'description' => __( 'rotation of the complete chart in degrees', 'legocreative' ),
          ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Animate', 'legocreative' ),
          'param_name' => 'animate',
          'group' => __( 'Advance', 'legocreative' ),
          'std' => '2000',
          'description' => __( 'time in milliseconds and boolean for an animation of the bar growing', 'legocreative' ),
          ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Add scale lines', 'legocreative' ),
          'param_name' => 'add-scale',
          'group' => __( 'Advance', 'legocreative' ),
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'true',
          ),
          'description' => __( 'do you want to add scale lines?', 'legocreative' ),
          ),
        array(
          'type' => 'colorpicker',
          'heading' => __( 'Color of scale lines', 'legocreative' ),
          'param_name' => 'color-scale',
          'group' => __( 'Advance', 'legocreative' ),
          'dependency' => array(
            'element' => 'add-scale',
            'value' => 'true',
            ),
          'std' => '#000000',
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'select color of scale lines', 'legocreative' ),
          ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Length of scale lines', 'legocreative' ),
          'param_name' => 'length-scale',
          'group' => __( 'Advance', 'legocreative' ),
          'dependency' => array(
            'element' => 'add-scale',
            'value' => 'true',
            ),
          'edit_field_class' => 'vc_col-sm-6',
          'description' => __( 'enter length of scale lines', 'legocreative' ),
          ),
        array(
          'type'         => 'textfield',
          'heading'      => __( 'Extra class name', 'legocreative' ),
          'param_name'   => 'el_class',
          'description'  => __( 'style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
          ),
        ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Veac_Circle_Counter extends WPBakeryShortCode {}
}
