<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Sample class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Gradient_Background extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_gradient_background';
  protected $name = 'Gradient Background';
  protected $desc = 'Set gradient image as background';

  public function params() {
    return array(
      'content_element' => true,
      'is_container' => true,
      'custom_markup' => '',
      'js_view' => 'VcColumnView',
      'icon' => vc_addons_kit_assets( 'img/icons/gradient-background.png' ),
      'params' => array(
        array(
          'type' => 'dropdown',
          'param_name' => 'type',
          'heading' => __( 'Type', 'legocreative' ),
          'value' => array(
            __( 'Linear gradients', 'legocreative' ) => 'linear-gradient',
            __( 'Radial gradients', 'legocreative' ) => 'radial-gradient',
          ),
          'std' => 'linear-gradient',
        ),
        array(
          'type' => 'param_group',
          'param_name' => 'color_strip',
          'heading' => __( 'Color strip', 'legocreative' ),
          'params' => array(
            array(
              'type' => 'colorpicker',
              'param_name' => 'color',
              'heading' => __( 'Color', 'legocreative' ),
            ),
            array(
              'type' => 'textfield',
              'param_name' => 'position_stop',
              'heading' => __( 'Position stop', 'legocreative' ),
              'description' => __( 'Optional. By default, automatically calculated for you. Accept pixel and percentage unit.', 'legocreative' ),
            ),
          ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'direction',
          'heading' => __( 'Direction', 'legocreative' ),
          'value' => array(
            __( 'To bottom', 'legocreative' ) => 'bottom',
            __( 'To top', 'legocreative' ) => 'top',
            __( 'To left', 'legocreative' ) => 'left',
            __( 'To right', 'legocreative' ) => 'right',
            __( 'To bottom right', 'legocreative' ) => 'bottom_right',
            __( 'To left', 'legocreative' ) => 'bottom_left',
            __( 'To top right', 'legocreative' ) => 'top_right',
            __( 'To top left', 'legocreative' ) => 'top_left',
            __( 'Custom', 'legocreative' ) => 'custom',
          ),
          'std' => 'bottom',
          'dependency' => array(
            'element' => 'type',
            'value' => array( 'linear-gradient' ),
          ),
          'description' => __( 'By default, linear gradients run from top to bottom', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'textfield',
          'param_name' => 'angle',
          'heading' => __( 'Angle', 'legocreative' ),
          'std' => '180',
          'dependency' => array(
            'element' => 'direction',
            'value' => array(
              'custom',
            ),
          ),
          'description' => __( 'Degree', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'shape',
          'heading' => __( 'Shape', 'legocreative' ),
          'value' => array(
            __( 'Ellipse', 'legocreative' ) => 'ellipse',
            __( 'Circle', 'legocreative' ) => 'circle',
          ),
          'etd' => 'ellipse',
          'dependency' => array(
            'element' => 'type',
            'value' => array( 'radial-gradient' ),
          ),
          'description' => __( 'By default, use Ellipse', 'legocreative' ),
        ),
        array(
          'type' => 'dropdown',
          'param_name' => 'size',
          'heading' => __( 'Size', 'legocreative' ),
          'value' => array(
            __( 'Farthest Corner', 'legocreative' ) => 'farthest-corner',
            __( 'Farthest Side', 'legocreative' ) => 'farthest-side',
            __( 'Closest Corner', 'legocreative' ) => 'closest-corner',
            __( 'Closest Side', 'legocreative' ) => 'closest-side',
          ),
          'std' => 'farthest-corner',
          'dependency' => array(
            'element' => 'type',
            'value' => array(
              'radial-gradient',
            ),
          ),
          'description' => __( 'By default, use Farthest Corner', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'param_name' => 'coordinates',
          'heading' => __( 'Coordinates', 'legocreative' ),
          'std' => '50% 50%',
          'dependency' => array(
            'element' => 'type',
            'value' => array(
              'radial-gradient',
            ),
          ),
          'description' => __( 'By default, 50% 50% as center. Accept pixel and percentage unit.' ),
        ),
        array(
          'type' => 'attach_image',
          'param_name' => 'image',
          'heading' => __( 'Image', 'legocreative' ),
          'description' => __( 'Optional', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'param_name'  => 'el_class',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
        array(
          'type' => 'css_editor',
          'param_name' => 'css',
          'heading' => __( 'CSS box', 'legocreative' ),
          'group' => __( 'Design Options', 'legocreative' ),
        ),
      ),
    );
  }
}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
  class WPBakeryShortCode_Vckit_Gradient_Background extends WPBakeryShortCodesContainer {
  }
}
