<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Magazine Grid class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Grid_Magazine extends Vckit_Shortcode_Grid {

  protected $grid = 'magazine';
  protected $name = 'Magazine Grid';
  protected $desc = 'Magazine grid with elegant style.';

  public function params() {
    $atts = $this->getBasicAtts();

    foreach ( $atts as $key => $att ) {
      if ( 'element_width' == $att['param_name'] || 'gap' == $att['param_name'] ) {
        unset( $atts[ $key ] );
      }
    }

    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/magazine-grid.png' ),
      'params' => array_merge( array(
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Style', 'legocreative' ),
          'param_name' => 'style',
          'value'      => array(
            __( 'Style 1', 'legocreative' )   => 'style1',
            __( 'Style 2', 'legocreative' )   => 'style2',
          ),
          'std'         => 'style1',
          'description' => __( 'Select magazine loading style.', 'legocreative' ),
        ),
      ), $atts ),
    );
  }

  public function enqueueScripts() {
    vc_icon_element_fonts_enqueue( 'fontawesome' );
  }
}
