<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Icon Box class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

define( 'EIB_PRIMARY_COLOR', '#c0c0c0' );
define( 'EIB_SECONDARY_COLOR', '#333333' );
define( 'EIB_HOVER_PRIMARY_COLOR', '#1abc9c' );
define( 'EIB_HOVER_SECONDARY_COLOR', '#ffffff' );

class Vckit_Shortcode_Icon_Box extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_icon_box';
  protected $name = 'Icon Box';
  protected $desc = 'Icon box and content boxes';

  public function params() {
    return array(
      'custom_markup' => '{{title}}',
      'icon' => vc_addons_kit_assets( 'img/icons/icon-box.png' ),
      'params' => array_merge( array(
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Layout', 'legocreative' ),
          'param_name' => 'layout',
          'value'      => array(
              __( 'Icon with title', 'legocreative' )   => 'icon-with-title',
              __( 'Icon on top', 'legocreative' )   => 'icon-on-top',
              __( 'Icon on side', 'legocreative' )   => 'icon-on-side',
              __( 'Icon boxed', 'legocreative' )   => 'icon-boxed',
              // __("Clean vertical", 'legocreative' )   => "clean-vertical",
              // __("Clean horizontal", 'legocreative' )   => "clean-horizontal",
              __( 'Rounded card', 'legocreative' )   => 'rounded-card',
              __( 'Flag', 'legocreative' )   => 'flag',
              __( 'Team member', 'legocreative' )   => 'team-member',
              __( 'Highlight', 'legocreative' )   => 'highlight',
          ),
          'std'         => 'icon-on-top',
          'description' => __( 'Select layout for Icon Box.', 'legocreative' ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Icon align', 'legocreative' ),
          'param_name' => 'icon_align',
          'value' => array(
              __( 'Left', 'legocreative' )   => 'left',
              __( 'Right', 'legocreative' )   => 'right',
          ),
          'description' => __( 'Sets the content’s alignment. This parameter is for icon-with-title and icon-on-side layouts only.', 'legocreative' ),
          'dependency'  => array(
            'element' => 'layout',
            'value'   => array( 'icon-with-title', 'icon-on-side' ),
          ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Icon on top align', 'legocreative' ),
          'param_name' => 'icon_top_align',
          'value' => array(
              __( 'Center', 'legocreative' )   => 'center',
              __( 'Left', 'legocreative' )   => 'left',
              __( 'Right', 'legocreative' )   => 'right',
          ),
          'description' => __( 'Sets the icon’s alignment. This parameter is for icon-on-top layout only.', 'legocreative' ),
          'dependency'  => array(
            'element' => 'layout',
            'value'   => array( 'icon-on-top' ),
          ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Icon Box type', 'legocreative' ),
          'param_name' => 'icon_box_type',
          'value'      => array(
              __( 'Icon', 'legocreative' )         => 'icon',
              __( 'Image', 'legocreative' )        => 'image',
              __( 'Svg animation', 'legocreative' ) => 'svg',
          ),
          'description' => __( "Select icon type. If you don't want to use icon, you can use your image", 'legocreative' ),
        ),
      ) ,
      $this->addIconLibrary(array(
        'element' => 'icon_box_type',
        'value'   => array( 'icon' ),
      ) ),
      array(
        array(
          'type'        => 'attach_image',
          'heading'     => 'Image',
          'param_name'  => 'image',
          'description' => __( 'Select image from media library', 'legocreative' ),
          'dependency'  => array(
            'element' => 'icon_box_type',
            'value'   => array( 'image' ),
          ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Image width', 'legocreative' ),
          'param_name'  => 'image_width',
          'value'       => '75',
          'description' => __( 'This parameter is for custom icon images. Accepts a numerical value to set a custom width in pixels. For example, 40 for tiny, 60 for small, 90 for medium, 120 for large and 200 for x-large.', 'legocreative' ),
          'dependency'  => array(
            'element' => 'icon_box_type',
            'value'   => array( 'image' ),
          ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Image height', 'legocreative' ),
          'param_name'  => 'image_height',
          'value'       => '75',
          'description' => __( 'This parameter is for custom icon images. Accepts a numerical value to set a custom width in pixels. For example, 40 for tiny, 60 for small, 90 for medium, 120 for large and 200 for x-large.', 'legocreative' ),
          'dependency'  => array(
            'element' => 'icon_box_type',
            'value'   => array( 'image' ),
          ),
        ),
        array(
          'type'        => 'attach_image',
          'heading'     => __( 'SVG', 'legocreative' ),
          'param_name'  => 'svg',
          'description' => __( 'Select svg from media library', 'legocreative' ),
          'dependency'  => array(
            'element' => 'icon_box_type',
            'value'   => array( 'svg' ),
          ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'SVG duration', 'legocreative' ),
          'param_name'  => 'svg_duration',
          'value'       => '200',
          'description' => __( 'Set duration of svg animatiton (in seconds).', 'legocreative' ),
          'dependency'  => array(
            'element' => 'icon_box_type',
            'value'   => array(
              'svg',
            ),
          ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'SVG timing function', 'legocreative' ),
          'param_name' => 'svg_timing',
          'value'      => array(
              __( 'Linear', 'legocreative' )   => 'LINEAR',
              __( 'Ease', 'legocreative' )   => 'EASE',
              __( 'Ease in', 'legocreative' )   => 'EASE_IN',
              __( 'Ease out', 'legocreative' )   => 'EASE_OUT',
              __( 'Ease out bounce', 'legocreative' )   => 'EASE_OUT_BOUNCE',
          ),
          'std'         => 'LINEAR',
          'dependency'  => array(
            'element' => 'icon_box_type',
            'value'   => array(
              'svg',
            ),
          ),
          'description' => __( 'Select timing function for svg icon.', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Title', 'legocreative' ),
          'param_name'  => 'title',
          'value'       => '',
          'description' => __( 'Your custom title text', 'legocreative' ),
        ),
        array(
          'type'        => 'textarea_html',
          'heading'     => __( 'Content', 'legocreative' ),
          'param_name'  => 'content',
          //'value'       => '',
        ),
        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Enable Link', 'legocreative' ),
          'param_name'  => 'enable_link',
          'value'       => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Enable this option to add link to image', 'legocreative' ),
        ),
        array(
          'type' => 'vc_link',
          'heading' => __( 'URL (Link)', 'legocreative' ),
          'param_name' => 'link',
          'description' => __( 'Add link to icon box.', 'legocreative' ),
          'dependency'  => array(
            'element' => 'enable_link',
            'value'   => array( 'yes' ),
          ),
        ),
        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Enable readmore', 'legocreative' ),
          'param_name'  => 'enable_readmore',
          'value'       => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Enable this option to add link to image', 'legocreative' ),
          'dependency'  => array(
            'element' => 'enable_link',
            'value'   => array( 'yes' ),
          ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Readmore text', 'legocreative' ),
          'param_name'  => 'readmore_text',
          'value'       => __( 'Read more', 'legocreative' ),
          'description' => __( 'Readmore text', 'legocreative' ),
          'dependency'  => array(
            'element' => 'enable_readmore',
            'value'   => array( 'yes' ),
          ),
        ),
        array(
          'type' => 'animation_style',
          'heading' => __( 'Css animation', 'legocreative' ),
          'param_name' => 'css_animation',
          'settings' => array(
            'type' => array(
              'in',
              'other',
            ),
          ),
          'description' => __( 'Select "animation in" for uppear item.', 'legocreative' ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
        array(
          'type'       => 'vckit_class',
          'heading'    => '',
          'param_name' => 'eib_custom_class',
          'value'      => '',
        ),

        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Icon Effect', 'legocreative' ),
          'param_name' => 'icon_effect',
          'group'      => __( 'Icon Options', 'legocreative' ),
          'value'      => array(
            __( 'None', 'legocreative' )   => 'eib-icon-effect-none',
            __( 'Effect 1a', 'legocreative' )   => 'eib-icon-effect-1 eib-icon-effect-1a',
            __( 'Effect 1b', 'legocreative' )   => 'eib-icon-effect-1 eib-icon-effect-1b',
            __( 'Effect 2a', 'legocreative' )   => 'eib-icon-effect-2 eib-icon-effect-2a',
            __( 'Effect 2b', 'legocreative' )   => 'eib-icon-effect-2 eib-icon-effect-2b',
            __( 'Effect 3a', 'legocreative' )   => 'eib-icon-effect-3 eib-icon-effect-3a',
            __( 'Effect 3b', 'legocreative' )   => 'eib-icon-effect-3 eib-icon-effect-3b',
            __( 'Effect 4a', 'legocreative' )   => 'eib-icon-effect-4 eib-icon-effect-4a',
            __( 'Effect 4b', 'legocreative' )   => 'eib-icon-effect-4 eib-icon-effect-4b',
            __( 'Effect 5a', 'legocreative' )   => 'eib-icon-effect-5 eib-icon-effect-5a',
            __( 'Effect 5b', 'legocreative' )   => 'eib-icon-effect-5 eib-icon-effect-5b',
            __( 'Effect 5c', 'legocreative' )   => 'eib-icon-effect-5 eib-icon-effect-5c',
            __( 'Effect 5d', 'legocreative' )   => 'eib-icon-effect-5 eib-icon-effect-5d',
            __( 'Effect 6', 'legocreative' )   => 'eib-icon-effect-6',
            __( 'Effect 7a', 'legocreative' )   => 'eib-icon-effect-7 eib-icon-effect-7a',
            __( 'Effect 7b', 'legocreative' )   => 'eib-icon-effect-7 eib-icon-effect-7b',
            __( 'Effect 8', 'legocreative' )   => 'eib-icon-effect-8',
            __( 'Effect 9a', 'legocreative' )   => 'eib-icon-effect-9 eib-icon-effect-9a',
            __( 'Effect 9b', 'legocreative' )   => 'eib-icon-effect-9 eib-icon-effect-9b',
          ),
          'std'         => 'eib-icon-effect-none',
          'description' => __( 'Select hover effect for Icon.', 'legocreative' ),
        ),
        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Disable Hover on Box, Enable Hover on Icon', 'legocreative' ),
          'param_name'  => 'enable_hover_icon_only',
          'group'      => __( 'Icon Options', 'legocreative' ),
          'value'       => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Check this checkbox to disable box hover and enable icon hover', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Icon color', 'legocreative' ),
          'param_name' => 'icon_text_color',
          'group'      => __( 'Icon Options', 'legocreative' ),
          //'value'      => EIB_SECONDARY_COLOR,
          'edit_field_class' => 'vc_col-sm-6',
          'dependency'  => array(
            'element' => 'icon_box_type',
            'value'   => array( 'icon', 'svg' ),
          ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Hover - Icon color', 'legocreative' ),
          'param_name' => 'icon_hover_text_color',
          'group'      => __( 'Icon Options', 'legocreative' ),
          //'value'      => EIB_HOVER_SECONDARY_COLOR,
          'edit_field_class' => 'vc_col-sm-6',
          'dependency'  => array(
            'element' => 'icon_box_type',
            'value'   => array( 'icon' ),
          ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Icon background & border color', 'legocreative' ),
          'param_name' => 'icon_color',
          'group'      => __( 'Icon Options', 'legocreative' ),
          //'value'      => EIB_PRIMARY_COLOR,
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Hover - Icon background & border color', 'legocreative' ),
          'param_name' => 'icon_hover_color',
          'group'      => __( 'Icon Options', 'legocreative' ),
          //'value'      => EIB_HOVER_PRIMARY_COLOR,
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Icon Shape', 'legocreative' ),
          'param_name' => 'icon_boxed_radius',
          'group'      => __( 'Icon Options', 'legocreative' ),
          'value'      => array(
              __( 'Circle', 'legocreative' )  => 'circle',
              __( 'Rounded', 'legocreative' ) => 'rounded',
              __( 'Squared', 'legocreative' ) => 'squared',
              __( 'Diamond', 'legocreative' ) => 'diamond',
          ),
          'std'         => 'circle',
          'description' => __( 'Select boxed radius for Icon.', 'legocreative' ),
        ),
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Icon size', 'legocreative' ),
          'param_name' => 'icon_size',
          'group'      => __( 'Icon Options', 'legocreative' ),
          'value'      => array(
              __( 'Tiny', 'legocreative' )   => 'tiny',
              __( 'Small', 'legocreative' )  => 'small',
              __( 'Medium', 'legocreative' ) => 'medium',
              __( 'Large', 'legocreative' )  => 'large',
              __( 'X Large', 'legocreative' )  => 'xlarge',
          ),
          'std'         => 'medium',
          'description' => __( 'Select size for Icon.', 'legocreative' ),
        ),

        // Style tab
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Title text size', 'legocreative' ),
          'param_name'  => 'title_font_size',
          'group'       => __( 'Custom style', 'legocreative' ),
          'description' => __( 'Custom font size for title.', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Title color', 'legocreative' ),
          'param_name' => 'title_color',
          'group'      => __( 'Custom style', 'legocreative' ),
          //'value'      => EIB_SECONDARY_COLOR,
          'description' => __( 'Select color for title.', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Description color', 'legocreative' ),
          'param_name' => 'description_color',
          'group'      => __( 'Custom style', 'legocreative' ),
          //'value'      => EIB_SECONDARY_COLOR,
          'description' => __( 'Select color for description.', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Readmore color', 'legocreative' ),
          'param_name' => 'readmore_color',
          'group'      => __( 'Custom style', 'legocreative' ),
          //'value'      => EIB_SECONDARY_COLOR,
          'description' => __( 'Select color for readmore link.', 'legocreative' ),
        ),

        array(
          'type' => 'css_editor',
          'heading' => __( 'CSS box', 'legocreative' ),
          'param_name' => 'css',
          'group' => __( 'Design Options', 'legocreative' ),
        ),
      ) ),
    );
  }

  public function getCustomCSS( $atts ) {
    $eib_custom_class =
    $title_color =
    $description_color =
    $readmore_color =
    $icon_text_color =
    $icon_color =
    $icon_hover_text_color =
    $icon_effect =
    $icon_hover_color =
    $css = '';

    extract( $atts );
    // Don't use $css here. It will override $css variable;
    $extra_css = '';

    $custom_class = $eib_custom_class;
    if ( isset( $custom_class ) ) {
      $custom_class = '.elegant-icon-box.' . $custom_class;
      // Basic
      if ( ! empty( $title_color ) ) {
        $extra_css .= $custom_class . ' h3, '
          . $custom_class . ' h3 > a { color: ' .
          $title_color . '; }';
      }
      if ( ! empty( $description_color ) ) {
        $extra_css .= $custom_class . ' .eib-description { color: ' .
          $description_color . '; }';
      }
      if ( ! empty( $readmore_color ) ) {
        $extra_css .= $custom_class . ' .eib-readmore { color: ' .
          $readmore_color . '; }';
      }

      // Text color
      if ( ! empty( $icon_text_color ) ) {
        $extra_css .= $custom_class . ' .eib-icon, '
          . $custom_class . ' .eib-icon > a { color: ' .
        $icon_text_color . '; }';

        // For svg
        $extra_css .= $custom_class . '.elegant-icon-box.eib-type-svg .eib-icon svg path { stroke: ' .
          $icon_text_color . ';}';

        // For svg
        $extra_css .= $custom_class . '.eib-layout-highlight .eib-wrapper:hover { box-shadow: 0 2px 17px ' . $icon_text_color . ';}';
      }

      if ( ! empty( $icon_color ) ) {
        $extra_css .= $custom_class . ' .eib-before-icon { background-color: ' .
          $icon_color . '; }';

        $extra_css .= $custom_class . ' .eib-after-icon { border-color: ' .
          $icon_color . '}';
      }

      // ON HOVER
      // Hover text color
      if ( ! empty( $icon_hover_text_color ) ) {
        $extra_css .= $custom_class . '.eib-hover-icon .eib-icon:hover, '
          . $custom_class . '.eib-hover-global:hover .eib-icon, '
          . $custom_class . '.eib-hover-icon .eib-icon:hover > a, '
          . $custom_class . '.eib-hover-global:hover .eib-icon > a { color: ' .
        $icon_hover_text_color . '; }';
      }

      // Hover primary color
      if ( ! empty( $icon_color ) ) {
        if ( preg_match( '/eib-icon-effect-4/i', $icon_effect ) ) {
          $extra_css .= $custom_class .
            ' .eib-fonts-icon { box-shadow: 0 0 0 4px ' .
            $icon_color . '; }'; // icon_color not icon_text_color
        }
      }

      if ( ! empty( $icon_hover_color ) ) {
        if ( preg_match( '/eib-icon-effect-7/i', $icon_effect ) ) {
          $extra_css .= $custom_class . '.eib-hover-icon .eib-icon:hover .eib-before-icon, '
          . $custom_class . '.eib-hover-global:hover .eib-before-icon { box-shadow: 3px 3px 0 ' .
            $icon_hover_color . '; }';
        } elseif ( preg_match( '/eib-icon-effect-9/i', $icon_effect ) ) {
          $extra_css .= $custom_class . '.eib-hover-icon .eib-icon:hover .eib-before-icon, '
          . $custom_class . '.eib-hover-global:hover .eib-before-icon { border-color: ' .
            $icon_hover_color . '; }';
        } else {
          $extra_css .= $custom_class . '.eib-hover-icon .eib-icon:hover .eib-before-icon, '
          . $custom_class . '.eib-hover-global:hover .eib-before-icon { background-color: ' .
            $icon_hover_color . '; }';
        }

        $extra_css .= $custom_class . '.eib-hover-icon .eib-icon:hover .eib-after-icon, '
          . $custom_class . '.eib-hover-global:hover .eib-after-icon { border-color: ' .
          $icon_hover_color . '}';
      }

      if ( ! empty( $css ) ) {
        preg_match_all( '/background-color:.*(\#.{3,6})[\s!;\"\']/', $css, $flag_bg );

        if ( ! empty( $flag_bg[1][0] ) ) {
          $extra_css .= $custom_class . ' .eib-after-wrapper svg { fill: ' . $flag_bg[1][0] . '}';
        }
      }
    } // End if().

    return $extra_css;
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Icon_Box extends WPBakeryShortCode {}
}
