<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Icon_Showcase Item class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Icon_Showcase_Item extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_icon_showcase_item';
  protected $name = 'Icon Showcase Item';
  protected $desc = '';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/showcase.png' ),
      'as_child' => array(
        'only' => 'vckit_icon_showcase',
      ),
      'params' => array_merge(
        $this->addIconLibrary(),
        array(
          array(
            'type' => 'textfield',
            'heading' => __( 'Title', 'legocreative' ),
            'param_name' => 'title',
          ),
          array(
            'type'       => 'dropdown',
            'heading'    => __( 'Title Tag', 'legocreative' ),
            'param_name' => 'title_tag',
            'value'      => array(
              'h2' => 'h2',
              'h3' => 'h3',
              'h4' => 'h4',
              'h5' => 'h5',
              'h6' => 'h6',
            ),
            'std' => 'h3',
            'dependency' => array(
              'element' => 'title',
              'not_empty' => true,
            ),
          ),
          array(
            'type' => 'vc_link',
            'heading' => __( 'URL (Link)', 'legocreative' ),
            'param_name' => 'link',
            'description' => __( 'Add link to the title.', 'legocreative' ),
          ),
          array(
            'type' => 'textarea',
            'heading' => __( 'Text', 'legocreative' ),
            'param_name' => 'text',
          ),
        )
      ),
    );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Icon_Showcase_Item extends WPBakeryShortCode {}
}
