<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * New instafeed module
 *
 * VC KIT Shortcode Instafeed class.
 *
 * @since 2.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Instafeed extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_instafeed';
  protected $name = 'Instafeed';
  protected $desc = 'Instagram feed by themelego.';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/instafeed.png' ),
      'params' => array_merge( array(
        array(
          'type' => 'textfield',
          'heading' => __( 'Access Token', 'legocreative' ),
          'param_name' => 'token',
          'value' => '5593239394.96af6d7.ec66784b760e4123b22cd6fbb5b5c99f',
          'description' => __( 'Use when Get Image from: \'Access Token\'. <a href="http://www.jetseotools.com/instagram/">Where do I find Access Token</a>', 'legocreative' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Sort by' , 'legocreative' ),
          'param_name' => 'sortby',
          'value' => array(
            __( 'None', 'legocreative' ) => 'none',
            __( 'Newest to oldest', 'legocreative' ) => 'most-recent',
            __( 'Oldest to newest', 'legocreative' ) => 'least-recent',
            __( 'Highest # of likes to lowest.', 'legocreative' ) => 'most-liked',
            __( 'Lowest # likes to highest.', 'legocreative' ) => 'least-liked',
            __( 'Highest # of comments to lowest.', 'legocreative' ) => 'most-commented',
            __( 'Lowest # of comments to highest.', 'legocreative' ) => 'least-commented',
            __( 'Random order', 'legocreative' ) => 'random',
            ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Items Display', 'legocreative' ),
          'param_name' => 'limit',
          'value' => '6',
          'description' => __( 'This variable allows you to set the maximum amount of items displayed at a time with the widest browser width, maximum is 20', 'legocreative' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Hover Color scheme' , 'legocreative' ),
          'param_name' => 'color_scheme',
          'value' => array(
            __( 'Default', 'legocreative' ) => 'default',
            __( 'Yellow black', 'legocreative' ) => 'yellow-black',
            __( 'Blue white', 'legocreative' ) => 'blue-white',
            __( 'Green gray', 'legocreative' ) => 'green-gray',
            ),
          'description' => __( 'Choose color scheme.', 'legocreative' ),
        ),
        array(
          'type'       => 'textfield',
          'heading'    => __( 'Extra class name', 'legocreative' ),
          'param_name' => 'el_class',
          'description'       => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
        ),
      ), $this->addCarouselOptions( null, __( 'Carousel Options', 'legocreative' ) ), array(
        array(
          'type' => 'css_editor',
          'heading' => __( 'CSS feed', 'legocreative' ),
          'param_name' => 'css',
          'group' => __( 'Design Options', 'legocreative' ),
        ),
      ) ),
    );
  }

  public function enqueueScripts() {
    vc_icon_element_fonts_enqueue( 'fontawesome' );
    wp_enqueue_script( 'vckit-instafeedjs', vc_addons_kit_assets( 'js/instafeed.min.js' ), array(), vc_addons_kit()->__get( 'version' ), true );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Instafeed extends WPBakeryShortCode {}
}
