<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Lightbox class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Lightbox extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_lightbox';
  protected $name = 'Lightbox';
  protected $desc = 'Enable content to lightbox';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/lightbox.png' ),
      'content_element' => true,
      'is_container' => true,
      'custom_markup' => '',
      'js_view' => 'VcColumnView',
      'params' => array(
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Lightbox Id', 'legocreative' ),
          'param_name'  => 'id',
          'value'       => '',
          'description' => __( 'Add an unique id for lightbox to open it', 'legocreative' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Lightbox size', 'legocreative' ),
          'param_name' => 'size',
          'description' => __( 'Select the size box size', 'legocreative' ),
          'value'      => array(
            __( 'Medium', 'legocreative' ) => 'medium',
            __( 'Large', 'legocreative' ) => 'large',
            __( 'Small', 'legocreative' ) => 'small',
          ),
        ),
        array(
          'type'        => 'textfield',
          'heading'     => __( 'Width (px)', 'legocreative' ),
          'param_name'  => 'width',
          'value'       => '',
          'description' => __( 'Set width for your lightbox', 'legocreative' ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.', 'legocreative' ),
        ),
        array(
          'type'       => 'vckit_class',
          'heading'    => '',
          'param_name' => 'custom_class',
          'value'      => '',
        ),

        array(
          'type' => 'css_editor',
          'heading' => __( 'CSS box', 'legocreative' ),
          'param_name' => 'css',
          'group' => __( 'Design Options', 'legocreative' ),
        ),
      ),
    );
  }

  public function getCustomCSS( $atts ) {
    $el_class =
    $id =
    $size =
    $css =
    $width =
    $custom_class = '';

    extract( $atts );

    if ( preg_match( '/^[0-9]+$/', $width ) ) {
      $width .= 'px';
    }

    $extra_css = '';

    if ( $custom_class ) {
      $custom_class = '.vckit-lightbox.' . $custom_class;

      if ( $width ) {
        $extra_css .= $custom_class . ' { width: ' . $width . '; }';
      }
    }

    return $extra_css;
  }
}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
  class WPBakeryShortCode_Vckit_Lightbox extends WPBakeryShortCodesContainer {
  }
}
