<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * VC KIT Shortcode Pricing Box class.
 *
 * @since 1.0
 * @package Visual Composer KIT
 */

class Vckit_Shortcode_Pricing_Box extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_pricing_box';
  protected $name = 'Pricing Box';
  protected $desc = 'Pricing box inspration.';

  public function params() {
    return array(
      'icon' => vc_addons_kit_assets( 'img/icons/pricing-box.png' ),
      'params' => array(
        array(
          'type'       => 'dropdown',
          'heading'    => __( 'Pricing style', 'legocreative' ),
          'param_name' => 'style',
          'value'      => array(
            __( 'Sonam', 'legocreative' )  => 'sonam',
            __( 'Jinpa', 'legocreative' )  => 'jinpa',
            __( 'Tenzin', 'legocreative' ) => 'tenzin',
            __( 'Yama', 'legocreative' )   => 'yama',
            __( 'Rabten', 'legocreative' ) => 'rabten',
            __( 'Pema', 'legocreative' )   => 'pema',
            __( 'Karma', 'legocreative' )  => 'karma',
            __( 'Norbu', 'legocreative' )  => 'norbu',
            __( 'Yonten', 'legocreative' ) => 'yonten',
            __( 'Tashi', 'legocreative' )  => 'tashi',
            __( 'Palden', 'legocreative' ) => 'palden',
          ),
          'std'         => 'palden',
          'description' => __( 'Select style for pricing box.', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Show plan icon', 'legocreative' ),
          'param_name' => 'show_icon',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'dependency' => array(
            'element' => 'style',
            'value'   => array( 'rabten', 'yonten' ),
          ),
        ),
        array(
          'type'       => 'iconpicker',
          'heading'    => __( 'Select plan Icon', 'legocreative' ),
          'param_name' => 'plan_icon',
          'value'      => 'fa fa-image',
          'settings'   => array(
            'emptyIcon' => false,
            // default true, display an "EMPTY" icon?
            // 'iconsPerPage' => 4000,
            // default 100, how many icons per/page to display
          ),
          'dependency' => array(
            'element' => 'show_icon',
            'value'   => 'yes',
          ),
          'description' => __( 'Select icon from library.', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Plan name', 'legocreative' ),
          'param_name' => 'name',
          'value' => 'Basic',
          'description' => __( 'Choose plan name: Basic, Standard, Enterprise', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Sentence', 'legocreative' ),
          'param_name' => 'sentense',
          'value' => '',
          'description' => __( 'Sentense, sub title for plan name', 'legocreative' ),
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Currency', 'legocreative' ),
          'param_name' => 'currency',
          'value' => '$',
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Price', 'legocreative' ),
          'param_name' => 'price',
          'value' => '10',
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type' => 'textfield',
          'heading' => __( 'Period', 'legocreative' ),
          'param_name' => 'period',
          'value' => 'month',
          'edit_field_class' => 'vc_col-sm-4',
        ),
        array(
          'type' => 'param_group',
          'heading' => __( 'Features', 'legocreative' ),
          'param_name' => 'features',
          //'save_always' => true,
          'description' => __( 'Enter features for plan, package - feature name and icon.', 'legocreative' ),
          'value' => urlencode( json_encode( array(
            array(
              'feature' => __( '1 GB of space', 'legocreative' ),
            ),
            array(
              'feature' => __( 'Free support', 'legocreative' ),
            ),
            array(
              'feature' => __( 'Full social media package', 'legocreative' ),
            ),
          ) ) ),
          'params' => array(
            array(
              'type' => 'textfield',
              'heading' => __( 'Feature', 'legocreative' ),
              'param_name' => 'feature',
              'description' => __( 'Enter text used as title of bar.', 'legocreative' ),
              'admin_label' => true,
            ),
            array(
              'type' => 'checkbox',
              'heading' => __( 'Add Icon', 'legocreative' ),
              'param_name' => 'add_icon',
              'value' => array(
                __( 'Yes', 'legocreative' ) => 'yes',
              ),
              //'std' => 'yes',
              'save_always' => true,
            ),
            array(
              'type'       => 'iconpicker',
              'heading'    => __( 'Icon', 'legocreative' ),
              'param_name' => 'icon_fontawesome',
              'value'      => 'fa fa-image',
              'settings'   => array(
                'emptyIcon' => false,
                // default true, display an "EMPTY" icon?
                // 'iconsPerPage' => 4000,
                // default 100, how many icons per/page to display
              ),
              'dependency' => array(
                'element' => 'add_icon',
                'value'   => 'yes',
              ),
              'description' => __( 'Select icon from library.', 'legocreative' ),
            ),
          ),
        ),
        array(
          'type'       => 'textfield',
          'heading'    => __( 'Button text', 'legocreative' ),
          'param_name' => 'pricing_action',
          'value'      => __( 'Choose plan', 'legocreative' ),
          'description' => __( 'Add text to call-to-action button', 'legocreative' ),
          'dependency' => array(
            'element' => 'style',
            'value_not_equal_to'   => 'tashi',
          ),
        ),
        array(
          'type'       => 'textfield',
          'heading'    => __( 'Button link', 'legocreative' ),
          'param_name' => 'pricing_link',
          'description' => __( 'Add link to this plan', 'legocreative' ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Open in new tab', 'legocreative' ),
          'param_name' => 'open_new_tab',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
        ),
        array(
          'type' => 'checkbox',
          'heading' => __( 'Featured plan', 'legocreative' ),
          'param_name' => 'is_featured',
          'value' => array(
            __( 'Yes', 'legocreative' ) => 'yes',
          ),
          'description' => __( 'Is a featured plan', 'legocreative' ),
        ),
        array(
          'type'       => 'textfield',
          'heading'    => __( 'Extra class name', 'legocreative' ),
          'param_name' => 'el_class',
          'description'       => __( 'Style particular content element differently - add a class name and refer to it in custom CSS.
', 'legocreative' ),
        ),

        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Pricing\'s background color', 'legocreative' ),
          'param_name' => 'pricing_bg',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select background color for pricing box.', 'legocreative' ),
          'dependency' => array(
            'element' => 'style',
            'value'   => array( 'jinpa' ),
          ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Pricing\'s hover background color', 'legocreative' ),
          'param_name' => 'pricing_hover_bg',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select hover background color for pricing box.', 'legocreative' ),
          'dependency' => array(
            'element' => 'style',
            'value'   => array( 'jinpa' ),
          ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Plan text color', 'legocreative' ),
          'param_name' => 'plan_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select color for plan name.', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Plan name color', 'legocreative' ),
          'param_name' => 'name_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select color for plan name.', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Sentence color', 'legocreative' ),
          'param_name' => 'sentence_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select color for sentense.', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Price\'s background color', 'legocreative' ),
          'param_name' => 'price_bg',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select background color for pricing ( the red circle ).', 'legocreative' ),
          'dependency' => array(
            'element' => 'style',
            'value'   => array( 'jinpa' ),
          ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Price\'s hover background color', 'legocreative' ),
          'param_name' => 'price_hover_bg',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select background color for pricing when hover ( the red circle ).', 'legocreative' ),
          'dependency' => array(
            'element' => 'style',
            'value'   => array( 'jinpa' ),
          ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Currency color', 'legocreative' ),
          'param_name' => 'currency_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select color for currency.', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Pricing color', 'legocreative' ),
          'param_name' => 'pricing_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select color for pricing.', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Period color', 'legocreative' ),
          'param_name' => 'period_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select color for period.', 'legocreative' ),
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Button\'s background color', 'legocreative' ),
          'param_name' => 'btn_bg',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select background for pricing action.', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Button\'s background Hover color', 'legocreative' ),
          'param_name' => 'btn_bg_hover',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select hover background for pricing action.', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Button\'s text color', 'legocreative' ),
          'param_name' => 'btn_color',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select text color for pricing action.', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'colorpicker',
          'heading'    => __( 'Button\'s text Hover color', 'legocreative' ),
          'param_name' => 'btn_color_hover',
          'group'      => __( 'Customize', 'legocreative' ),
          'description' => __( 'Select hover color for pricing action.', 'legocreative' ),
          'edit_field_class' => 'vc_col-sm-6',
        ),
        array(
          'type'       => 'vckit_class',
          'heading'    => '',
          'param_name' => 'custom_class',
          'group'      => __( 'Customize', 'legocreative' ),
          'value'      => '',
        ),

        array(
          'type' => 'css_editor',
          'heading' => __( 'CSS box', 'legocreative' ),
          'param_name' => 'css',
          'group' => __( 'Design Options', 'legocreative' ),
        ),
      ),
    );
  }

  public function getCustomCSS( $atts ) {
    $price_bg =
    $btn_color =
    $btn_color_hover =
    $btn_bg =
    $price_hover_bg =
    $pricing_bg =
    $pricing_hover_bg =
    $btn_bg_hover =
    $custom_class = '';

    extract( $atts );

    $css = '';
    if ( $custom_class ) {
      $custom_class = '.vckit-pricing-box.' . $custom_class;

      if ( $btn_color ) {
        $css .= $custom_class . ' .pricing__action { color: ' . $btn_color . '; }';
      }
      if ( $btn_color_hover ) {
        $css .= $custom_class . ' .pricing__action:hover { color: ' . $btn_color_hover . '; }';
      }
      if ( $btn_bg ) {
        $css .= $custom_class . ' .pricing__action { background-color: ' . $btn_bg . '; }';
      }
      if ( $btn_bg_hover ) {
        $css .= $custom_class . ' .pricing__action:hover { background-color: ' . $btn_bg_hover . '; }';
      }

      // Jinpa
      if ( $price_bg ) {
        $css .= $custom_class . ' .pricing__price { background: ' . $price_bg . '; }';
      }
      if ( $price_hover_bg ) {
        $css .= $custom_class . ':hover .pricing__price { background: ' . $price_hover_bg . '; }';
      }
      if ( $pricing_bg ) {
        $css .= $custom_class . ' { background: ' . $pricing_bg . '; }';
      }
      if ( $pricing_hover_bg ) {
        $css .= $custom_class . ':hover { background: ' . $pricing_hover_bg . '; }';
      }
    }

    return $css;
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Pricing_Box extends WPBakeryShortCode {}
}
