<?php
if ( ! defined( 'ABSPATH' ) ) { exit; // Exit if accessed directly.
}

/**
 * Elegant Addons Shortcode Testimonial class.
 *
 * @since 1.0
 * @package Elegant Addons for VC
 */

class Vckit_Shortcode_Testimonial extends Vckit_Shortcode_Base {

  protected $shortcode = 'vckit_testimonial';
  protected $name = 'Testimonial';
  protected $desc = 'Testimonial by woothemes';

  public function params() {
    return array(
      'icon'   => vc_addons_kit_assets( 'img/icons/testimonial.png' ),
      'params' => array(

        // --- General ---
        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Template', 'legocreative' ),
          'param_name'  => 'layout',
          'description' => __( 'Choose a template to display testimonials.', 'legocreative' ),
          'value'       => array(
            __( 'Craftego', 'legocreative' ) => 'layout01',
            __( 'Shoot Slider', 'legocreative' ) => 'layout02',
            __( 'Avada Clean', 'legocreative' ) => 'layout03',
            __( 'Avada Hotel', 'legocreative' ) => 'layout04',
            __( 'Avada Home', 'legocreative' ) => 'layout05',
            __( 'Salient Corporate', 'legocreative' ) => 'layout06',
            __( 'Salient Original', 'legocreative' ) => 'layout07',
          ),
          'save_always' => true,
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Category', 'legocreative' ),
          'param_name'  => 'category',
          'description' => __( 'Filter testimonial by category', 'legocreative' ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Limit', 'legocreative' ),
          'param_name'  => 'limit',
          'description' => __( 'Number of Testimonials you want to retrieve from database', 'legocreative' ),
          'value'       => '3',
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Items per row', 'legocreative' ),
          'param_name'  => 'per_row',
          'description' => __( 'Number of Testimonials you want to display per row. Better equal or less than 3. More than 3 may cause unexpected ugly layout so you should use slider if you have more than 3 testimonials.', 'legocreative' ),
          'value'       => '3',
          'dependency'  => array(
            'element'             => 'slider_enable',
            'value_not_equal_to'  => 'true',
          ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Order by', 'legocreative' ),
          'param_name'  => 'orderby',
          'description' => __( 'How to order the items', 'legocreative' ),
          'value'       => array(
            'None'  => 'none',
            'ID'    => 'ID',
            'Title' => 'title',
            'Date'  => 'date',
          ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Order', 'legocreative' ),
          'param_name'  => 'order',
          'description' => __( 'How to order the items', 'legocreative' ),
          'value'       => array(
            'DESC'  => 'DESC',
            'ASC'   => 'ASC',
          ),
          'dependency' => array(
            'element' => 'orderby',
            'value'   => array( 'ID', 'title', 'date' ),
          ),
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Show Author Info', 'legocreative' ),
          'param_name'  => 'display_author',
          'description' => __( 'Choose yes to show author name and byline', 'legocreative' ),
          'value'       => array(
            __( 'Enable', 'legocreative' ) => true,
          ),
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Show URL', 'legocreative' ),
          'param_name'  => 'display_url',
          'description' => __( 'Choose yes to show author URL', 'legocreative' ),
          'value'       => array(
            __( 'Enable', 'legocreative' ) => true,
          ),
          'dependency'  => array(
            'element'   => 'display_author',
            'not_empty' => true,
          ),
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Show Author Image', 'legocreative' ),
          'param_name'  => 'display_avatar',
          'description' => __( 'Choose yes to show author avatar', 'legocreative' ),
          'value'       => array(
            __( 'Enable', 'legocreative' ) => true,
          ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Avatar Size', 'legocreative' ),
          'param_name'  => 'ava_size',
          'description' => __( 'Size of Avatar(the pixel dimensions)', 'legocreative' ),
          'value'       => '100',
          'dependency'  => array(
            'element'   => 'display_avatar',
            'not_empty' => true,
          ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Avatar Shape', 'legocreative' ),
          'param_name'  => 'ava_shape',
          'description' => __( 'Choose shape of Avatar', 'legocreative' ),
          'value'       => array(
            __( 'Squared', 'legocreative' ) => 'ava-squared',
            __( 'Rounded', 'legocreative' )   => 'ava-rounded',
            __( 'Circled', 'legocreative' )  => 'ava-circled',
          ),
          'dependency'  => array(
            'element'   => 'display_avatar',
            'not_empty' => true,
          ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Extra class name', 'legocreative' ),
          'param_name'  => 'el_class',
          'description' => __( 'Add extra class to custom style of testimonials', 'legocreative' ),
        ),

        // --- Advanced Settings ---

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Font size', 'legocreative' ),
          'param_name'  => 'font_size',
          'description' => __( 'Set font size for text', 'legocreative' ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Enable equal height', 'legocreative' ),
          'param_name'  => 'equalheight_enable',
          'description' => __( 'Choose yes to make testimonial items has equal height', 'legocreative' ),
          'value'       => array(
            __( 'Enable', 'legocreative' ) => 'true',
          ),
          'std'         => 'true',
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),
        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Enable Slider', 'legocreative' ),
          'param_name'  => 'slider_enable',
          'description' => __( 'Choose yes to display testimonials as a slider', 'legocreative' ),
          'value'       => array(
            __( 'Enable', 'legocreative' ) => 'true',
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Slides to show', 'legocreative' ),
          'param_name'  => 'slides_to_show',
          'description' => __( 'Number of items you want to show each time.', 'legocreative' ),
          'std'         => '3',
          'value'       => array(
            '1' => '1',
            '2' => '2',
            '3' => '3',
            '4' => '4',
            '5' => '5',
          ),
          'dependency'  => array(
            'element'   => 'slider_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Slides to scroll', 'legocreative' ),
          'param_name'  => 'slides_to_scroll',
          'description' => __( 'Number of items you want to scroll each time. Should be lesser than Slides to show.', 'legocreative' ),
          'value'       => '1',
          'dependency'  => array(
            'element'   => 'slider_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Show dots navigation', 'legocreative' ),
          'param_name'  => 'dots_enable',
          'description' => __( 'Choose yes to display dots navigation of testimonials slider', 'legocreative' ),
          'value'       => array(
            __( 'Enable', 'legocreative' ) => 'true',
          ),
          'dependency'  => array(
            'element'   => 'slider_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Dots color', 'legocreative' ),
          'param_name'  => 'dot_bg_color',
          'dependency'  => array(
            'element'   => 'dots_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Active dots color', 'legocreative' ),
          'param_name'  => 'active_dot_bg_color',
          'dependency'  => array(
            'element'   => 'dots_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Dots border color', 'legocreative' ),
          'param_name'  => 'dot_border_color',
          'dependency'  => array(
            'element'   => 'dots_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Show arrows navigation', 'legocreative' ),
          'param_name'  => 'arrows_enable',
          'description' => __( 'Choose yes to display arrows navigation of testimonials slider', 'legocreative' ),
          'value'       => array(
            __( 'Enable', 'legocreative' ) => 'true',
          ),
          'dependency'  => array(
            'element'   => 'slider_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'dropdown',
          'heading'     => __( 'Choose arrow style', 'legocreative' ),
          'param_name'  => 'arrow_style',
          'description' => __( 'You can choose to display arrow as a single arrow or an arrow with squared wrapper', 'legocreative' ),
          'value'       => array(
            __( 'Single arrow', 'legocreative' ) => 'arrow',
            __( 'Squared arrow', 'legocreative' ) => 'square',
          ),
          'dependency'  => array(
            'element'   => 'arrows_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Arrows color', 'legocreative' ),
          'param_name'  => 'arrow_color',
          'dependency'  => array(
            'element'   => 'arrows_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Arrows background color', 'legocreative' ),
          'param_name'  => 'arrow_bg_color',
          'dependency'  => array(
            'element'   => 'arrows_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Arrows border color', 'legocreative' ),
          'param_name'  => 'arrow_border_color',
          'dependency'  => array(
            'element'   => 'arrows_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'checkbox',
          'heading'     => __( 'Enable autoplay', 'legocreative' ),
          'param_name'  => 'autoplay_enable',
          'description' => __( 'Choose yes to autoplay testimonials slider', 'legocreative' ),
          'value'       => array(
            __( 'Enable', 'legocreative' ) => 'true',
          ),
          'dependency'  => array(
            'element'   => 'slider_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        array(
          'type'        => 'textfield',
          'heading'     => __( 'Autoplay speed', 'legocreative' ),
          'param_name'  => 'autoplay_speed',
          'dependency'  => array(
            'element'   => 'autoplay_enable',
            'not_empty' => true,
          ),
          'group'       => __( 'Advanced Settings', 'legocreative' ),
        ),

        // --- Color options ---
        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Title color', 'legocreative' ),
          'param_name'  => 'title_color',
          'dependency'  => array(
            'element'   => 'display_author',
            'not_empty' => true,
          ),
          'group'       => __( 'Color options', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Byline color', 'legocreative' ),
          'param_name'  => 'byline_color',
          'dependency'  => array(
            'element'   => 'display_author',
            'not_empty' => true,
          ),
          'group'       => __( 'Color options', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'URL color', 'legocreative' ),
          'param_name'  => 'url_color',
          'dependency'  => array(
            'element'   => 'display_url',
            'not_empty' => true,
          ),
          'group'       => __( 'Color options', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'URL hover color', 'legocreative' ),
          'param_name'  => 'url_hover_color',
          'dependency'  => array(
            'element'   => 'display_url',
            'not_empty' => true,
          ),
          'group'       => __( 'Color options', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Content color', 'legocreative' ),
          'param_name'  => 'content_color',
          'group'       => __( 'Color options', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Quote icon color', 'legocreative' ),
          'param_name'  => 'icon_color',
          'dependency'  => array(
            'element' => 'layout',
            'value'   => array(
              'layout04',
              'layout06',
              'layout07',
            ),
          ),
          'group'       => __( 'Color options', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Quote icon background color', 'legocreative' ),
          'param_name'  => 'icon_bg_color',
          'dependency'  => array(
            'element' => 'layout',
            'value'   => array(
              'layout04',
              'layout07',
            ),
          ),
          'group'       => __( 'Color options', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Quote icon border color', 'legocreative' ),
          'param_name'  => 'icon_border_color',
          'dependency'  => array(
            'element' => 'layout',
            'value'   => array(
              'layout04',
              'layout07',
            ),
          ),
          'group'       => __( 'Color options', 'legocreative' ),
        ),

        array(
          'type'        => 'colorpicker',
          'heading'     => __( 'Quote background color', 'legocreative' ),
          'param_name'  => 'quote_bg_color',
          'group'       => __( 'Color options', 'legocreative' ),
        ),

      ),
    );
  }

  public function enqueueScripts() {
    vc_icon_element_fonts_enqueue( 'fontawesome' );
  }
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
  class WPBakeryShortCode_Vckit_Testimonial extends WPBakeryShortCode {}
}

