<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit; // Exit if accessed directly.
}

/**
 * Custom visual composer param types
 */

class Vckit_VC_Param_Types {
  /**
   * Parent plugin class
   *
   * @var VCAddonsKIT
   * @since  1.0
   */
  protected $plugin = null;

  /**
   * Constructor
   *
   * @since  1.0
   * @param  VCAddonsKIT $plugin Main plugin object.
   * @return void
   */
  public function __construct( $plugin ) {
    $this->plugin = $plugin;

    $this->registerParamType();
  }

  public function registerParamType() {
    vc_add_shortcode_param( 'vckit_class', array( $this, 'classFieldSetting' ) );
    vc_add_shortcode_param( 'vckit_id', array( $this, 'idFieldSetting' ) );
    vc_add_shortcode_param( 'vckit_toggle', array( $this, 'toggleSetting' ) );
    vc_add_shortcode_param( 'vckit_tutorial', array( $this, 'tutorialSetting' ) );
  }

  public function toggleSetting( $settings, $value ) {
    if ( ! $settings['value'] ) {
      $settings['value'] = 1;
    }

    $checked = $value ? ' checked' : '';
    return '<div class="vckit-toggle vc_checkbox-label"><input id="'
           . $settings['param_name'] . '" value="'
           . $settings['value'] . '" class="vckit-toggle-checkbox wpb_vc_param_value '
           . $settings['param_name'] . ' checkbox ' . $settings['type'] . '" type="checkbox" name="'
           . $settings['param_name'] . '"'
           . $checked . '><label class="vckit-toggle-label" for="'
           . $settings['param_name'] . '"></label><span class="vc_description">'
           . $settings['description'] . '</span></div>';
  }

  public function tutorialSetting( $settings, $value ) {
    return
      '<div class="vckit-tutorial-block"><h4 class="wpb_vc_param_value "><a href="'
      . $settings['std'] . '" target="_blank">Watch Video Tutorial <span class="dashicons dashicons-video-alt3"></span></a></h4></div>';
  }

  public function classFieldSetting( $settings, $value ) {
    $value = 'vckit_custom_class_' . uniqid( rand( 8, 10 ) );

    return
      '<div class="my_param_block"><input name="' .
      esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-textinput ' .
      esc_attr( $settings['param_name'] ) . ' ' .
      esc_attr( $settings['type'] ) . '_field" type="hidden" value="' . esc_attr( $value ) .
      '" /></div>';
  }

  public function idFieldSetting( $settings, $value ) {
    $value = 'vckit_id_' . uniqid( rand( 8, 10 ) );

    return '<div class="vc_param-vc-grid-id"><input name="'
           . $settings['param_name']
           . '" class="wpb_vc_param_value wpb-textinput '
           . $settings['param_name'] . ' ' . $settings['type'] . '_field" type="hidden" value="'
           . $value . '" /></div>';
  }

}
