<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Core functions
 */

/**
 * Grab the VCAddonsKIT object and return it.
 * Wrapper for VCAddonsKIT::get_instance()
 *
 * @since  1.0
 * @return VCAddonsKIT  Singleton instance of plugin class.
 */
function vc_addons_kit() {
  return VCAddonsKIT::get_instance();
}

if ( ! function_exists( 'vc_addons_kit_assets' ) ) {
  /**
   * Get plugin assets
   *
   * @since 1.0
   *
   * @param string - full directory path to assets
   */
  function vc_addons_kit_assets( $file ) {
    return vc_addons_kit()->assets_dir() . $file;
  }
}


if ( ! function_exists( 'vc_addons_kit_substr' ) ) {
  /**
  * string csubstr ( string string, int start [, int length] )
  *
  * @see http://stackoverflow.com/questions/5956610/how-to-select-first-10-words-of-a-sentence
  * @param string string
  * @param [int length]
  * @return string
  */
  function vc_addons_kit_substr( $sentence, $count = 0 ) {
    if ( $count >= strlen( $sentence ) ) {
      return $sentence;
    }

    if ( $count > 0 ) {
      preg_match( "/(?:\w+(?:\W+|$)){0,$count}/", $sentence, $matches );

      if ( $matches ) {
        return $matches[0] . '<br/>...';
      }
    }

    return '';
  }
}

if ( ! function_exists( 'ea_instagram_elapsed_string' ) ) {
  function ea_instagram_elapsed_string( $datetime, $full = false ) {
    $now = new DateTime;
    $ago = new DateTime();
    $ago->setTimestamp( $datetime );
    $diff = $now->diff( $ago );

    $diff->w = floor( $diff->d / 7 );
    $diff->d -= $diff->w * 7;

    $string = array(
        'w' => 'w',
        'd' => 'd',
        'h' => 'h',
        'i' => 'm',
        's' => 's',
    );
    foreach ( $string as $k => &$v ) {
        if ( $diff->$k ) {
            $v = $diff->$k . $v . ($diff->$k > 1 ? '' : '');
        } else {
            unset( $string[ $k ] );
        }
    }

    if ( ! $full ) {
      $string = array_slice( $string, 0, 1 );
    }

    if ( $string ) {
      foreach ( $string as $s ) {
        return $s;
      }
    }
    // return $string ? implode(', ', $string) . ' ago' : 'just now';
    return 'now';
  }
}

if ( ! function_exists( 'vckit_estimate_read_time' ) ) {
  function vckit_estimate_read_time( $text ) {
    $words = str_word_count( strip_tags( $text ) );
    $min = ceil( $words / 200 );
    return $min . ' min read';
  }
}

if ( ! function_exists( 'vckit_get_option' ) ) {
  function vckit_get_option( $key = '', $default = null ) {
    return vc_addons_kit()->getOption( $key, $default );
  }
}

// @codingStandardsIgnoreStart
if ( ! function_exists( 'darken_color' ) ) {
  function darken_color( $rgb, $darker = 2 ) {

      $hash = (strpos($rgb, '#') !== false) ? '#' : '';
      $rgb = (strlen($rgb) == 7) ? str_replace('#', '', $rgb) : ((strlen($rgb) == 6) ? $rgb : false);
      if(strlen($rgb) != 6) return $hash.'000000';
      //$darker = ($darker > 1) ? $darker : 1;

      list($R16,$G16,$B16) = str_split($rgb,2);

      $R = sprintf("%02X", floor(hexdec($R16)/$darker));
      $G = sprintf("%02X", floor(hexdec($G16)/$darker));
      $B = sprintf("%02X", floor(hexdec($B16)/$darker));

      return $hash.$R.$G.$B;
  }
}

if ( ! function_exists( 'adjustBrightness' ) ) {
  function adjustBrightness($hex, $steps) {
    // Steps should be between -255 and 255. Negative = darker, positive = lighter
    $steps = max(-255, min(255, $steps));

    // Normalize into a six character long hex string
    $hex = str_replace('#', '', $hex);
    if (strlen($hex) == 3) {
        $hex = str_repeat(substr($hex,0,1), 2).str_repeat(substr($hex,1,1), 2).str_repeat(substr($hex,2,1), 2);
    }

    // Split into three parts: R, G and B
    $color_parts = str_split($hex, 2);
    $return = '#';

    foreach ($color_parts as $color) {
        $color   = hexdec($color); // Convert to decimal
        $color   = max(0,min(255,$color + $steps)); // Adjust color
        $return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT); // Make two char hex code
    }

    return $return;
  }
}
// @codingStandardsIgnoreEnd

if ( ! function_exists( 'vckit_setting_to_bytes' ) ) {
  /**
  * Set to bytes
  * @since 2.0
  */
  function vckit_setting_to_bytes( $setting ) {
    $short = array(
      'k' => 0x400,
      'm' => 0x100000,
      'g' => 0x40000000,
    );

    $str = (string) $setting;

    if ( ! ( $len = strlen( $str ) ) ) {
      return null;
    }

    $last     = strtolower( $str[ $len - 1 ] );
    $numeric  = 0 + (int) $setting;
    $numeric *= isset( $short[ $last ] ) ? $short[ $last ] : 1;

    return $numeric;
  }
}

if ( ! function_exists( 'vckit_is_shortcode_enabled' ) ) {
  /**
  * Check shortcode enabled
  * @since 2.0
  */
  function vckit_is_shortcode_enabled( $shortcode, $default_enabled ) {
    // Check shortcode enabled
    $enabled = vckit_get_option( $shortcode );
    $enabled = is_null( $enabled ) ? $default_enabled : $enabled;

    return $enabled;
  }
}
