<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts ); // @codingStandardsIgnoreLine
$el_class = $this->getExtraClass( $el_class );
?>

<div class="vckit-circle-counter-wrapper">
  <div
    id="vckit-circle-counter-<?php echo esc_attr( rand() ) ?>"
    class="vckit-circle-counter"
    data-bar-color="<?php echo esc_attr( $atts['bar-color'] ); ?>"
    data-track-color="<?php echo esc_attr( $atts['track-color'] ); ?>"
    data-percent="<?php echo esc_attr( $atts['percent'] ); ?>"
    data-size="<?php echo esc_attr( $atts['size'] ); ?>"
    data-line-cap="<?php echo esc_attr( $atts['line-cap'] ); ?>"
    data-line-width="<?php echo esc_attr( $atts['line-width'] ); ?>"
    data-rotate="<?php echo esc_attr( $atts['rotate'] ); ?>"
    data-animate="<?php echo esc_attr( $atts['animate'] ); ?>"
    data-scale-color="<?php if ( 'true' == $atts['add-scale'] ) { echo esc_attr( $atts['color-scale'] );
   } else { echo esc_attr( 'false' );
} ?>" data-scale-length="<?php echo esc_attr( $atts['length-scale'] ); ?>">
    <div class="vckit-circle-counter-value"
      style="font-size:<?php echo esc_attr( $atts['size-per-num'] ); ?>px; color:<?php echo esc_attr( $atts['color-per-num'] ); ?>">0%</div>
  </div>
  <div class="vckit-circle-counter-title" style="color: <?php echo esc_attr( $atts['color-title'] ); ?>; font-size: <?php echo esc_attr( $atts['size-title'] ); ?>px;">
    <?php echo esc_html( $atts['title'] ); ?>
  </div>
</div>
