<?php
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

/**
 * Shortcode attributes
 *
 * @package Visual Composer KIT
 *
 * @var $atts
 * @var $effect
 * @var $post_type
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Grid_Interactive
 */

$effect =
$element_width =
$gap =
$grid_id =
$el_class =
$custom_class =
$css = '';

$link_new_tab        = '';
$ratio               = 'original';
$effect              = 'lily';
$disable_item_effect = '';
$disable_font        = '';
$grid_effect = '';
$enable_carousel = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$isLazyLoad = $this->isEnableLazyload();

$css_classes = array(
  'vckit-grid',
  'vckit-grid-interactive',
  $grid_effect,
  $custom_class,
  'vckit-grid-gutter-' . $gap,
);

$wrap_classes = array(
  $el_class,
  vc_shortcode_custom_css_class( $css ),
);

if ( 'yes' == $enable_carousel ) {
  $isLazyLoad = false;
  vc_icon_element_fonts_enqueue( 'fontawesome' );
  $css_classes[] = 'vckit-grid-noanim';
} else {
  array_splice( $wrap_classes, 0, 0, 'vckit-grid-wrap' );
  $css_classes[] = 'vckit-grid-animate';
}

if ( $isLazyLoad ) {
  $css_classes[] = 'vckit-lazyload';
}

$this->addExcludedId( $this->postID() );
if ( 'custom' === $atts['post_type'] && ! empty( $atts['custom_query'] ) ) {
    $query = html_entity_decode( vc_value_from_safe( $atts['custom_query'] ), ENT_QUOTES, 'utf-8' );
    $post_data = query_posts( $query );
} else {
    $settings = $this->filterQuerySettings( $this->buildQuery( $atts ) );
    $post_data = query_posts( $settings );
}

$fonts_class = '';
if ( 'yes' !== $disable_font ) {
  $this->loadFonts();
  $fonts_class = 'effect-fonts';
}
?>
<?php if ( $post_data ) { ?>
  <div class="<?php echo esc_attr( implode( ' ', $wrap_classes ) ); ?>">
    <div
      class="<?php echo esc_attr( implode( ' ', $css_classes ) ); ?>"
      id="<?php echo esc_attr( $grid_id ) ?>"
      <?php
        if ( 'yes' == $enable_carousel ) {
          echo $this->getCarouselAtts( $atts );
        }
      ?>>
        <?php foreach ( $post_data as $item ) { ?>
        <div class="vckit-grid-item vc_col-xs-12 <?php echo $element_width < 12 ? 'vc_col-sm-6' : 'vc_col-sm-12' ?> vc_col-md-<?php echo esc_attr( $element_width ) ?>">
          <div class="vckit-grid-item-wrap">

          <?php
            // Image src is meta_image or post feature image
            $image = '';
            $heading = '';
            $description = $item->post_title;
            $item_effect = $effect;

            if ( 'attachment' === $item->post_type ) {

              $image = $item->ID;
              $heading = '<span>' . $item->post_title . '</span>';
              $description = $item->post_content;

            } else {

              // Get metadata
              $meta_effect       = get_post_meta( $item->ID, 'interactive_grid_effect', true );
              $meta_image_id     = get_post_meta( $item->ID, 'interactive_grid_image_id', true );
              $meta_heading_thin = get_post_meta( $item->ID, 'interactive_grid_heading_thin', true );
              $meta_heading_bold = get_post_meta( $item->ID, 'interactive_grid_heading_bold', true );
              $meta_description  = get_post_meta( $item->ID, 'interactive_grid_description', true );

              // meta_image_id sometimes return '0', sometimes return ''
              if ( '' !== $meta_image_id && '0' !== $meta_image_id ) {
                $image == $meta_image_id;
              } else {
                $image = get_post_thumbnail_id( $item->ID );
              }

              if ( '' !== $meta_description ) {
                $description = $meta_description;
              }

              $heading = $meta_heading_thin . '<span>' . $meta_heading_bold . '</span>';

              if ( 'yes' != $disable_item_effect && '' != $meta_effect ) {
                $item_effect = $meta_effect;
              }
            }

            $item_classes = array(
              'effect-hover',
              'ratio' . $ratio,
              $fonts_class,
              'effect-' . $item_effect,
            );

            $link_attr = '';
            if ( 'yes' == $link_new_tab ) {
              $link_attr = ' target="_blank"';
            }

            if ( $isLazyLoad ) {
              $data_image = 'data-src="' . $this->getImageSrc( $image ) . '"';
            } else {
              $data_image = 'src="' . $this->getImageSrc( $image ) . '"';
            }
          ?>
            <a href="<?php echo esc_url( get_the_permalink( $item->ID ) ) ?>" <?php echo $link_attr //@codingStandardsIgnoreLine  ?>>
              <figure class="<?php echo esc_attr( implode( ' ', $item_classes ) ) ?>">
                <img <?php echo $data_image //@codingStandardsIgnoreLine ?> alt="<?php echo esc_attr( $this->getImageAlt( $image ) ) ?>"/>
                <figcaption>
                  <div class="effect-caption">
                    <h2><?php echo $heading ?></h2>
                    <p class="description"><?php echo esc_html( $description ) ?></p>
                  </div>
                </figcaption>
              </figure>
            </a>
          </div>
        </div>
        <?php } // End foreach(). ?>
    </div>
  </div>

  <?php if ( 'yes' == $enable_carousel ) { ?>
    <style type="text/css"><?php echo $this->getCarouselStyle( $atts, $grid_id ) //@codingStandardsIgnoreLine ?></style>
  <?php } ?>
<?php } ?>
