<?php
if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $el_class
 *
 * Shortcode class
 * @var $this Vckit_Shortcode_Image_Slider
 */

$list_image = $img_size = $el_class = $css = $link = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$list_image = explode( ',', $list_image );

$css_classes = array(
  'vckit-image-slider',
  $this->getExtraClass( $el_class ),
  vc_shortcode_custom_css_class( $css ),
);

$id = 'vckit-image-slider-' . rand();

?>
<div
  id="<?php echo esc_attr( $id ) ?>"
  class="<?php echo implode( $css_classes, ' ' ) //@codingStandardsIgnoreLine ?>"
  <?php echo $this->getCarouselAtts( $atts ) //@codingStandardsIgnoreLine ?>>
  <?php foreach ( $list_image as $img ) { ?>
    <div class="vckit-image-slider__element">
      <?php
      if ( 'link_image' === $link ) {
        wp_enqueue_script( 'prettyphoto' );
        wp_enqueue_style( 'prettyphoto' );
      ?>
      <a
        href="<?php echo esc_url( $this->getImageSrc( $img ) ); ?>"
        class="prettyphoto"
        data-rel="prettyPhoto[pp_gal]"
      >
        <img src="<?php echo esc_url( $this->getImageSrc( $img, $img_size ) ); ?>">
      </a>
      <?php } else { ?>
      <img src="<?php echo esc_url( $this->getImageSrc( $img, $img_size ) ); ?>">
      <?php } ?>
    </div>
  <?php } ?>
</div>
<style type="text/css"><?php echo $this->getCarouselStyle( $atts, $id ) //@codingStandardsIgnoreLine ?></style>
