<?php
if ( ! defined( 'ABSPATH' ) ) { exit;
}

/**
 * Shortcode attributes
 *
 * @var $atts
 * @var $el_class
 * Shortcode class
 * @var $this Vckit_Shortcode_Onepage_Navigator
 */

$position =
$navigators =
$speed =
$nav_color =
$custom_class =
$el_class =
$top_offset = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );
$navigators = (array) vc_param_group_parse_atts( $navigators );
$el_class = $this->getExtraClass( $el_class );

$css_classes = array(
  'vckit-navigator',
  $position,
  $custom_class,
  $el_class,
);

$targets = array();
foreach ( $navigators as $item ) {
    if ( preg_match( '/^#\w+$/', $item['link'] ) ) {
        $targets[] = $item['link'];
    }
}

$id = 'vckit-navigator-' . rand();

?>
<div class="<?php echo esc_attr( implode( ' ', $css_classes ) ) ?>"
  id="<?php echo esc_attr( $id ) ?>"
  data-target="<?php echo esc_attr( implode( ',', $targets ) ) ?>"
  data-offset="<?php echo esc_attr( $top_offset ) ?>"
  data-speed="<?php echo esc_attr( $speed ) ?>"
>
  <ul class="list">
    <?php foreach ( $navigators as $navigator ) : ?>
      <li>
        <a
          href="<?php if ( isset( $navigator['link'] ) ) { echo esc_url( $navigator['link'] );
         } ?>"
          data-balloon="<?php if ( isset( $navigator['title'] ) ) { echo esc_attr( $navigator['title'] );
         } ?>"
          data-balloon-pos="<?php
            if ( 'bottom' === $position ) {
                echo 'up';
            } elseif ( 'left' === $position ) {
                echo 'right';
            } elseif ( 'right' === $position ) {
                echo 'left';
            }
            ?>">
          <div class="dot <?php if ( isset( $navigator['add_icon'] ) && 'yes' === $navigator['add_icon'] ) { echo 'dot-has-icon';
         } ?>">
            <?php
            if ( isset( $navigator['add_icon'] ) && 'yes' === $navigator['add_icon'] ) {
                $navigator['icon_type'] = 'fontawesome';
                $iconClass = $this->getIconClass( $navigator );
                ?>
              <i class="<?php echo esc_attr( $iconClass ) ?>"></i>
            <?php } ?>
            <?php
            if ( isset( $navigator['navigator'] ) ) {
                echo esc_html( $navigator['navigator'] );
            }
            ?>
          </div>
        </a>
      </li>
    <?php endforeach; ?>
  </ul>
</div>
