<?php

/**
 * Shortcode attributes
 *
 * @var $url
 * @var $el_class
 * Shortcode class
 * @var $this Vckit_Shortcode_Video
 */

$align =
$el_class = '';

$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$css_classes = array(
  'vckit-sharer',
  'vckit-sharer-' . ( ( 'yes' == $open_new_window ) ? 'openwindow' : 'openself' ),
  $el_class,
);

$styles = array();
if ( $background_color ) {
    $styles[] = 'background:' . $background_color;
}
if ( $color ) {
    $styles[] = 'color:' . $color;
}

if ( ! empty( $styles ) ) {
    $item_style = 'style="' . esc_attr( implode( ';', $styles ) ) . '"';
} else {
    $item_style = '';
}

global $wp;
$current_url = get_permalink();
$current_url = urlencode( $current_url );

?>
<ul class="<?php echo esc_attr( implode( ' ', $css_classes ) ); ?>" data-type="<?php echo esc_attr( $style ) ?>" style="text-align: <?php echo esc_attr( $align ) ?>">
    <?php if ( 'yes' == $facebook ) { ?>
  <li>
  <a class="vckit-sharer-link vckit-sharer-link-facebook" href="http://www.facebook.com/sharer.php?u=<?php echo $current_url; //@codingStandardsIgnoreLine ?>" <?php echo $item_style; // @codingStandardsIgnoreLine ?>>
      <span class="fa fa-facebook"></span>
    </a>
  </li>
    <?php } ?>
    <?php if ( 'yes' == $twitter ) { ?>
  <li>
    <a class="vckit-sharer-link vckit-sharer-link-twitter" href="https://twitter.com/home?status=<?php echo $current_url; //@codingStandardsIgnoreLine ?>" <?php echo $item_style; // @codingStandardsIgnoreLine ?>>
      <span class="fa fa-twitter"></span>
    </a>
  </li>
    <?php } ?>
    <?php if ( 'yes' == $google ) { ?>
  <li>
    <a class="vckit-sharer-link vckit-sharer-link-google" href="https://plus.google.com/share?url=<?php echo $current_url; //@codingStandardsIgnoreLine ?>" <?php echo $item_style; // @codingStandardsIgnoreLine ?>>
      <span class="fa fa-google-plus"></span>
    </a>
  </li>
    <?php } ?>
    <?php if ( 'yes' == $linkedin ) { ?>
  <li>
    <a class="vckit-sharer-link vckit-sharer-link-linkedin" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo $current_url; //@codingStandardsIgnoreLine ?>" <?php echo $item_style; // @codingStandardsIgnoreLine ?>>
      <span class="fa fa-linkedin"></span>
    </a>
  </li>
    <?php } ?>
    <?php if ( 'yes' == $pinterest ) { ?>
  <li>
    <a class="vckit-sharer-link vckit-sharer-link-pinterest" href="https://pinterest.com/pin/create/button/?url=<?php echo $current_url; //@codingStandardsIgnoreLine ?>" <?php echo $item_style; // @codingStandardsIgnoreLine ?>>
      <span class="fa fa-pinterest"></span>
    </a>
  </li>
    <?php } ?>
  </li>
</ul>
